/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevPlugin;
import net.minecraftforge.forgedev.MavenizerValueSource;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import net.minecraftforge.forgedev.tasks.mcp.MCPSetupFiles;
import net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.util.data.json.JsonData;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaLauncher;

public abstract class LegacyMCPExtension {
    public static final String EXTENSION_NAME = "mcp";
    private final Property<String> config = this.getObjects().property(String.class);
    private final Property<String> version = this.getObjects().property(String.class).value(this.config.map(s -> MavenInfo.from(s).art().version()));
    private final Map<String, MinecraftFiles> files = new HashMap<String, MinecraftFiles>();
    private final ForgeDevPlugin plugin;
    private final Problems problems = (Problems)((Object)this.getObjects().newInstance(Problems.class, new Object[0]));

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public LegacyMCPExtension(ForgeDevPlugin plugin) {
        this.plugin = plugin;
    }

    public Property<String> getConfig() {
        return this.config;
    }

    public Property<String> getVersion() {
        return this.version;
    }

    public void setConfig(Provider<String> value) {
        this.getConfig().set(value.map(s -> {
            if (s.indexOf(58) != -1) {
                return s;
            }
            return "de.oceanlabs.mcp:mcp_config:" + s + "@zip";
        }));
    }

    public void setConfig(String value) {
        this.setConfig((Provider<String>)this.getProviders().provider(() -> value));
    }

    public abstract Property<String> getPipeline();

    public String getArtifact() {
        return (String)this.getConfig().get();
    }

    public Provider<String> getArtifact(String classifier) {
        return this.getArtifact(classifier, "jar");
    }

    public Provider<String> getArtifact(String classifier, String extension) {
        return this.getConfig().map(str -> {
            MavenInfo.ArtifactInfo info = MavenInfo.from(str).art();
            MavenInfo _new = MavenInfo.from(info.group(), info.name(), info.version(), classifier, extension);
            return _new.name();
        });
    }

    public MinecraftFiles getFiles() {
        return this.getFiles((String)this.getVersion().get());
    }

    public MinecraftFiles getFiles(String version) {
        MinecraftFiles ret = this.files.get(version);
        if (ret == null) {
            Output joined = this.mavenizer("joined", version, true);
            ret = (MinecraftFiles)this.getObjects().newInstance(MinecraftFiles.class, new Object[]{this.plugin, joined.info, joined.output});
            this.files.put(version, ret);
        }
        return ret;
    }

    private Output mavenizer(String pipeline, String version, boolean searge) {
        String fileName = "mavenizer/mcp-" + version + "-files-" + pipeline;
        if (searge) {
            fileName = fileName + "-searge";
        }
        File output = ((RegularFile)this.plugin.localCaches().file("mavenizer/" + fileName + ".jar").get()).getAsFile();
        File outputJson = ((RegularFile)this.plugin.localCaches().file("mavenizer/" + fileName + ".json").get()).getAsFile();
        Provider info = this.getProviders().of(MavenizerValueSource.class, spec -> spec.parameters(params -> {
            Tool.Resolved tool = this.plugin.getTool(Tools.MAVENIZER);
            params.getClasspath().setFrom((Iterable)tool.getClasspath());
            params.getJavaLauncher().set(tool.getJavaLauncher().map(JavaLauncher::getExecutablePath));
            params.getArguments().set(this.getProviders().provider(() -> {
                Provider toolCache = this.plugin.globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.problems.ensureFileLocation());
                String cache = ((Directory)toolCache.get()).dir("caches").getAsFile().getAbsolutePath();
                ArrayList<String> ret = new ArrayList<String>(List.of("--mcp", "--cache", cache, "--jdk-cache", cache, "--version", version, "--raw", "--pipeline", pipeline, "--output", output.getAbsolutePath(), "--output-files", outputJson.getAbsolutePath()));
                if (searge) {
                    ret.add("--searge");
                }
                return ret;
            }));
        })).map(v -> (MCPSetupFiles)JsonData.fromJson((File)outputJson, MCPSetupFiles.class));
        return new Output((Provider<MCPSetupFiles>)info, output);
    }

    public static abstract class Problems
    extends EnhancedProblems {
        @Inject
        public Problems() {
            super("forgedev.mcp", "ForgeDev - MCP");
        }
    }

    public static abstract class MinecraftFiles {
        private final ForgeDevPlugin plugin;
        private final Provider<MCPSetupFiles> info;
        private final File joinedSearge;

        @Inject
        protected abstract ObjectFactory getObjects();

        @Inject
        protected abstract ProviderFactory getProviders();

        @Inject
        public MinecraftFiles(ForgeDevPlugin plugin, Provider<MCPSetupFiles> info, File joinedSearge) {
            this.plugin = plugin;
            this.info = info;
            this.joinedSearge = joinedSearge;
        }

        private Provider<RegularFile> get(Transformer<String, MCPSetupFiles> field) {
            return this.info.map(field).flatMap(arg_0 -> ((DirectoryProperty)this.plugin.rootProjectDirectory()).file(arg_0));
        }

        public Provider<RegularFile> getLauncherManifest() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.versionManifest));
        }

        public Provider<RegularFile> getVersionJson() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.versionJson));
        }

        public Provider<RegularFile> getClient() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.clientRaw));
        }

        public Provider<RegularFile> getClientMappings() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.clientMappings));
        }

        public Provider<RegularFile> getServer() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.serverRaw));
        }

        public Provider<RegularFile> getServerExtracted() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.serverExtracted));
        }

        public Provider<RegularFile> getServerMappings() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.serverMappings));
        }

        public Provider<RegularFile> getLibraryList() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> info.librariesList));
        }

        public Provider<RegularFile> getJoinedSearge() {
            return this.get((Transformer<String, MCPSetupFiles>)((Transformer)info -> this.joinedSearge.getAbsolutePath()));
        }
    }

    private record Output(Provider<MCPSetupFiles> info, File output) {
    }
}

