/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.shim;

import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevExtension;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.forgedev.legacy.tasks.DownloadDependency;
import net.minecraftforge.forgedev.tasks.shim.ShimClasspath;
import net.minecraftforge.forgedev.tasks.shim.ShimConfig;
import net.minecraftforge.gradleutils.shared.SharedUtil;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.ApiStatus;

public abstract class Shim {
    public static final String DEFAULT_NAME = "serverShim";
    private final Project project;
    private final String name;
    private final TaskProvider<ShimClasspath> classpath;
    private final TaskProvider<Jar> jar;
    private final TaskProvider<ShimConfig> config;
    private final TaskProvider<DownloadDependency> base;

    @Inject
    public Shim(Project project, String name, TaskProvider<ShimClasspath> classpath, TaskProvider<Jar> jar, TaskProvider<DownloadDependency> base, TaskProvider<ShimConfig> config) {
        this.project = project;
        this.name = name;
        this.classpath = classpath;
        this.jar = jar;
        this.base = base;
        this.config = config;
    }

    public TaskProvider<ShimClasspath> getClasspath() {
        return this.classpath;
    }

    public void classpath(Action<ShimClasspath> action) {
        this.getClasspath().configure(action);
    }

    public TaskProvider<Jar> getJar() {
        return this.jar;
    }

    public void jar(Action<Jar> action) {
        this.getJar().configure(action);
    }

    public TaskProvider<ShimConfig> getConfig() {
        return this.config;
    }

    public void config(Action<ShimConfig> action) {
        this.getConfig().configure(action);
    }

    public void setBaseVersion(String version) {
        SharedUtil.SimpleModuleVersionIdentifier module = (SharedUtil.SimpleModuleVersionIdentifier)Tools.SHIM.getModule();
        this.setBase(module.withVersion(version).toString());
    }

    public void setBase(String artifact) {
        this.base.configure(task -> task.setArtifact(artifact));
    }

    @ApiStatus.Internal
    public static Shim register(Project project, ForgeDevExtension ext, String name) {
        TaskProvider<DownloadDependency> base = DownloadDependency.register(project, name + "DownloadBase", Tools.SHIM.getModule().toString());
        TaskProvider classpath = project.getTasks().register(name + "Classpath", ShimClasspath.class);
        classpath.configure(task -> task.setGroup("Generation"));
        TaskProvider config = project.getTasks().register(name + "Config", ShimConfig.class);
        TaskProvider jar = project.getTasks().register(name + "Jar", Jar.class);
        jar.configure(task -> {
            task.setGroup("build");
            task.getArchiveClassifier().set((Object)"shim");
            task.from((Object)config.flatMap(ShimConfig::getOutput), cfg -> cfg.rename(ignore -> "bootstrap-shim.properties"));
            task.from((Object)classpath.flatMap(ShimClasspath::getOutput), cfg -> cfg.rename(ignore -> "bootstrap-shim.list"));
            Provider baseZip = project.getProviders().provider(() -> project.zipTree((Object)base.flatMap(DownloadDependency::getOutput)));
            task.from((Object)baseZip, spec -> spec.exclude(new String[]{"META-INF/MANIFEST.MF"}));
            Provider baseManifest = baseZip.map(tree -> tree.getFiles().stream().filter(f -> f.getName().equals("MANIFEST.MF")).findFirst().orElseThrow());
            task.manifest(manifest -> manifest.from(new Object[]{baseManifest}));
        });
        return (Shim)project.getObjects().newInstance(Shim.class, new Object[]{project, name, classpath, jar, base, config});
    }
}

