/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.installer;

import java.util.List;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevExtension;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.forgedev.legacy.tasks.DownloadDependency;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.LibraryInfo;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import net.minecraftforge.forgedev.tasks.SingleFileOutput;
import net.minecraftforge.forgedev.tasks.installer.InstallerJar;
import net.minecraftforge.forgedev.tasks.installer.InstallerJarConfig;
import net.minecraftforge.forgedev.tasks.installer.InstallerJson;
import net.minecraftforge.forgedev.tasks.installer.LauncherJson;
import net.minecraftforge.forgedev.tasks.installer.Tool;
import net.minecraftforge.gradleutils.shared.SharedUtil;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class Installer {
    static final List<String> JSON_COMMENT = List.of("Please do not automate the download and installation of Forge.", "Our efforts are supported by ads from the download page.", "If you MUST automate this, please consider supporting the project through https://www.patreon.com/LexManos/");
    private final Project project;
    private final String name;
    private final TaskProvider<InstallerJar> jar;
    private final TaskProvider<InstallerJson> json;
    private final TaskProvider<LauncherJson> launcherJson;
    private final TaskProvider<InstallerJarConfig> jarConfig;
    private final TaskProvider<DownloadDependency> base;
    @ApiStatus.Internal
    public static final String DEFAULT_NAME = "installer";

    @Input
    public abstract Property<Boolean> getDev();

    @Input
    public abstract Property<Boolean> getOffline();

    @Inject
    public Installer(Project project, String name, TaskProvider<InstallerJar> jar, TaskProvider<InstallerJarConfig> jarConfig, TaskProvider<InstallerJson> json, TaskProvider<LauncherJson> launcherJson, TaskProvider<DownloadDependency> base) {
        this.project = project;
        this.name = name;
        this.jar = jar;
        this.jarConfig = jarConfig;
        this.json = json;
        this.launcherJson = launcherJson;
        this.base = base;
        this.getDev().convention((Object)false);
        this.getOffline().convention((Object)false);
    }

    public String getName() {
        return this.name;
    }

    public TaskProvider<InstallerJar> getJar() {
        return this.jar;
    }

    public void jar(Action<? super InstallerJar> action) {
        this.getJar().configure(action);
    }

    public TaskProvider<@NotNull InstallerJson> getJson() {
        return this.json;
    }

    public void json(Action<? super InstallerJson> action) {
        this.getJson().configure(action);
    }

    public TaskProvider<LauncherJson> getLauncherJson() {
        return this.launcherJson;
    }

    public void launcherJson(Action<? super LauncherJson> action) {
        this.getLauncherJson().configure(action);
    }

    public Tool tool(Object dependency) {
        return this.tool(dependency, true);
    }

    public Tool tool(Object dependency, boolean transitive) {
        String gav = Util.asArtifactString(dependency);
        List tree = (List)MinimalResolvedArtifact.from(this.project, gav, transitive).get();
        this.jarConfig.configure(task -> {
            for (MinimalResolvedArtifact artifact : tree) {
                task.library((Provider<MinimalResolvedArtifact>)this.project.provider(() -> artifact), Util.noop());
            }
        });
        return new Tool(gav, tree);
    }

    public void pack(TaskProvider<? extends AbstractArchiveTask> task) {
        this.pack(task, Util.noop());
    }

    public void pack(TaskProvider<? extends AbstractArchiveTask> task, Action<LibraryInfo> action) {
        this.pack(MinimalResolvedArtifact.from(this.project, task), action);
    }

    public void pack(Provider<MinimalResolvedArtifact> info) {
        this.pack(info, Util.noop());
    }

    public void pack(Provider<MinimalResolvedArtifact> info, Action<LibraryInfo> action) {
        this.getJson().configure(task -> task.library(info, action));
        this.getJar().configure(task -> task.pack(info));
    }

    public void library(String artifact) {
        this.library(artifact, Util.noop());
    }

    public void library(String artifact, Action<LibraryInfo> action) {
        this.library(MinimalResolvedArtifact.single(this.project, artifact), action);
    }

    public void library(TaskProvider<? extends AbstractArchiveTask> task) {
        this.library(task, Util.noop());
    }

    public void library(TaskProvider<? extends AbstractArchiveTask> task, Action<LibraryInfo> action) {
        this.library(MinimalResolvedArtifact.from(this.project, task), action);
    }

    public void library(Provider<MinimalResolvedArtifact> info) {
        this.library(info, Util.noop());
    }

    public void library(Provider<MinimalResolvedArtifact> info, Action<LibraryInfo> action) {
        this.getJson().configure(task -> task.library(info, action));
        this.jarConfig.configure(task -> task.library(info, action));
    }

    public void launcherLibraries(Configuration configuration) {
        this.getLauncherJson().configure(task -> task.libraries(configuration));
        this.jarConfig.configure(task -> task.libraries(configuration));
    }

    public void launcherLibrary(String artifact) {
        this.launcherLibrary(artifact, Util.noop());
    }

    public void launcherLibrary(String artifact, Action<LibraryInfo> action) {
        this.launcherLibrary(MinimalResolvedArtifact.single(this.project, artifact), action);
    }

    public void launcherLibrary(TaskProvider<? extends AbstractArchiveTask> task) {
        this.launcherLibrary(task, Util.noop());
    }

    public void launcherLibrary(TaskProvider<? extends AbstractArchiveTask> task, Action<LibraryInfo> action) {
        this.launcherLibrary(MinimalResolvedArtifact.from(this.project, task), action);
    }

    public void launcherLibrary(TaskProvider<? extends SingleFileOutput> task, String classifier) {
        this.launcherLibrary(task, classifier, Util.noop());
    }

    public void launcherLibrary(TaskProvider<? extends SingleFileOutput> task, String classifier, Action<LibraryInfo> action) {
        this.launcherLibrary(MinimalResolvedArtifact.from(MavenInfo.from(this.project, classifier), (Provider<RegularFile>)task.flatMap(rec$ -> ((SingleFileOutput)rec$).getOutput())), action);
    }

    public void launcherLibrary(Provider<MinimalResolvedArtifact> info) {
        this.launcherLibrary(info, Util.noop());
    }

    public void launcherLibrary(Provider<MinimalResolvedArtifact> info, Action<LibraryInfo> action) {
        this.getLauncherJson().configure(task -> task.library(info, action));
        this.jarConfig.configure(task -> task.library(info, action));
    }

    public void setBaseVersion(String version) {
        SharedUtil.SimpleModuleVersionIdentifier module = (SharedUtil.SimpleModuleVersionIdentifier)Tools.INSTALLER.getModule();
        this.setBase(module.withVersion(version).toString());
    }

    public void setBase(String artifact) {
        this.base.configure(task -> task.setArtifact(artifact));
    }

    @ApiStatus.Internal
    public static Installer register(Project project, ForgeDevExtension ext, String name) {
        Installer ret;
        TaskContainer tasks = project.getTasks();
        class Holder {
            Installer value;

            Holder() {
            }
        }
        Holder holder = new Holder();
        Provider self = project.getProviders().provider(() -> holder.value);
        TaskProvider<DownloadDependency> base = DownloadDependency.register(project, name + "DownloadBase", Tools.INSTALLER.getModule().toString());
        TaskProvider jarConfig = tasks.register(name + "JarConfig", InstallerJarConfig.class, new Object[]{self, base});
        TaskProvider jar = tasks.register(name + "Jar", InstallerJar.class);
        TaskProvider json = tasks.register(name + "Json", InstallerJson.class);
        TaskProvider launcherJson = tasks.register(name + "LauncherJson", LauncherJson.class);
        Directory baseDir = (Directory)project.getLayout().getBuildDirectory().dir(name).get();
        holder.value = ret = (Installer)project.getObjects().newInstance(Installer.class, new Object[]{project, name, jar, jarConfig, json, launcherJson, base});
        ret.getDev().convention((Object)(!ext.isCi() ? 1 : 0));
        jar.configure(task -> {
            task.getArchiveClassifier().set((Object)Util.kebab(name));
            task.dependsOn(new Object[]{jarConfig});
            task.setGroup("build");
            task.from(new Object[]{json, launcherJson});
        });
        json.configure(task -> task.getOutput().set((Object)baseDir.file("install_profile.json")));
        launcherJson.configure(task -> task.getOutput().set((Object)baseDir.file("version.json")));
        return ret;
    }
}

