/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.tasks;

import de.undercouch.gradle.tasks.download.Download;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.MergeJars;
import net.minecraftforge.forgedev.legacy.values.LatestForgeVersion;
import net.minecraftforge.forgedev.tasks.jarcompat.CheckJarCompatibility;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerRawArtifact;
import net.minecraftforge.forgedev.tasks.obfuscation.LegacyReobfuscateJar;
import net.minecraftforge.forgedev.tasks.patching.binary.ApplyBinPatches;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public class CheckForgeJarCompatibility {
    private static final String TASK_NAME = "checkJarCompatibility";

    public static TaskProvider<CheckJarCompatibility> register(Project project, String minecraftVersion, Action<? super CheckJarCompatibility> action) {
        if (project.getTasks().getNames().contains(TASK_NAME)) {
            throw new IllegalStateException("Cannot register checkJarCompatibility more than once");
        }
        Property baseForgeVersion = project.getObjects().property(String.class).value(project.getProviders().of(LatestForgeVersion.class, LatestForgeVersion.parameters(project, minecraftVersion)));
        Spec baseForgeVersionOnlyIf = t -> baseForgeVersion.isPresent();
        Provider baseForgeUserdev = project.getLayout().getBuildDirectory().file(project.provider(() -> "checkJarCompatibility/forge-" + (String)baseForgeVersion.getOrElse((Object)"null") + "-userdev.jar"));
        Provider baseForgeUniversal = project.getLayout().getBuildDirectory().file(project.provider(() -> "checkJarCompatibility/forge-" + (String)baseForgeVersion.getOrElse((Object)"null") + "-universal.jar"));
        TaskProvider downloadBaseForgeUserdev = project.getTasks().register("downloadBaseForgeUserdev", Download.class, task -> {
            task.setDescription("Sets up JAR compatibility checking by downloading the latest available UserDev.");
            task.onlyIf(baseForgeVersionOnlyIf);
            task.src((Object)("https://maven.minecraftforge.net/net/minecraftforge/forge/" + (String)baseForgeVersion.getOrElse((Object)"null") + "/forge-" + (String)baseForgeVersion.getOrElse((Object)"null") + "-userdev.jar"));
            task.dest((Object)baseForgeUserdev);
        });
        TaskProvider extractBaseForgeUserdevBinPatches = project.getTasks().register("extractBaseForgeUserdevBinPatches", UserdevBinPatches.class, task -> {
            task.setDescription("Sets up JAR compatibility checking by extracting the binary patches from the latest available UserDev.");
            task.onlyIf(baseForgeVersionOnlyIf);
            task.dependsOn(new Object[]{downloadBaseForgeUserdev});
            task.getBaseForgeUserdev().fileProvider(downloadBaseForgeUserdev.map(Download::getDest));
        });
        Provider applyBaseCompatibilityJarBinPatchesOutput = project.getLayout().getBuildDirectory().file("applyBaseCompatibilityJarBinPatches/output.jar");
        TaskProvider applyBaseCompatibilityJarBinPatches = project.getTasks().register("applyBaseCompatibilityJarBinPatches", ApplyBinPatches.class, task -> {
            task.setDescription("Sets up JAR compatibility checking by applying the base jar's binary patches from the latest available UserDev.");
            task.onlyIf(baseForgeVersionOnlyIf);
            task.dependsOn(new Object[]{extractBaseForgeUserdevBinPatches});
            task.getClean().setFrom(new Object[]{task.getProject().getTasks().named("rawJoinedJarSrg", MavenizerRawArtifact.class).flatMap(rec$ -> ((MavenizerRawArtifact)rec$).getOutput())});
            task.getApply().setFrom(new Object[]{extractBaseForgeUserdevBinPatches.flatMap(UserdevBinPatches::getBaseBinPatchesOutput)});
            task.getOutput().set(applyBaseCompatibilityJarBinPatchesOutput);
        });
        TaskProvider downloadBaseForgeUniversal = project.getTasks().register("downloadBaseForgeUniversal", Download.class, task -> {
            task.setDescription("Sets up JAR compatibility checking by downloading the latest available universal JAR.");
            task.onlyIf(baseForgeVersionOnlyIf);
            task.src((Object)("https://maven.minecraftforge.net/net/minecraftforge/forge/" + (String)baseForgeVersion.getOrElse((Object)"null") + "/forge-" + (String)baseForgeVersion.getOrElse((Object)"null") + "-universal.jar"));
            task.dest((Object)baseForgeUniversal);
        });
        TaskProvider mergeBaseForgeJar = project.getTasks().register("mergeBaseForgeJar", MergeJars.class, task -> {
            task.setDescription("Sets up JAR compatibility checking by merging the universal JAR with the binary patched JAR.");
            task.onlyIf(baseForgeVersionOnlyIf);
            task.dependsOn(new Object[]{downloadBaseForgeUniversal});
            task.getInputJars().from(new Object[]{applyBaseCompatibilityJarBinPatches.flatMap(rec$ -> ((ApplyBinPatches)rec$).getOutput()), downloadBaseForgeUniversal.map(Download::getDest)});
        });
        TaskProvider reobfJar = project.getTasks().named("reobfJar", LegacyReobfuscateJar.class);
        TaskProvider checkJarCompatibility = project.getTasks().register(TASK_NAME, CheckJarCompatibility.class, task -> {
            TaskProvider rawJoinedJarSrg = task.getProject().getTasks().named("rawJoinedJarSrg", MavenizerRawArtifact.class);
            task.setGroup("verification");
            task.setDescription("Checks the JAR compatibility between the built JAR and the latest available JAR.");
            task.onlyIf(t -> baseForgeVersion.isPresent());
            task.dependsOn(new Object[]{rawJoinedJarSrg, mergeBaseForgeJar});
            task.getBaseJar().set(mergeBaseForgeJar.flatMap(MergeJars::getOutput));
            task.getBaseLibraries().from(new Object[]{rawJoinedJarSrg.flatMap(rec$ -> ((MavenizerRawArtifact)rec$).getOutput())});
            task.getInputJar().set(reobfJar.flatMap(LegacyReobfuscateJar::getOutput));
        });
        checkJarCompatibility.configure(action);
        ProviderFactory providers = project.getProviders();
        boolean hasMaven = providers.environmentVariable("MAVEN_USER").isPresent() && providers.environmentVariable("MAVEN_PASSWORD").isPresent();
        Boolean checkCompatibility = (Boolean)providers.gradleProperty("net.minecraftforge.forge.build.check.compatibility").map(Boolean::parseBoolean).getOrElse((Object)false);
        if (!hasMaven && checkCompatibility.booleanValue()) {
            project.getTasks().named("check", task -> task.dependsOn(new Object[]{checkJarCompatibility}));
        }
        return checkJarCompatibility;
    }

    static abstract class UserdevBinPatches
    extends DefaultTask {
        @InputFile
        @Optional
        protected abstract RegularFileProperty getBaseForgeUserdev();

        @OutputFile
        abstract RegularFileProperty getBaseBinPatchesOutput();

        @Inject
        protected abstract ProjectLayout getLayout();

        @Inject
        protected abstract ArchiveOperations getArchiveOperations();

        @Inject
        public UserdevBinPatches() {
            this.getBaseBinPatchesOutput().convention(this.getLayout().getBuildDirectory().file(this.getName() + "/joined.lzma"));
        }

        @TaskAction
        protected void exec() {
            File joinedLzma = this.getArchiveOperations().zipTree((Object)this.getBaseForgeUserdev()).matching(it -> it.include(new String[]{"joined.lzma"})).getSingleFile();
            try {
                Files.copy(joinedLzma.toPath(), ((File)this.getBaseBinPatchesOutput().getAsFile().get()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

