/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.mcp;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevPlugin;
import net.minecraftforge.forgedev.ForgeDevProblems;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.process.ExecOperations;

abstract class MavenizerValueSource<T, P extends Parameters>
implements ValueSource<T, P> {
    private static final Logger LOGGER = Logging.getLogger(MavenizerValueSource.class);

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    public MavenizerValueSource() {
    }

    protected int exec() {
        return this.getExecOperations().javaexec(spec -> {
            Parameters params = (Parameters)this.getParameters();
            spec.setClasspath((FileCollection)params.getClasspath());
            spec.setExecutable((String)params.getJavaLauncher().get());
            ArrayList<String> args = new ArrayList<String>();
            this.addArguments(args);
            spec.setArgs(args);
            LOGGER.info("Executing Mavenizer: ");
            Iterator itr = params.getClasspath().iterator();
            LOGGER.info("  Classpath: {}", (Object)((File)itr.next()).getAbsolutePath());
            while (itr.hasNext()) {
                LOGGER.info("             {}", (Object)((File)itr.next()).getAbsolutePath());
            }
            LOGGER.info("  Java: {}", params.getJavaLauncher().get());
            List args2 = spec.getArgs();
            String prefix = "  Arguments: ";
            for (int x = 0; x < args2.size(); ++x) {
                String current = (String)args2.get(x);
                String next = args2.size() > x + 1 ? (String)args2.get(x + 1) : null;
                Object line = current;
                if (current.startsWith("--") && next != null && !next.startsWith("--")) {
                    ++x;
                    line = (String)line + " " + next;
                }
                LOGGER.info("{}{}", (Object)prefix, line);
                prefix = "             ";
            }
        }).rethrowFailure().assertNormalExitValue().getExitValue();
    }

    protected void addArguments(List<String> args) {
        Parameters parameters = (Parameters)this.getParameters();
        args.addAll(List.of("--cache", ((Directory)parameters.getCaches().get()).getAsFile().getAbsolutePath(), "--jdk-cache", ((Directory)parameters.getCaches().dir("jdks").get()).getAsFile().getAbsolutePath()));
    }

    static interface Parameters
    extends ValueSourceParameters {
        default public void init(ForgeDevPlugin plugin, ForgeDevProblems problems) {
            Tool.Resolved tool = plugin.getTool(Tools.MAVENIZER);
            this.getClasspath().convention((Iterable)tool.getClasspath());
            this.getJavaLauncher().convention(tool.getJavaLauncher().map(j -> j.getExecutablePath().getAsFile().getAbsolutePath()));
            this.getCaches().convention(plugin.globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH) + "/cache").map(problems.ensureFileLocation()));
        }

        public Property<String> getName();

        public ConfigurableFileCollection getClasspath();

        public Property<String> getJavaLauncher();

        public DirectoryProperty getCaches();
    }
}

