/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.forgedev.ForgeDevProblems;
import net.minecraftforge.forgedev.ForgeDevTask;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.forgedev.Util;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptions;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptionsInternal;
import net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class SlimeLauncherEclipseConfiguration
extends DefaultTask
implements ForgeDevTask {
    final ForgeDevProblems problems = (ForgeDevProblems)((Object)this.getObjects().newInstance(ForgeDevProblems.class, new Object[0]));

    @OutputFile
    protected abstract RegularFileProperty getOutputFile();

    @Input
    protected abstract Property<String> getProjectName();

    @Input
    protected abstract Property<String> getSourceSetName();

    @Input
    @Optional
    protected abstract Property<String> getEclipseProjectName();

    @Input
    protected abstract Property<String> getRunName();

    @Nested
    protected abstract Property<JavaLauncher> getJavaLauncher();

    @Input
    protected abstract ListProperty<String> getProjectDependencies();

    @InputFiles
    @Classpath
    protected abstract ConfigurableFileCollection getClasspath();

    @Input
    protected abstract Property<String> getMainClass();

    @Nested
    protected abstract Property<SlimeLauncherOptions> getOptions();

    @Internal
    protected abstract DirectoryProperty getCacheDir();

    @InputFiles
    protected abstract ConfigurableFileCollection getMetadata();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public SlimeLauncherEclipseConfiguration() {
        this.getProjectName().convention((Object)this.getProject().getName());
        this.getEclipseProjectName().convention(this.getProject().provider(() -> Util.getProjectEclipseName(this.getProject())));
        Tool.Resolved tool = this.getTool(Tools.SLIMELAUNCHER);
        this.getClasspath().from(new Object[]{tool.getClasspath()});
        this.getMainClass().set((Object)tool.getMainClass());
        this.getJavaLauncher().set(Util.launcherFor((Project)this.getProject(), (int)tool.getJavaVersion()));
    }

    @TaskAction
    protected void exec() {
        SlimeLauncherOptionsInternal options = ((SlimeLauncherOptionsInternal)this.getOptions().get()).inherit(Map.of(), (String)this.getSourceSetName().get());
        ArrayList<String> args = new ArrayList<String>((Collection)options.getArgs().getOrElse(List.of()));
        ArrayList<CallSite> jvmArgs = new ArrayList<CallSite>((Collection)options.getJvmArgs().getOrElse(List.of()));
        if (!options.getClasspath().isEmpty()) {
            this.getClasspath().setFrom((Iterable)options.getClasspath());
        }
        if (options.getMinHeapSize().filter(Util.IS_NOT_BLANK).isPresent()) {
            jvmArgs.add((CallSite)((Object)("-Xms" + (String)options.getMinHeapSize().get())));
        }
        if (options.getMaxHeapSize().filter(Util.IS_NOT_BLANK).isPresent()) {
            jvmArgs.add((CallSite)((Object)("-Xmx" + (String)options.getMaxHeapSize().get())));
        }
        for (Map.Entry property : ((Map)options.getSystemProperties().getOrElse(Map.of())).entrySet()) {
            jvmArgs.add((CallSite)((Object)("-D" + (String)property.getKey() + "=" + (String)property.getValue())));
        }
        MapProperty<String, String> environment = options.getEnvironment();
        DirectoryProperty workingDir = options.getWorkingDir();
        args.addAll(0, List.of("--main", (String)options.getMainClass().get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", this.getMetadata().getSingleFile().getAbsolutePath(), "--"));
        try {
            Files.createDirectories(((Directory)workingDir.get()).getAsFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        WorkQueue queue = this.getWorkerExecutor().classLoaderIsolation();
        queue.submit(Action.class, parameters -> {
            parameters.getOutputFile().set((Provider)this.getOutputFile());
            parameters.getEclipseProjectName().set(this.getEclipseProjectName().orElse(this.getProjectName()));
            parameters.getProjectDependencies().set(this.getProjectDependencies());
            parameters.getClasspath().setFrom((Iterable)this.getClasspath());
            parameters.getMainClass().set((Object)((String)this.getMainClass().get()));
            parameters.getArgs().set((Iterable)args);
            parameters.getJvmArgs().set((Iterable)jvmArgs);
            parameters.getWorkingDir().set((Provider)workingDir);
            parameters.getEnvironment().set((Provider)environment);
            parameters.getJavaHome().set(this.getJavaLauncher().map(j -> j.getMetadata().getInstallationPath()));
            parameters.getJavaVersion().set(this.getJavaLauncher().map(j -> j.getMetadata().getLanguageVersion().toString()));
        });
    }

    static abstract class Action
    implements WorkAction<Parameters> {
        private static final String CLASSPATH_ENTRY_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><runtimeClasspathEntry ";
        private static final String CLASSPATH_ENTRY_SUFFIX = " path=\"5\" />";

        @Inject
        public Action() {
        }

        public void execute() {
            Transformer transformer;
            DocumentBuilder documentBuilder;
            Parameters parameters = (Parameters)this.getParameters();
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (ParserConfigurationException | TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            Document launch = documentBuilder.newDocument();
            Element rootElement = launch.createElement("launchConfiguration");
            rootElement.setAttribute("type", "org.eclipse.jdt.launching.localJavaApplication");
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.PROJECT_ATTR", parameters.getEclipseProjectName().get());
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.MAIN_TYPE", parameters.getMainClass().get());
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.VM_ARGUMENTS", String.join((CharSequence)" ", (Iterable)parameters.getJvmArgs().get()));
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", String.join((CharSequence)" ", (Iterable)parameters.getArgs().get()));
            Action.stringAttribute(launch, rootElement, "org.eclipse.jdt.launching.WORKING_DIRECTORY", ((File)parameters.getWorkingDir().getAsFile().get()).getAbsolutePath());
            Action.mapAttribute(launch, rootElement, "org.eclipse.debug.core.environmentVariables", (Map)parameters.getEnvironment().get());
            Element classpathList = Action.classpathList(rootElement);
            Action.addClasspathProjects(classpathList, parameters.getProjectDependencies());
            Action.addClasspathLibraries(classpathList, (FileCollection)parameters.getClasspath());
            Action.addClasspathJava(classpathList, (String)parameters.getJavaVersion().get());
            Action.booleanAttribute(launch, rootElement, "org.eclipse.jdt.launching.DEFAULT_CLASSPATH", false);
            launch.appendChild(rootElement);
            DOMSource source = new DOMSource(launch);
            StreamResult result = new StreamResult((File)parameters.getOutputFile().getAsFile().get());
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }

        private static void stringAttribute(Document document, Element parent, String key, Object value) {
            Element attribute = document.createElement("stringAttribute");
            attribute.setAttribute("key", key);
            attribute.setAttribute("value", value.toString());
            parent.appendChild(attribute);
        }

        private static void booleanAttribute(Document document, Element parent, String key, boolean value) {
            Element attribute = document.createElement("booleanAttribute");
            attribute.setAttribute("key", key);
            attribute.setAttribute("value", Boolean.toString(value));
            parent.appendChild(attribute);
        }

        private static void listAttribute(Document document, Element parent, String key, Iterable<?> list) {
            Element attribute = document.createElement("listAttribute");
            attribute.setAttribute("key", key);
            for (Object v : list) {
                Element listEntry = document.createElement("listEntry");
                listEntry.setAttribute("value", v.toString());
                attribute.appendChild(listEntry);
            }
            parent.appendChild(attribute);
        }

        private static Element addChild(Element parent, String name) {
            Element ret = parent.getOwnerDocument().createElement(name);
            parent.appendChild(ret);
            return ret;
        }

        private static Element classpathList(Element parent) {
            Element attribute = Action.addChild(parent, "listAttribute");
            attribute.setAttribute("key", "org.eclipse.jdt.launching.CLASSPATH");
            return attribute;
        }

        private static void classpathEntry(Element parent, int type, String value) {
            Action.addChild(parent, "listEntry").setAttribute("value", CLASSPATH_ENTRY_PREFIX + value + " type=\"" + type + "\" path=\"5\" />");
        }

        private static void addClasspathLibraries(Element parent, FileCollection files) {
            for (File v : files.getFiles()) {
                Action.classpathEntry(parent, 2, "externalArchive=\"" + String.valueOf(v) + "\"");
            }
        }

        private static void addClasspathProjects(Element parent, ListProperty<String> projects) {
            for (String v : (List)projects.get()) {
                Action.classpathEntry(parent, 1, "projectName=\"" + v + "\"");
                Action.classpathEntry(parent, 4, "containerPath=\"org.eclipse.buildship.core.gradleclasspathcontainer\" javaProject=\"" + v + "\"");
            }
        }

        private static void addClasspathJava(Element parent, String version) {
            Action.classpathEntry(parent, 4, "containerPath=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-" + version + "\"");
        }

        private static void mapAttribute(Document document, Element parent, String key, Map<String, ?> map) {
            Element attribute = document.createElement("mapAttribute");
            attribute.setAttribute("key", key);
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                Element mapEntry = document.createElement("mapEntry");
                mapEntry.setAttribute("key", k);
                mapEntry.setAttribute("value", v.toString());
                attribute.appendChild(mapEntry);
            }
            parent.appendChild(attribute);
        }

        static interface Parameters
        extends WorkParameters {
            public RegularFileProperty getOutputFile();

            public Property<String> getEclipseProjectName();

            public ListProperty<String> getProjectDependencies();

            public ConfigurableFileCollection getClasspath();

            public Property<String> getMainClass();

            public ListProperty<String> getArgs();

            public ListProperty<String> getJvmArgs();

            public DirectoryProperty getWorkingDir();

            public DirectoryProperty getJavaHome();

            public Property<String> getJavaVersion();

            public MapProperty<String, String> getEnvironment();
        }
    }
}

