/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.ForgeBuildProblems;
import net.minecraftforge.forgedev.legacy.tasks.BundleList;
import net.minecraftforge.forgedev.tasks.filtering.LegacyFilterNewJar;
import net.minecraftforge.forgedev.tasks.generation.GeneratePatcherConfigV2;
import net.minecraftforge.forgedev.tasks.installertools.DownloadMappings;
import net.minecraftforge.forgedev.tasks.installertools.ExtractInheritance;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerMCPSetup;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerRawArtifact;
import net.minecraftforge.forgedev.tasks.obfuscation.LegacyRenameJar;
import net.minecraftforge.forgedev.tasks.obfuscation.LegacyReobfuscateJar;
import net.minecraftforge.forgedev.tasks.patching.binary.ApplyBinPatches;
import net.minecraftforge.forgedev.tasks.patching.binary.CreateBinPatches;
import net.minecraftforge.forgedev.tasks.patching.diff.ApplyPatches;
import net.minecraftforge.gradleutils.shared.EnhancedPlugin;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;

abstract class ForgeBuildPlugin
extends EnhancedPlugin<Project> {
    static final String NAME = "forge-build";
    static final String DISPLAY_NAME = "Forge Build";
    private final ForgeBuildProblems problems = (ForgeBuildProblems)((Object)this.getObjects().newInstance(ForgeBuildProblems.class, new Object[0]));

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    public ForgeBuildPlugin() {
        super(NAME, DISPLAY_NAME, "forgeTools");
    }

    public void setup(Project project) {
        project.getPluginManager().apply("de.undercouch.download");
        ProviderFactory providers = this.getProviders();
        ProjectLayout layout = this.getLayout();
        ArchiveOperations archiveOperations = this.getArchiveOperations();
        TaskContainer tasks = project.getTasks();
        project.getPluginManager().withPlugin("net.minecraftforge.forgedev", forgedevAppliedPlugin -> {
            TaskProvider setupMCP = tasks.named("setupMCP", MavenizerMCPSetup.class);
            TaskProvider downloadClientMappings = tasks.named("downloadClientMappings", DownloadMappings.class);
            TaskProvider downloadServerMappings = tasks.named("downloadServerMappings", DownloadMappings.class);
            TaskProvider jar = tasks.named("jar", Jar.class);
            TaskProvider extractInheritance = tasks.register("extractInheritance", ExtractInheritance.class, task -> {
                task.setGroup("Forge downloads");
                task.dependsOn(new Object[]{setupMCP});
                task.getAdditionalArgs().add((Object)"--annotations");
                task.getInput().fileProvider(tasks.named("genJoinedBinPatches", CreateBinPatches.class).map(t -> t.getClean().getSingleFile()));
                task.getLibraries().from(new Object[]{setupMCP.flatMap(MavenizerMCPSetup::getLibrariesList).map(libraries -> {
                    try {
                        return Files.readAllLines(libraries.getAsFile().toPath()).stream().map(File::new).toList();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                })});
            });
            TaskProvider createClientOfficial = tasks.register("createClientOfficial", LegacyRenameJar.class, task -> {
                task.dependsOn(new Object[]{setupMCP});
                task.getAdditionalArgs().addAll((Object[])new String[]{"--ann-fix", "--ids-fix", "--src-fix", "--record-fix", "--strip-sigs", "--reverse"});
                task.getMappings().set(downloadClientMappings.flatMap(DownloadMappings::getOutput));
                task.getInput().set(setupMCP.flatMap(MavenizerMCPSetup::getClientRaw));
                task.getOutput().set(task.getDefaultOutputFile());
            });
            TaskProvider createServerOfficial = tasks.register("createServerOfficial", LegacyRenameJar.class, task -> {
                task.dependsOn(new Object[]{setupMCP});
                task.getAdditionalArgs().addAll((Object[])new String[]{"--ann-fix", "--ids-fix", "--src-fix", "--record-fix", "--strip-sigs", "--reverse"});
                task.getMappings().set(downloadServerMappings.flatMap(DownloadMappings::getOutput));
                task.getInput().set(setupMCP.flatMap(MavenizerMCPSetup::getServerExtracted));
                task.getOutput().set(task.getDefaultOutputFile());
            });
            TaskProvider createServerShimClasspath = tasks.register("createServerShimClasspath", BundleList.class, task -> {
                task.dependsOn(new Object[]{setupMCP});
                task.getServerBundle().set(setupMCP.flatMap(MavenizerMCPSetup::getServerRaw));
            });
            TaskProvider genClientBinPatches = tasks.named("genClientBinPatches", CreateBinPatches.class, task -> {
                task.getClean().setFrom(new Object[]{createClientOfficial.flatMap(LegacyRenameJar::getOutput)});
                task.getCreate().setFrom(new Object[]{jar.flatMap(AbstractArchiveTask::getArchiveFile)});
            });
            TaskProvider genServerBinPatches = tasks.named("genServerBinPatches", CreateBinPatches.class, task -> {
                task.getClean().setFrom(new Object[]{createServerOfficial.flatMap(LegacyRenameJar::getOutput)});
                task.getCreate().setFrom(new Object[]{jar.flatMap(AbstractArchiveTask::getArchiveFile)});
            });
            TaskProvider genJoinedBinPatches = tasks.named("genJoinedBinPatches", CreateBinPatches.class, task -> task.getClean().setFrom(new Object[]{tasks.named("rawJoinedJarSrg", MavenizerRawArtifact.class).map(t -> t.getOutputs().getFiles())}));
            TaskProvider applyClientBinPatches = tasks.register("applyClientBinPatches", ApplyBinPatches.class, task -> {
                task.getClean().setFrom(new Object[]{createClientOfficial.flatMap(LegacyRenameJar::getOutput)});
                task.getApply().setFrom(new Object[]{genClientBinPatches.flatMap(rec$ -> ((CreateBinPatches)rec$).getOutput())});
                task.getData().set((Object)true);
                task.getUnpatched().set((Object)true);
            });
            TaskProvider applyServerBinPatches = tasks.register("applyServerBinPatches", ApplyBinPatches.class, task -> {
                task.getClean().setFrom(new Object[]{createServerOfficial.flatMap(LegacyRenameJar::getOutput)});
                task.getApply().setFrom(new Object[]{genServerBinPatches.flatMap(rec$ -> ((CreateBinPatches)rec$).getOutput())});
                task.getData().set((Object)true);
                task.getUnpatched().set((Object)true);
            });
            TaskProvider applyJoinedBinPatches = tasks.register("applyJoinedBinPatches", ApplyBinPatches.class, task -> {
                task.getClean().setFrom(new Object[]{genJoinedBinPatches.map(rec$ -> ((CreateBinPatches)rec$).getClean())});
                task.getApply().setFrom(new Object[]{genJoinedBinPatches.flatMap(rec$ -> ((CreateBinPatches)rec$).getOutput())});
            });
            TaskProvider applyPatches = tasks.named("applyPatches", ApplyPatches.class, task -> {
                task.getFailOnError().set((Object)(!this.problems.test("net.minecraftforge.forge.build.updating") ? 1 : 0));
                task.getRejects().convention(project.getRootProject().getLayout().getProjectDirectory().dir(providers.provider(() -> "rejects")).map(Directory::getAsFile));
                task.getArchiveRejects().unsetConvention();
            });
            TaskProvider reobfJar = tasks.named("reobfJar", LegacyReobfuscateJar.class);
            TaskProvider officialClassesJar = tasks.register("officialClassesJar", Zip.class, task -> {
                task.dependsOn(new Object[]{jar});
                task.getDestinationDirectory().set(layout.getBuildDirectory().dir("libs"));
                task.getArchiveClassifier().set((Object)"official-classes");
                task.getArchiveExtension().set((Object)"jar");
                task.from((Object)providers.provider(() -> archiveOperations.zipTree((Object)jar.flatMap(AbstractArchiveTask::getArchiveFile))), copy -> copy.include(new String[]{"**/*.class"}).exclude(new String[]{"mcp/**"}));
            });
            TaskProvider filterJarNew = tasks.named("filterJarNew", LegacyFilterNewJar.class, task -> {
                task.dependsOn(new Object[]{officialClassesJar});
                task.getInput().set(officialClassesJar.flatMap(AbstractArchiveTask::getArchiveFile));
            });
            TaskProvider filterJarNewSrg = tasks.register("filterJarNewSrg", LegacyFilterNewJar.class, task -> {
                task.dependsOn(new Object[]{reobfJar, filterJarNew});
                task.getInput().set(reobfJar.flatMap(LegacyReobfuscateJar::getOutput));
                task.getSrg().set(filterJarNew.flatMap(LegacyFilterNewJar::getSrg));
                task.getBlacklist().setFrom(new Object[]{filterJarNew.map(LegacyFilterNewJar::getBlacklist)});
            });
            TaskProvider universalJar = tasks.named("universalJar", Jar.class);
            TaskProvider universalJarSrg = tasks.register("universalJarSrg", Jar.class, task -> {
                task.dependsOn(new Object[]{filterJarNewSrg, universalJar});
                Provider filterNewJarSrgOutput = filterJarNewSrg.flatMap(LegacyFilterNewJar::getOutput);
                Provider universalJarOutput = universalJar.flatMap(AbstractArchiveTask::getArchiveFile);
                task.from(new Object[]{providers.provider(() -> archiveOperations.zipTree((Object)filterNewJarSrgOutput))});
                task.from(new Object[]{providers.provider(() -> archiveOperations.zipTree((Object)universalJarOutput))});
                task.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                task.getArchiveClassifier().set((Object)"universal-srg");
                task.setManifest((Manifest)universalJar.map(org.gradle.jvm.tasks.Jar::getManifest).get());
            });
            TaskProvider userdevConfig = tasks.named("userdevConfig", GeneratePatcherConfigV2.class, task -> task.getUniversal().set((Object)"%s:%s:%s:universal-srg@jar".formatted(project.getGroup(), project.getName(), project.getVersion())));
        });
    }
}

