/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.LibraryInfo;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import net.minecraftforge.forgedev.tasks.SingleFileOutput;
import net.minecraftforge.forgedev.tasks.installer.Installer;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.ApiStatus;

public abstract class LauncherJson
extends DefaultTask {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @InputFiles
    public abstract ConfigurableFileCollection getInput();

    @Input
    public abstract Property<String> getTimestamp();

    @Input
    public abstract Property<String> getReleaseTime();

    @Input
    public abstract Property<String> getId();

    @Input
    @Optional
    public abstract Property<String> getInheritsFrom();

    @Input
    public abstract Property<String> getType();

    @Input
    @Optional
    public abstract Property<String> getMainClass();

    @Input
    @Optional
    public abstract ListProperty<Object> getGameArgs();

    @Input
    @Optional
    public abstract ListProperty<Object> getJvmArgs();

    @Input
    public abstract ListProperty<LibraryInfo> getLibraries();

    @Input
    public abstract Property<Boolean> getSortLibraries();

    @Input
    public abstract Property<Boolean> getLibrariesLast();

    @Input
    public abstract Property<Boolean> getDuplicateLibraries();

    @Inject
    public LauncherJson() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().file("libs/version.json"));
        String timestamp = Util.iso8601Now();
        this.getTimestamp().convention((Object)timestamp);
        this.getReleaseTime().convention((Object)timestamp);
        this.getType().convention((Object)"release");
        this.getMainClass().convention((Object)"main");
        this.getSortLibraries().convention((Object)true);
        this.getLibrariesLast().convention((Object)true);
        this.getDuplicateLibraries().convention((Object)false);
    }

    @ApiStatus.Internal
    public void libraries(Configuration config) {
        this.getInput().from(new Object[]{config});
        this.getLibraries().addAll(MinimalResolvedArtifact.from(this.getProject(), config).map(LibraryInfo::toList));
    }

    @ApiStatus.Internal
    public void library(Provider<MinimalResolvedArtifact> info, Action<LibraryInfo> action) {
        this.getInput().from(new Object[]{info.map(MinimalResolvedArtifact::file)});
        this.getLibraries().add(info.map(LibraryInfo::from).map(LibraryInfo.apply(action)));
    }

    public void generated(TaskProvider<? extends SingleFileOutput> task, String classifier) {
        this.generated(task, classifier, (Action<LibraryInfo>)((Action)t -> {}));
    }

    public void generated(TaskProvider<? extends SingleFileOutput> task, String classifier, Action<LibraryInfo> action) {
        this.library(MinimalResolvedArtifact.from(MavenInfo.from(this.getProject(), classifier), (Provider<RegularFile>)task.flatMap(rec$ -> ((SingleFileOutput)rec$).getOutput())), (Action<LibraryInfo>)((Action)info -> {
            action.execute(info);
            info.downloads().artifact().url = "";
        }));
    }

    @TaskAction
    protected void exec() throws IOException {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("_comment", Installer.JSON_COMMENT);
        json.put("id", this.getId().get());
        json.put("time", this.getTimestamp().get());
        json.put("releaseTime", this.getReleaseTime().get());
        if (this.getInheritsFrom().isPresent()) {
            json.put("inheritsFrom", this.getInheritsFrom().get());
        }
        json.put("type", this.getType().get());
        json.put("logging", Map.of());
        json.put("mainClass", this.getMainClass().getOrElse((Object)""));
        if (!((Boolean)this.getLibrariesLast().get()).booleanValue()) {
            this.addLibraries(json);
        }
        this.addArgs(json);
        if (((Boolean)this.getLibrariesLast().get()).booleanValue()) {
            this.addLibraries(json);
        }
        Path output = ((RegularFile)this.getOutput().get()).getAsFile().toPath();
        String jsonData = GSON.toJson(json);
        Files.writeString(output, (CharSequence)jsonData, new OpenOption[0]);
    }

    private void addLibraries(Map<String, Object> json) {
        ArrayList<LibraryInfo> libraries = new ArrayList<LibraryInfo>((Collection)this.getLibraries().get());
        if (!((Boolean)this.getDuplicateLibraries().get()).booleanValue()) {
            HashSet seen = new HashSet();
            libraries.removeIf(l -> !seen.add(l.name()));
        }
        if (((Boolean)this.getSortLibraries().get()).booleanValue()) {
            libraries.sort(Comparator.comparing(LibraryInfo::name));
        }
        json.put("libraries", libraries);
    }

    private void addArgs(Map<String, Object> json) {
        LinkedHashMap<String, List> args = new LinkedHashMap<String, List>();
        if (this.getGameArgs().isPresent()) {
            args.put("game", (List)this.getGameArgs().get());
        }
        if (this.getJvmArgs().isPresent()) {
            args.put("jvm", (List)this.getJvmArgs().get());
        }
        if (!args.isEmpty()) {
            json.put("arguments", args);
        }
    }
}

