/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.values;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public record LibraryInfo(String name, Downloads downloads) implements Serializable
{
    public LibraryInfo(String name, String path, String url, String sha1, long size) {
        this(name, new Downloads(new Downloads.ArtifactInfo(path, url, sha1, size)));
    }

    public LibraryInfo(MavenInfo info, File file, String url) {
        this(info.name(), info.path(), url, Util.sha1(file), file.length());
    }

    public LibraryInfo validateUrl(boolean offline) {
        Downloads.ArtifactInfo artifact = this.downloads.artifact.validateUrl(offline);
        if (this.downloads.artifact == artifact) {
            return this;
        }
        return new LibraryInfo(this.name, new Downloads(artifact));
    }

    public static Map<String, LibraryInfo> from(Collection<MinimalResolvedArtifact> dependencies) {
        return LibraryInfo.from(dependencies, null);
    }

    public static Map<String, LibraryInfo> from(Collection<MinimalResolvedArtifact> dependencies, boolean validateUrl) {
        return LibraryInfo.from(dependencies, (Boolean)validateUrl);
    }

    public static LibraryInfo from(MinimalResolvedArtifact dependency) {
        MavenInfo info = dependency.info();
        String url = "https://libraries.minecraft.net/" + info.path();
        if (!Util.checkExists(url)) {
            url = "https://maven.minecraftforge.net/" + info.path();
        }
        File file = dependency.file();
        String sha1 = Util.sha1(dependency.file());
        return new LibraryInfo(info.name(), info.path(), url, sha1, file.length());
    }

    private static Map<String, LibraryInfo> from(Collection<MinimalResolvedArtifact> dependencies, Boolean offline) {
        LinkedHashMap<String, LibraryInfo> ret = new LinkedHashMap<String, LibraryInfo>(dependencies.size());
        Semaphore semaphore = new Semaphore(1, true);
        dependencies.parallelStream().forEachOrdered(dependency -> {
            LibraryInfo library = LibraryInfo.from(dependency);
            if (offline != null) {
                library = library.validateUrl(offline);
            }
            try {
                semaphore.acquire();
                ret.put(dependency.info().key(), library);
                semaphore.release();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while trying to get library info for " + String.valueOf(dependency.info()), e);
            }
        });
        return ret;
    }

    public static Provider<LibraryInfo> from(Project project, TaskProvider<? extends AbstractArchiveTask> task) {
        return MinimalResolvedArtifact.from(project, task).map(LibraryInfo::from);
    }

    @SafeVarargs
    public static Provider<Map<String, LibraryInfo>> from(Project project, TaskProvider<? extends AbstractArchiveTask> ... tasks) {
        ListProperty dependencies = project.getObjects().listProperty(MinimalResolvedArtifact.class);
        for (TaskProvider<? extends AbstractArchiveTask> task : tasks) {
            dependencies.add(MinimalResolvedArtifact.from(project, task));
        }
        MapProperty ret = project.getObjects().mapProperty(String.class, LibraryInfo.class).value(dependencies.map(LibraryInfo::from));
        return (Provider)Util.finalize(project, ret);
    }

    public static Provider<Map<String, LibraryInfo>> from(Project project, Configuration configuration) {
        return MinimalResolvedArtifact.from(project, configuration).map(LibraryInfo::from);
    }

    public static List<LibraryInfo> toList(List<MinimalResolvedArtifact> list) {
        return list.stream().map(LibraryInfo::from).toList();
    }

    public static Transformer<LibraryInfo, LibraryInfo> apply(Action<LibraryInfo> action) {
        return info -> {
            action.execute(info);
            return info;
        };
    }

    public record Downloads(ArtifactInfo artifact) implements Serializable
    {

        public static class ArtifactInfo
        implements Serializable {
            public String path;
            public String url;
            public String sha1;
            public long size;

            public ArtifactInfo(String path, String url, String sha1, long size) {
                this.path = path;
                this.url = url;
                this.sha1 = sha1;
                this.size = size;
            }

            public ArtifactInfo validateUrl(boolean offline) {
                if (offline || !this.url.startsWith("https://libraries.minecraft.net/")) {
                    return this;
                }
                if (!Util.checkExists(this.url)) {
                    return new ArtifactInfo(this.path, "https://maven.minecraftforge.net/" + this.url.substring("https://libraries.minecraft.net/".length()), this.sha1, this.size);
                }
                return this;
            }
        }
    }
}

