/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.sas;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevTask;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class CreateFakeSASPatches
extends DefaultTask
implements ForgeDevTask {
    @InputFiles
    public abstract ConfigurableFileCollection getFiles();

    @OutputDirectory
    public abstract DirectoryProperty getOutput();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    public CreateFakeSASPatches() {
        this.getOutput().convention(this.getDefaultOutputDirectory().map(d -> d.dir("patches")));
    }

    @TaskAction
    public void apply() throws IOException {
        File output = ((Directory)this.getOutput().get()).getAsFile();
        if (!output.exists() && !output.mkdirs()) {
            throw new IllegalStateException("Failed to make directory: " + String.valueOf(output));
        }
        WorkQueue queue = this.getWorkerExecutor().noIsolation();
        for (File file : this.getFiles()) {
            for (String line : ResourceGroovyMethods.readLines((File)file)) {
                if (line.isBlank()) continue;
                queue.submit(Action.class, parameters -> {
                    parameters.getOutput().set((Provider)this.getOutput());
                    parameters.getLine().set((Object)line);
                });
            }
        }
        queue.await();
    }

    static abstract class Action
    implements WorkAction<Parameters> {
        @Inject
        public Action() {
        }

        public void execute() {
            String cls;
            File patch;
            File output = (File)((Parameters)this.getParameters()).getOutput().getAsFile().get();
            String line = (String)((Parameters)this.getParameters()).getLine().get();
            int idx = line.indexOf(35);
            if (idx == 0) {
                return;
            }
            if (idx != -1) {
                line = line.substring(0, idx - 1);
            }
            if (line.charAt(0) == '\t') {
                line = line.substring(1);
            }
            if (!(patch = new File(output, (cls = (line.trim() + "    ").split(" ", -1)[0]) + ".java.patch")).getParentFile().exists() && !patch.getParentFile().mkdirs()) {
                throw new IllegalStateException("Failed to make directory: " + String.valueOf(patch.getParentFile()));
            }
            try {
                patch.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create empty file: " + String.valueOf(patch), e);
            }
        }

        static interface Parameters
        extends WorkParameters {
            public DirectoryProperty getOutput();

            public Property<String> getLine();
        }
    }
}

