/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevPlugin;
import net.minecraftforge.forgedev.ForgeDevProblems;
import net.minecraftforge.forgedev.LegacyMCPExtension;
import net.minecraftforge.forgedev.LegacyPatcherExtension;
import net.minecraftforge.forgedev.OSValueSource;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.forgedev.tasks.compat.LegacyExtractZip;
import net.minecraftforge.forgedev.tasks.compat.LegacyMergeFilesTask;
import net.minecraftforge.forgedev.tasks.filtering.LegacyFilterNewJar;
import net.minecraftforge.forgedev.tasks.generation.GeneratePatcherConfigV2;
import net.minecraftforge.forgedev.tasks.installertools.DownloadMappings;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherExec;
import net.minecraftforge.forgedev.tasks.mappings.LegacyApplyMappings;
import net.minecraftforge.forgedev.tasks.mappings.LegacyGenerateSRG;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerMCPDataTask;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerMCPMavenValue;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerMCPSetup;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerRawArtifact;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerSyncMappingsValue;
import net.minecraftforge.forgedev.tasks.obfuscation.LegacyReobfuscateJar;
import net.minecraftforge.forgedev.tasks.patching.binary.CreateBinPatches;
import net.minecraftforge.forgedev.tasks.patching.diff.ApplyPatches;
import net.minecraftforge.forgedev.tasks.patching.diff.BakePatches;
import net.minecraftforge.forgedev.tasks.patching.diff.GeneratePatches;
import net.minecraftforge.forgedev.tasks.sas.CreateFakeSASPatches;
import net.minecraftforge.forgedev.tasks.srg2source.ApplyRangeMap;
import net.minecraftforge.forgedev.tasks.srg2source.ExtractRangeMap;
import net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public abstract class ForgeDevExtension {
    public static final String NAME = "forgedev";
    private static final Attribute<String> OS = Attribute.of((String)"net.minecraftforge.native.operatingSystem", String.class);
    private static final Attribute<String> MAPPINGS_CHANNEL = Attribute.of((String)"net.minecraftforge.mappings.channel", String.class);
    private static final Attribute<String> MAPPINGS_VERSION = Attribute.of((String)"net.minecraftforge.mappings.version", String.class);
    private final ForgeDevProblems problems = (ForgeDevProblems)((Object)this.getObjects().newInstance(ForgeDevProblems.class, new Object[0]));
    private final DirectoryProperty mavenizerRepo = this.getObjects().directoryProperty();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    public ForgeDevExtension(ForgeDevPlugin plugin, Project project) {
        this.mavenizerRepo.set(plugin.globalCaches().dir("repo").map(this.problems.ensureFileLocation()));
        this.setup(plugin, project);
    }

    public Action<? super MavenArtifactRepository> getMavenizer() {
        return repo -> {
            repo.setName("Mavenizer");
            repo.setUrl((Object)this.mavenizerRepo);
        };
    }

    @VisibleForTesting
    public DirectoryProperty getMavenizerRepo() {
        return this.mavenizerRepo;
    }

    private void setup(ForgeDevPlugin plugin, Project project) {
        TaskContainer tasks = project.getTasks();
        LegacyPatcherExtension legacyPatcher = (LegacyPatcherExtension)project.getExtensions().create("patcher", LegacyPatcherExtension.class, new Object[0]);
        LegacyMCPExtension legacyMcp = (LegacyMCPExtension)project.getExtensions().create("mcp", LegacyMCPExtension.class, new Object[0]);
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TaskProvider jar = tasks.named("jar", Jar.class);
        TaskProvider compileJava = tasks.named("compileJava", JavaCompile.class);
        NamedDomainObjectProvider main = java.getSourceSets().named("main");
        TaskProvider setupMCP = tasks.register("setupMCP", MavenizerMCPSetup.class);
        TaskProvider setupMCPSrg = tasks.register("setupMCPSrg", MavenizerMCPSetup.class, task -> task.getRename().set((Object)false));
        TaskProvider downloadClientMappings = tasks.register("downloadClientMappings", DownloadMappings.class, task -> task.getSide().set((Object)"client"));
        TaskProvider downloadServerMappings = tasks.register("downloadServerMappings", DownloadMappings.class, task -> task.getSide().set((Object)"server"));
        Configuration minecraftDepsConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        Configuration mappingsConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        TaskProvider applyPatches = tasks.register("applyPatches", ApplyPatches.class, task -> {
            Provider workDir = project.getLayout().getBuildDirectory().dir(task.getName());
            task.getOutput().set(workDir.map(s -> s.file("output.zip")));
            task.getArchive().set((Object)"zip");
            task.setRejects(workDir.map(s -> s.file("rejects.zip")));
            task.getArchiveRejects().set((Object)"zip");
            task.getPatches().set((Provider)legacyPatcher.getPatches());
            task.getMode().set((Object)"access");
            if (project.hasProperty("UPDATING")) {
                task.getMode().set((Object)"fuzzy");
                task.setRejects(project.getLayout().getProjectDirectory().dir("rejects"));
                task.getArchiveRejects().unset();
                task.getFailOnError().set((Object)false);
            }
        });
        TaskProvider toMCPConfig = tasks.register("srg2mcp", LegacyApplyMappings.class, task -> {
            task.getInput().set(applyPatches.flatMap(ApplyPatches::getOutput));
            task.getMappings().setFrom((Iterable)mappingsConfiguration);
            task.getLambdas().set((Object)false);
        });
        TaskProvider extractMapped = tasks.register("extractMapped", LegacyExtractZip.class, task -> {
            task.getInput().set(toMCPConfig.flatMap(LegacyApplyMappings::getOutput));
            task.getOutput().set((Provider)legacyPatcher.getPatchedSrc());
        });
        TaskProvider extractRangeMap = tasks.register("extractRangeMap", ExtractRangeMap.class, task -> {
            task.getDependencies().from(new Object[]{jar.flatMap(AbstractArchiveTask::getArchiveFile)});
            task.getSources().from(new Object[]{main.map(s -> s.getJava().getSourceDirectories())});
            task.getDependencies().from(new Object[]{compileJava.map(JavaCompile::getClasspath)});
        });
        TaskProvider createMcp2Srg = tasks.register("createMcp2Srg", LegacyGenerateSRG.class, task -> {
            task.getReverse().set((Object)true);
            task.getOutput().set(task.getOutputFile("mcp2srg.tsrg"));
        });
        TaskProvider createSrg2Mcp = tasks.register("createSrg2Mcp", LegacyGenerateSRG.class, task -> {
            task.getReverse().set((Object)false);
            task.getOutput().set(task.getOutputFile("srg2mcp.tsrg"));
        });
        TaskProvider createMcp2Obf = tasks.register("createMcp2Obf", LegacyGenerateSRG.class, task -> {
            task.getNotch().set((Object)true);
            task.getReverse().set((Object)true);
            task.getOutput().set(task.getOutputFile("mcp2obf.tsrg"));
        });
        TaskProvider createExc = tasks.register("createExc");
        TaskProvider applyRangeMap = tasks.register("applyRangeMap", ApplyRangeMap.class, task -> {
            task.getSources().from(new Object[]{main.map(s -> s.getJava().getSourceDirectories().minus((FileCollection)project.files(new Object[]{legacyPatcher.getPatchedSrc()})))});
            task.setOnlyIf(t -> !((ApplyRangeMap)t).getSources().isEmpty());
            task.getRangeMap().set(extractRangeMap.flatMap(ExtractRangeMap::getOutput));
            task.getSrgFiles().from(new Object[]{createMcp2Srg.flatMap(LegacyGenerateSRG::getOutput)});
            task.getExcFiles().from(new Object[]{legacyPatcher.getExcs()});
            task.getKeepImports().set((Object)true);
        });
        TaskProvider applyRangeMapBase = tasks.register("applyRangeMapBase", ApplyRangeMap.class, task -> {
            task.setOnlyIf(t -> legacyPatcher.getPatches().isPresent());
            task.getSources().from(new Object[]{legacyPatcher.getPatchedSrc()});
            task.getRangeMap().set(extractRangeMap.flatMap(ExtractRangeMap::getOutput));
            task.getSrgFiles().from(new Object[]{createMcp2Srg.flatMap(LegacyGenerateSRG::getOutput)});
            task.getExcFiles().from(new Object[]{legacyPatcher.getExcs()});
            task.getKeepImports().set((Object)true);
        });
        TaskProvider userdevConfig = tasks.register("userdevConfig", GeneratePatcherConfigV2.class);
        TaskProvider genPatches = tasks.register("genPatches", GeneratePatches.class, task -> {
            task.setOnlyIf(t -> legacyPatcher.getPatches().isPresent());
            task.getOutput().set((Provider)legacyPatcher.getPatches());
        });
        TaskProvider bakePatches = tasks.register("bakePatches", BakePatches.class, task -> {
            task.dependsOn(new Object[]{genPatches});
            task.getInput().set((Provider)legacyPatcher.getPatches());
            task.getOutput().set(new File(task.getTemporaryDir(), "output.zip"));
        });
        TaskProvider reobfJar = tasks.register("reobfJar", LegacyReobfuscateJar.class, task -> {
            task.getInput().set(jar.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getLibraries().from(new Object[]{minecraftDepsConfiguration});
            task.getOutput().convention(task.getDefaultOutputFile());
        });
        TaskProvider genJoinedBinPatches = tasks.register("genJoinedBinPatches", CreateBinPatches.class, task -> {
            task.getCreate().from(new Object[]{reobfJar.flatMap(LegacyReobfuscateJar::getOutput)});
            task.getOutput().convention(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("joined.lzma")));
        });
        TaskProvider genClientBinPatches = tasks.register("genClientBinPatches", CreateBinPatches.class, task -> {
            task.getCreate().from(new Object[]{reobfJar.flatMap(LegacyReobfuscateJar::getOutput)});
            task.getOutput().convention(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("client.lzma")));
        });
        TaskProvider genServerBinPatches = tasks.register("genServerBinPatches", CreateBinPatches.class, task -> {
            task.getCreate().from(new Object[]{reobfJar.flatMap(LegacyReobfuscateJar::getOutput)});
            task.getOutput().convention(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("server.lzma")));
        });
        List<TaskProvider> genBinPatchesTasks = List.of(genJoinedBinPatches, genClientBinPatches, genServerBinPatches);
        TaskProvider genBinPatches = tasks.register("genBinPatches", task -> task.dependsOn(new Object[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches}));
        TaskProvider filterNew = tasks.register("filterJarNew", LegacyFilterNewJar.class, task -> task.getInput().set(reobfJar.flatMap(LegacyReobfuscateJar::getOutput)));
        TaskProvider srgSourcesJar = tasks.register("legacySourcesJar", Jar.class, task -> {
            task.setGroup("build");
            task.setOnlyIf(t -> (Boolean)applyRangeMap.flatMap(ApplyRangeMap::getOutput).map(rf -> rf.getAsFile().exists()).getOrElse((Object)false));
            task.dependsOn(new Object[]{applyRangeMap});
            task.from(new Object[]{project.zipTree((Object)applyRangeMap.flatMap(ApplyRangeMap::getOutput))});
            task.getArchiveClassifier().set((Object)"sources");
        });
        TaskProvider universalJar = tasks.register("universalJar", Jar.class, task -> {
            task.setGroup("build");
            task.dependsOn(new Object[]{filterNew});
            task.from(new Object[]{project.zipTree((Object)filterNew.flatMap(LegacyFilterNewJar::getOutput))});
            task.from(new Object[]{java.getSourceSets().named("main").map(SourceSet::getResources)});
            task.getArchiveClassifier().set((Object)"universal");
        });
        TaskProvider userdevJar = tasks.register("userdevJar", Jar.class, task -> {
            task.setGroup("build");
            task.dependsOn(new Object[]{srgSourcesJar, bakePatches});
            task.setOnlyIf(t -> legacyPatcher.isSrgPatches());
            task.from((Object)userdevConfig.flatMap(GeneratePatcherConfigV2::getOutput), e -> e.rename(f -> "config.json"));
            task.from((Object)genJoinedBinPatches.flatMap(rec$ -> ((CreateBinPatches)rec$).getOutput()), e -> e.rename(f -> "joined.lzma"));
            task.from((Object)project.zipTree((Object)bakePatches.flatMap(BakePatches::getOutput)), e -> e.into((Object)"patches/"));
            task.getArchiveClassifier().set((Object)"userdev");
        });
        TaskProvider assemble = tasks.named("assemble", task -> task.dependsOn(new Object[]{universalJar, userdevJar}));
        DirectoryProperty sourceSetsDir = this.getObjects().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir("sourceSets"));
        boolean mergeSourceSets = this.problems.test("net.minecraftforge.gradle.merge-source-sets");
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().configureEach(sourceSet -> {
            if (mergeSourceSets) {
                Provider unifiedDir = sourceSetsDir.dir(sourceSet.getName());
                sourceSet.getOutput().setResourcesDir((Object)unifiedDir);
                sourceSet.getJava().getDestinationDirectory().set(unifiedDir);
            }
            project.getPluginManager().withPlugin("eclipse", eclipsePlugin -> {
                EclipseModel eclipse = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
                if (mergeSourceSets) {
                    eclipse.getClasspath().setDefaultOutputDir((File)sourceSetsDir.getAsFile().get());
                } else {
                    System.out.println("WARNING: Source set will not be merged for " + sourceSet.getName() + "!");
                }
            });
        });
        project.afterEvaluate(p -> {
            downloadClientMappings.configure(task -> task.getVersion().set(legacyPatcher.getMappingVersion()));
            downloadServerMappings.configure(task -> task.getVersion().set(legacyPatcher.getMappingVersion()));
            Provider mappingsDependency = this.getProviders().zip(this.getProviders().of(MavenizerSyncMappingsValue.class, spec -> spec.parameters(parameters -> {
                parameters.init(plugin, this.problems);
                parameters.getOutput().set((Provider)this.mavenizerRepo);
                parameters.getVersion().set(legacyPatcher.getMappingVersion());
            })), this.getProviders().zip(legacyPatcher.getMappingChannel(), legacyPatcher.getMappingVersion(), (c, v) -> c + ":" + v), (ret, version) -> project.getDependencies().create((Object)"net.minecraft:mappings_%s@zip".formatted(version)));
            Provider minecraftDependency = this.getProviders().zip(this.getProviders().of(MavenizerMCPMavenValue.class, spec -> spec.parameters(parameters -> {
                parameters.init(plugin, this.problems);
                parameters.getOutput().set((Provider)this.mavenizerRepo);
                parameters.getArtifact().set(legacyMcp.getVersion());
            })), legacyMcp.getVersion(), (ret, version) -> project.getDependencies().create((Object)("net.minecraft:joined:" + version), Closures.consumer(dependency -> dependency.attributes(a -> {
                a.attributeProvider(OS, this.getProviders().of(OSValueSource.class, spec -> {}));
                a.attributeProvider(MAPPINGS_CHANNEL, legacyPatcher.getMappingChannel());
                a.attributeProvider(MAPPINGS_VERSION, legacyPatcher.getMappingVersion());
            }))));
            Provider minecraftExtraDependency = this.getProviders().zip(this.getProviders().of(MavenizerMCPMavenValue.class, spec -> spec.parameters(parameters -> {
                parameters.init(plugin, this.problems);
                parameters.getOutput().set((Provider)this.mavenizerRepo);
                parameters.getArtifact().set(legacyMcp.getVersion().map(v -> "net.minecraft:client-extra:" + v));
            })), legacyMcp.getVersion(), (ret, version) -> project.getDependencies().create((Object)("net.minecraft:client-extra:" + version), Closures.consumer(dependency -> dependency.setTransitive(false))));
            project.getDependencies().addProvider("implementation", minecraftDependency);
            project.getDependencies().addProvider("implementation", minecraftExtraDependency);
            project.getDependencies().addProvider("implementation", mappingsDependency);
            minecraftDepsConfiguration.withDependencies(d -> d.addLater(minecraftDependency));
            mappingsConfiguration.withDependencies(d -> d.addLater(mappingsDependency));
            main.configure(s -> s.getJava().srcDir((Object)legacyPatcher.getPatchedSrc()));
            if (legacyPatcher.getPatches().isPresent()) {
                try {
                    Files.createDirectories(((Directory)legacyPatcher.getPatches().get()).getAsFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create patches folder", e);
                }
                srgSourcesJar.configure(task -> task.from((Object)genPatches.flatMap(GeneratePatches::getOutput), copy -> copy.into((Object)"patches/")));
            }
            setupMCP.configure(task -> {
                task.getPipeline().set(legacyMcp.getPipeline());
                task.getArtifact().set(legacyMcp.getConfig());
            });
            setupMCPSrg.configure(task -> {
                task.getPipeline().set(legacyMcp.getPipeline());
                task.getArtifact().set(legacyMcp.getConfig());
            });
            legacyPatcher.getCleanSrc().set(setupMCP.flatMap(rec$ -> ((MavenizerMCPSetup)rec$).getOutput()));
            applyPatches.configure(task -> task.getInput().convention((Provider)legacyPatcher.getCleanSrc()));
            genPatches.configure(task -> task.getInput().convention((Provider)legacyPatcher.getCleanSrc()));
            TaskProvider extractSrg = tasks.register("extractSrg", MavenizerMCPDataTask.class, task -> {
                task.getArtifact().set(legacyMcp.getConfig());
                task.getOutput().convention(task.getOutputFile("obf2srg.tsrg"));
            });
            createMcp2Srg.configure(task -> task.getMcpSrgData().convention(extractSrg.flatMap(MavenizerMCPDataTask::getOutput)));
            tasks.withType(LegacyGenerateSRG.class, task -> task.getMappings().setFrom((Iterable)mappingsConfiguration));
            createMcp2Obf.configure(task -> task.getMcpSrgData().convention(createMcp2Srg.flatMap(LegacyGenerateSRG::getMcpSrgData)));
            createSrg2Mcp.configure(task -> task.getMcpSrgData().convention(createMcp2Srg.flatMap(LegacyGenerateSRG::getMcpSrgData)));
            if (!legacyPatcher.getAccessTransformers().isEmpty()) {
                TaskProvider mergeATs = tasks.register("mergeATs", LegacyMergeFilesTask.class, task -> {
                    task.getFilesToMerge().setFrom((Iterable)legacyPatcher.getAccessTransformers());
                    task.getOutput().set(project.getLayout().getBuildDirectory().file("legacy-forgedev/merged_ats.cfg"));
                });
                setupMCP.configure(task -> {
                    task.dependsOn(new Object[]{mergeATs});
                    task.getAccessTransformerConfig().set(mergeATs.flatMap(LegacyMergeFilesTask::getOutput));
                });
                setupMCPSrg.configure(task -> {
                    task.dependsOn(new Object[]{mergeATs});
                    task.getAccessTransformerConfig().set(mergeATs.flatMap(LegacyMergeFilesTask::getOutput));
                });
                for (File f : legacyPatcher.getAccessTransformers()) {
                    userdevJar.configure(t -> t.from((Object)f, e -> e.into((Object)"ats/")));
                    userdevConfig.configure(t -> t.getATs().from(new Object[]{f}));
                }
            }
            if (!legacyPatcher.getSideAnnotationStrippers().isEmpty()) {
                setupMCP.configure(task -> task.getSideAnnotationStripperConfig().fileProvider(this.getProviders().provider(() -> legacyPatcher.getSideAnnotationStrippers().getSingleFile())));
                setupMCPSrg.configure(task -> task.getSideAnnotationStripperConfig().fileProvider(this.getProviders().provider(() -> legacyPatcher.getSideAnnotationStrippers().getSingleFile())));
                userdevConfig.configure(task -> task.getSASs().from(new Object[]{legacyPatcher.getSideAnnotationStrippers()}));
                for (Object sas : legacyPatcher.getSideAnnotationStrippers()) {
                    userdevJar.configure(arg_0 -> ForgeDevExtension.lambda$setup$90((File)sas, arg_0));
                }
                TaskProvider fakePatches = tasks.register("createFakeSASPatches", CreateFakeSASPatches.class, task -> task.getFiles().from(new Object[]{legacyPatcher.getSideAnnotationStrippers()}));
                for (TaskProvider genBinPatchesTask : genBinPatchesTasks) {
                    genBinPatchesTask.configure(task -> task.getPatches().from(new Object[]{fakePatches.flatMap(CreateFakeSASPatches::getOutput)}));
                }
            }
            if (!legacyPatcher.getExtraMappings().isEmpty()) {
                for (Object extraMapping : legacyPatcher.getExtraMappings()) {
                    if (extraMapping instanceof File) {
                        File e = (File)extraMapping;
                        userdevJar.configure(t -> t.from((Object)e, c -> c.into((Object)"srgs/")));
                        userdevConfig.configure(t -> t.getSRGs().from(new Object[]{e}));
                        continue;
                    }
                    if (!(extraMapping instanceof String)) continue;
                    String e = (String)extraMapping;
                    userdevConfig.configure(t -> t.getSRGLines().add((Object)e));
                }
            }
            userdevConfig.configure(task -> {
                task.getMCPConfig().set(legacyMcp.getConfig());
                task.getBinpatcherVersion().convention((Object)Tools.BINPATCH.getModule().toString());
                task.getBinpatcherArguments().addAll((Object[])new String[]{"--clean", "{clean}", "--output", "{output}", "--apply", "{patch}"});
                task.getUniversal().convention(universalJar.flatMap(t -> t.getArchiveBaseName().flatMap(baseName -> t.getArchiveClassifier().flatMap(classifier -> t.getArchiveExtension().map(jarExt -> project.getGroup().toString() + ":" + baseName + ":" + String.valueOf(project.getVersion()) + ":" + classifier + "@" + jarExt)))));
                task.getSource().convention(srgSourcesJar.flatMap(t -> t.getArchiveBaseName().flatMap(baseName -> t.getArchiveClassifier().flatMap(classifier -> t.getArchiveExtension().map(jarExt -> project.getGroup().toString() + ":" + baseName + ":" + String.valueOf(project.getVersion()) + ":" + classifier + "@" + jarExt)))));
                task.getPatchesOriginalPrefix().set(genPatches.flatMap(rec$ -> ((GeneratePatches)rec$).getBasePathPrefix()));
                task.getPatchesModifiedPrefix().set(genPatches.flatMap(rec$ -> ((GeneratePatches)rec$).getModifiedPathPrefix()));
                task.getNotchObf().set((Object)legacyPatcher.getNotchObf());
            });
            if (legacyPatcher.isSrgPatches()) {
                genPatches.configure(task -> task.getModified().set(applyRangeMapBase.flatMap(ApplyRangeMap::getOutput)));
            } else {
                TaskProvider toMCPClean = tasks.register("srg2mcpClean", LegacyApplyMappings.class, task -> {
                    task.getInput().set((Provider)legacyPatcher.getCleanSrc());
                    task.getMappings().setFrom((Iterable)mappingsConfiguration);
                    task.getLambdas().set((Object)false);
                });
                TaskProvider dirtyZip = tasks.register("patchedZip", Zip.class, task -> {
                    task.from(new Object[]{legacyPatcher.getPatchedSrc()});
                    task.getArchiveFileName().set((Object)"output.zip");
                    task.getDestinationDirectory().set(project.getLayout().getBuildDirectory().dir(task.getName()));
                });
                applyPatches.configure(task -> {
                    task.dependsOn(new Object[]{toMCPClean});
                    task.getInput().set(toMCPClean.flatMap(LegacyApplyMappings::getOutput));
                });
                genPatches.configure(task -> {
                    task.getInput().set(toMCPClean.flatMap(LegacyApplyMappings::getOutput));
                    task.getModified().set(dirtyZip.flatMap(AbstractArchiveTask::getArchiveFile));
                });
                Property<String> mcpConfigArtifact = legacyMcp.getConfig();
                Provider srgNames = this.getProviders().provider(() -> !legacyPatcher.getNotchObf());
                Function<String, TaskProvider> rawJarTask = pipeline -> {
                    MavenizerRawArtifact.register(project, pipeline, (Provider<String>)mcpConfigArtifact, (Provider<Boolean>)srgNames.map(b -> b == false));
                    return MavenizerRawArtifact.register(project, pipeline, (Provider<String>)mcpConfigArtifact, (Provider<Boolean>)srgNames);
                };
                TaskProvider rawJoinedJar = rawJarTask.apply("joined");
                TaskProvider rawClientJar = rawJarTask.apply("client");
                TaskProvider rawServerJar = rawJarTask.apply("server");
                TaskProvider srg = legacyPatcher.getNotchObf() ? createMcp2Obf : createMcp2Srg;
                reobfJar.configure(task -> task.getSrg().set(srg.flatMap(LegacyGenerateSRG::getOutput)));
                genJoinedBinPatches.configure(task -> task.getClean().builtBy(new Object[]{rawJoinedJar}));
                genClientBinPatches.configure(task -> task.getClean().builtBy(new Object[]{rawClientJar}));
                genServerBinPatches.configure(task -> task.getClean().builtBy(new Object[]{rawServerJar}));
                tasks.withType(CreateBinPatches.class, task -> {
                    task.getSrg().from(new Object[]{srg.flatMap(LegacyGenerateSRG::getOutput)});
                    if (legacyPatcher.getPatches().isPresent()) {
                        task.mustRunAfter(new Object[]{genPatches});
                        task.getPatches().from(new Object[]{legacyPatcher.getPatches()});
                    }
                });
                filterNew.configure(task -> {
                    task.getSrg().set(srg.flatMap(LegacyGenerateSRG::getOutput));
                    task.getBlacklist().builtBy(new Object[]{rawJoinedJar});
                });
            }
            if (!legacyPatcher.runs.isEmpty()) {
                File eclipseOutputDir;
                TaskProvider genEclipseRuns = project.getTasks().register("genEclipseRuns", task -> {
                    task.setGroup("IDE");
                    task.setDescription("Generates the run configuration launch files for Eclipse.");
                });
                EclipseModel eclipse = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
                if (eclipse != null) {
                    eclipse.synchronizationTasks(new Object[]{genEclipseRuns});
                    eclipseOutputDir = eclipse.getClasspath().getDefaultOutputDir();
                } else {
                    eclipseOutputDir = this.getProjectLayout().getProjectDirectory().dir("bin").getAsFile();
                }
                for (SourceSet sourceSet : List.of((SourceSet)main.get(), (SourceSet)java.getSourceSets().named("test").get())) {
                    legacyPatcher.runs.forEach(options -> {
                        record SimpleModuleIdentifier(String getGroup, String getName) implements ModuleIdentifier
                        {
                            SimpleModuleIdentifier() {
                                this("net.minecraft", "joined");
                            }
                        }
                        TaskProvider<SlimeLauncherExec> task = SlimeLauncherExec.register(project, sourceSet, options, new SimpleModuleIdentifier(), (String)legacyMcp.getVersion().get(), eclipseOutputDir);
                    });
                }
            }
        });
    }

    private static /* synthetic */ void lambda$setup$90(File sas, Jar task) {
        task.from((Object)sas, copy -> copy.into((Object)"sas/"));
    }
}

