/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevProblems;
import net.minecraftforge.forgedev.ForgeDevTask;
import net.minecraftforge.forgedev.Tools;
import net.minecraftforge.forgedev.Util;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherEclipseConfiguration;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptions;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptionsImpl;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptionsInternal;
import net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public abstract class SlimeLauncherExec
extends JavaExec
implements ForgeDevTask,
HasPublicType {
    private final ForgeDevProblems problems = (ForgeDevProblems)((Object)this.getObjectFactory().newInstance(ForgeDevProblems.class, new Object[0]));

    public static TaskProvider<SlimeLauncherExec> register(Project project, SourceSet sourceSet, SlimeLauncherOptionsImpl options, ModuleIdentifier module, String version, File eclipseOutputDir) {
        ExternalModuleDependency metadataDep = project.getDependencyFactory().create(module.getGroup(), module.getName(), version, "metadata", "zip");
        Usage metadataAttr = (Usage)project.getObjects().named(Usage.class, "metadata");
        Configuration metadataConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[]{metadataDep});
        metadataConfiguration.setTransitive(false);
        metadataConfiguration.attributes(a -> a.attribute(Usage.USAGE_ATTRIBUTE, (Object)metadataAttr));
        String runTaskName = sourceSet.getTaskName("run", options.getName());
        String generateEclipseRunTaskName = sourceSet.getTaskName("genEclipseRun", options.getName());
        ConfigurableFileCollection sourceSetOutputs = project.getObjects().fileCollection().from(new Object[]{sourceSet.getOutput().getResourcesDir(), sourceSet.getJava().getDestinationDirectory()});
        ConfigurableFileCollection eclipseOutputs = project.getObjects().fileCollection().from(new Object[]{eclipseOutputDir});
        TaskProvider genEclipseRun = project.getTasks().register(generateEclipseRunTaskName, SlimeLauncherEclipseConfiguration.class, task -> {
            task.getRunName().set((Object)options.getName());
            task.setDescription("Generates the '%s' Slime Launcher run configuration for Eclipse.".formatted(options.getName()));
            task.getOutputFile().set((Object)task.getProjectLayout().getProjectDirectory().file(runTaskName + ".launch"));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = task.getProviders().provider(() -> ((SourceSet)sourceSet).getRuntimeClasspath());
            objectArray[0] = task.getObjects().fileCollection().from(objectArray2);
            task.getClasspath().from(objectArray).minus((FileCollection)sourceSetOutputs).plus((FileCollection)eclipseOutputs);
            task.getSourceSetName().set((Object)sourceSet.getName());
            DirectoryProperty caches = task.getObjects().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s".formatted(version)));
            task.getCacheDir().set(caches.map(task.problems.ensureFileLocation()));
            task.getMetadata().setFrom((Iterable)metadataConfiguration);
            task.getOptions().set((Object)options);
        });
        project.getTasks().named("genEclipseRuns", task -> task.dependsOn(new Object[]{genEclipseRun}));
        return project.getTasks().register(runTaskName, SlimeLauncherExec.class, task -> {
            task.getRunName().set((Object)options.getName());
            task.getSourceSetName().set((Object)sourceSet.getName());
            task.setDescription("Runs the '%s' Slime Launcher run configuration.".formatted(options.getName()));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = task.getProviderFactory().provider(() -> ((SourceSet)sourceSet).getRuntimeClasspath());
            objectArray[0] = task.getObjectFactory().fileCollection().from(objectArray2);
            task.classpath(objectArray);
            DirectoryProperty caches = task.getObjectFactory().directoryProperty().value(task.globalCaches().dir("slime-launcher/cache/%s".formatted(version)));
            task.getCacheDir().set(caches.map(task.problems.ensureFileLocation()));
            task.getMetadata().setFrom((Iterable)metadataConfiguration);
            task.getOptions().set((Object)options);
        });
    }

    @Input
    protected abstract Property<String> getRunName();

    @Input
    protected abstract Property<String> getSourceSetName();

    @Nested
    protected abstract Property<SlimeLauncherOptions> getOptions();

    @Internal
    protected abstract DirectoryProperty getCacheDir();

    @InputFiles
    protected abstract ConfigurableFileCollection getMetadata();

    @Input
    @Optional
    protected abstract Property<Boolean> getClient();

    @Inject
    public SlimeLauncherExec() {
        this.setGroup("Slime Launcher");
        Tool.Resolved tool = this.getTool(Tools.SLIMELAUNCHER);
        this.setClasspath(tool.getClasspath());
        if (tool.hasMainClass()) {
            this.getMainClass().set((Object)tool.getMainClass());
        }
        this.getJavaLauncher().set(Util.launcherFor((Project)this.getProject(), (int)tool.getJavaVersion()));
        this.getModularity().getInferModulePath().set((Object)false);
    }

    @Internal
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaExec.class);
    }

    public void exec() {
        SlimeLauncherOptionsInternal options = ((SlimeLauncherOptionsInternal)this.getOptions().get()).inherit(Map.of(), (String)this.getSourceSetName().get());
        Provider mainClass = options.getMainClass().filter(Util.IS_NOT_BLANK);
        ArrayList args = new ArrayList((Collection)options.getArgs().getOrElse(List.of()));
        this.jvmArgs((Iterable)options.getJvmArgs().get());
        if (!options.getClasspath().isEmpty()) {
            this.setClasspath((FileCollection)options.getClasspath());
        }
        if (options.getMinHeapSize().filter(Util.IS_NOT_BLANK).isPresent()) {
            this.setMinHeapSize((String)options.getMinHeapSize().get());
        }
        if (options.getMaxHeapSize().filter(Util.IS_NOT_BLANK).isPresent()) {
            this.setMinHeapSize((String)options.getMaxHeapSize().get());
        }
        this.systemProperties((Map)options.getSystemProperties().get());
        this.environment((Map)options.getEnvironment().get());
        this.workingDir(options.getWorkingDir().get());
        if (!((String)this.getMainClass().get()).startsWith("net.minecraftforge.launcher")) {
            this.getLogger().warn("WARNING: Main class is not Slime Launcher! Skipping additional configuration.");
        } else {
            this.args(new Object[]{"--main", mainClass.get(), "--cache", ((Directory)this.getCacheDir().get()).getAsFile().getAbsolutePath(), "--metadata", this.getMetadata().getSingleFile().getAbsolutePath(), "--"});
        }
        this.args(args);
        if (!((Boolean)this.getClient().getOrElse((Object)false)).booleanValue()) {
            this.setStandardInput(System.in);
        }
        try {
            Files.createDirectories(this.getWorkingDir().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        try {
            super.exec();
        }
        catch (Exception e) {
            this.getLogger().error("Something went wrong! Here is some debug info.");
            this.getLogger().error("Args: {}", (Object)this.getArgs());
            this.getLogger().error("Options: {}", (Object)options);
            throw e;
        }
    }
}

