/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.values;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.values.LibraryInfo;
import net.minecraftforge.forgedev.legacy.values.MavenInfo;
import net.minecraftforge.forgedev.legacy.values.MinimalResolvedArtifact;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;

public abstract class LibraryInfoSource
implements ValueSource<Map<String, LibraryInfo>, Parameters> {
    public Map<String, LibraryInfo> obtain() {
        List dependencies = (List)((Parameters)this.getParameters()).getDependencies().get();
        HashMap<String, LibraryInfo> ret = new HashMap<String, LibraryInfo>(dependencies.size());
        Semaphore semaphore = new Semaphore(1, true);
        dependencies.parallelStream().forEachOrdered(dependency -> {
            MavenInfo info = dependency.info();
            String url = "https://libraries.minecraft.net/" + info.path();
            if (!Util.checkExists(url)) {
                url = "https://maven.minecraftforge.net/" + info.path();
            }
            File file = dependency.file();
            String sha1 = Util.sha1(dependency.file());
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while trying to get library info for " + String.valueOf(dependency.info()), e);
            }
            ret.put(info.key(), new LibraryInfo(info.name(), info.path(), url, sha1, file.length()));
            semaphore.release();
        });
        return ret;
    }

    static interface Parameters
    extends ValueSourceParameters {
        public ListProperty<MinimalResolvedArtifact> getDependencies();
    }
}

