/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.tasks;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;

public class CleanProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String LINE_SEP = System.lineSeparator();
    private static final String UNIX_LINE_SEP = "\n";
    private static final Charset ENCODING = StandardCharsets.UTF_8;

    public CleanProperties load(File input) throws IOException {
        if (input.exists()) {
            try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(input), ENCODING);){
                super.load(is);
            }
        }
        return this;
    }

    public void store(File out) throws IOException {
        if (!out.getParentFile().exists() && !out.getParentFile().mkdirs()) {
            throw new IllegalStateException("Cannot create parent directory for " + String.valueOf(out));
        }
        try (FileOutputStream os = new FileOutputStream(out);){
            this.store(os, null);
        }
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        TreeSet<Object> ret = new TreeSet<Object>(Comparator.comparing(Object::toString));
        super.keys().asIterator().forEachRemaining(ret::add);
        return Collections.enumeration(ret);
    }

    @Override
    public SortedSet<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry> ret = new TreeSet<Map.Entry>(Comparator.comparing(e -> e.getKey().toString()));
        ret.addAll(super.entrySet());
        return Collections.synchronizedSortedSet(ret);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        out.write(this.clean().getBytes(ENCODING));
        out.flush();
    }

    @Override
    public void store(Writer out, String comments) throws IOException {
        out.write(this.clean());
        out.flush();
    }

    private String clean() throws IOException {
        ByteArrayOutputStream tmp;
        try (ByteArrayOutputStream byteArrayOutputStream = tmp = new ByteArrayOutputStream();){
            super.store(tmp, null);
        }
        String ret = tmp.toString(ENCODING).replace(LINE_SEP, UNIX_LINE_SEP);
        ret = ret.substring(ret.indexOf(UNIX_LINE_SEP) + 1);
        return ret;
    }
}

