/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import net.minecraftforge.jarjar.metadata.json.ArtifactVersionSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedJarIdentifierSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedJarMetadataSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedVersionSerializer;
import net.minecraftforge.jarjar.metadata.json.MetadataSerializer;
import net.minecraftforge.jarjar.metadata.json.VersionRangeSerializer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@Deprecated(forRemoval=true)
public abstract class JarJarMetadataOptions
extends DefaultTask {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(VersionRange.class, (Object)new VersionRangeSerializer()).registerTypeAdapter(ArtifactVersion.class, (Object)new ArtifactVersionSerializer()).registerTypeAdapter(DefaultArtifactVersion.class, (Object)new ArtifactVersionSerializer()).registerTypeAdapter(ContainedJarIdentifier.class, (Object)new ContainedJarIdentifierSerializer()).registerTypeAdapter(ContainedJarMetadata.class, (Object)new ContainedJarMetadataSerializer()).registerTypeAdapter(ContainedVersion.class, (Object)new ContainedVersionSerializer()).registerTypeAdapter(Metadata.class, (Object)new MetadataSerializer()).setPrettyPrinting().create();

    @Input
    protected abstract SetProperty<ResolvedDependencyInfoImpl> getResolvedDependencies();

    @OutputFile
    protected abstract RegularFileProperty getMetadataFile();

    @Inject
    protected abstract ProjectLayout getLayout();

    public void add(Provider<MinimalExternalModuleDependency> dependency, Action<? super ResolvedDependencyInfo> action) {
        this.getResolvedDependencies().add(dependency.map(d -> {
            ResolvedDependencyInfoImpl ret = ResolvedDependencyInfoImpl.from(this.getProject().getConfigurations(), (Dependency)d);
            action.execute((Object)ret);
            return ret;
        }));
    }

    @Inject
    public JarJarMetadataOptions() {
        this.getMetadataFile().convention(this.getLayout().getBuildDirectory().file(this.getName() + "/options.json"));
    }

    @TaskAction
    protected void exec() {
        Set resolved = (Set)this.getResolvedDependencies().get();
        record ForgeLocaterOptions(String resource, String layer, String id, List<ContainedJarMetadata> deps, ContainedJarMetadata meta, boolean nested) {
        }
        ArrayList<ForgeLocaterOptions> jars = new ArrayList<ForgeLocaterOptions>(resolved.size());
        for (ResolvedDependencyInfoImpl dependency : resolved) {
            ArrayList<ContainedJarMetadata> deps;
            block18: {
                deps = new ArrayList<ContainedJarMetadata>();
                try (ZipFile zip = new ZipFile(dependency.artifact);){
                    ZipEntry entry = zip.getEntry("META-INF/jarjar/metadata.json");
                    if (entry == null) break block18;
                    try (InputStream stream = zip.getInputStream(entry);){
                        Metadata meta = MetadataIOHandler.fromStream((InputStream)stream).orElse(null);
                        if (meta == null) {
                            throw new IllegalStateException("Corrupt metadata.json in " + dependency.artifact.getAbsolutePath());
                        }
                        for (ContainedJarMetadata dep : meta.jars()) {
                            deps.add(new ContainedJarMetadata(dep.identifier(), dep.version(), "", dep.isObfuscated()));
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jars.add(new ForgeLocaterOptions(dependency.resource, dependency.layer, dependency.identifier, deps, new ContainedJarMetadata(new ContainedJarIdentifier(this.validateGroup(dependency), dependency.module.getName()), new ContainedVersion(null, this.parseVersion(dependency)), Objects.requireNonNull(dependency.path, "Dependency path is unspecified: " + dependency.asString), false), dependency.nested));
        }
        try {
            record Meta(List<ForgeLocaterOptions> options) {
                private final List<ForgeLocaterOptions> options;

                Meta {
                }

                public List<ForgeLocaterOptions> options() {
                    return this.options;
                }
            }
            Files.writeString(((File)this.getMetadataFile().getAsFile().get()).toPath(), (CharSequence)GSON.toJson((Object)new Meta(jars), Meta.class), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String validateGroup(ResolvedDependencyInfoImpl dependency) {
        try {
            return Objects.requireNonNull(dependency.module.getGroup());
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Module dependency has no group: " + dependency.asString, e);
        }
    }

    private ArtifactVersion parseVersion(ResolvedDependencyInfoImpl resolved) {
        try {
            return VersionRange.createFromVersionSpec((String)Objects.requireNonNull(resolved.version)).getRecommendedVersion();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Version is invalid for: " + resolved.asString, e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Version is unspecified for: " + resolved.asString, e);
        }
    }

    private VersionRange parseVersionRange(ResolvedDependencyInfoImpl dependency) {
        if (dependency.hasManuallySpecifiedRange) {
            try {
                return VersionRange.createFromVersionSpec((String)dependency.versionRange);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("Version is invalid for: " + dependency.asString, e);
            }
        }
        try {
            return VersionRange.createFromVersionSpec((String)"[%s,)".formatted(Objects.requireNonNull(dependency.versionRange)));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Version range is invalid for: " + dependency.asString, e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Version is unspecified for: " + dependency.asString, e);
        }
    }

    static final class ResolvedDependencyInfoImpl
    implements ResolvedDependencyInfo,
    ResolvedDependencyInfo.ContainedJarMetadataInfo,
    Serializable {
        private static final long serialVersionUID = -7577318115877822993L;
        final MinimalModuleVersionIdentifier module;
        final String version;
        String versionRange;
        boolean hasManuallySpecifiedRange;
        boolean nested;
        final File artifact;
        String path;
        String resource;
        String layer;
        String identifier;
        final String asString;

        public ResolvedDependencyInfoImpl(MinimalModuleVersionIdentifier module, String version, File artifact, String asString) {
            this.module = module;
            this.version = version;
            this.artifact = artifact;
            this.asString = asString;
        }

        @Override
        public void containedJarMetadata(Action<? super ResolvedDependencyInfo.ContainedJarMetadataInfo> action) {
            action.execute((Object)this);
        }

        @Override
        public void setGroup(String group) {
            this.module.group = group;
        }

        @Override
        public void setName(String name) {
            this.module.name = name;
        }

        @Override
        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public void setLayer(String layer) {
            this.layer = layer;
        }

        @Override
        public void setId(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public void setNested(boolean nested) {
            this.nested = nested;
        }

        static Set<File> getFiles(Set<ResolvedDependencyInfoImpl> resolvedDependencies) {
            HashSet<File> ret = new HashSet<File>(resolvedDependencies.size());
            for (ResolvedDependencyInfoImpl dependency : resolvedDependencies) {
                ret.add(dependency.artifact);
            }
            return ret;
        }

        static ResolvedDependencyInfoImpl from(ConfigurationContainer configurations, Dependency dependency) {
            String group = dependency.getGroup();
            String name = dependency.getName();
            String version = dependency.getVersion();
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency filesDependency = (FileCollectionDependency)dependency;
                File artifact = filesDependency.getFiles().getSingleFile();
                return new ResolvedDependencyInfoImpl(new MinimalModuleVersionIdentifier(group, name, version), version, artifact, filesDependency.toString());
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                if ((moduleDependency = moduleDependency.copy()) instanceof ExternalModuleDependency) {
                    ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)moduleDependency;
                    externalModuleDependency.version(v -> v.strictly(version.toString()));
                }
                Configuration detachedConfiguration = configurations.detachedConfiguration(new Dependency[]{moduleDependency});
                detachedConfiguration.setTransitive(false);
                ResolvedDependencyInfoImpl ret = null;
                for (ResolvedArtifact artifact : ((ResolvedDependency)detachedConfiguration.getResolvedConfiguration().getFirstLevelModuleDependencies().iterator().next()).getModuleArtifacts()) {
                    String fileName = ResolvedDependencyInfoImpl.getFileName(artifact);
                    if (!fileName.endsWith(".jar")) continue;
                    if (ret != null) {
                        throw new IllegalArgumentException("Module dependency has too many Jar artifacts: " + String.valueOf(moduleDependency));
                    }
                    ret = new ResolvedDependencyInfoImpl(new MinimalModuleVersionIdentifier(group, name, artifact.getModuleVersion().getId().getVersion()), version, artifact.getFile(), moduleDependency.toString());
                }
                if (ret == null) {
                    throw new IllegalArgumentException("Module dependency has no Jar artifacts: " + String.valueOf(moduleDependency));
                }
                return ret;
            }
            throw new IllegalArgumentException("Unsupported dependency type: " + dependency.getClass().getName() + " -- " + String.valueOf(dependency));
        }

        private static String getFileName(ResolvedArtifact artifact) {
            try {
                return InvokerHelper.getProperty((Object)artifact.getId(), (String)"fileName").toString();
            }
            catch (Throwable e) {
                return artifact.getFile().getName();
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ResolvedDependencyInfoImpl that = (ResolvedDependencyInfoImpl)obj;
            return Objects.equals(this.module, that.module) && Objects.equals(this.version, that.version) && Objects.equals(this.versionRange, that.versionRange) && Objects.equals(this.artifact, that.artifact);
        }

        public int hashCode() {
            return Objects.hash(this.module, this.version, this.versionRange, this.artifact);
        }

        public String toString() {
            return "ResolvedDependencyInfo[module=" + String.valueOf(this.module) + ", fixedVersion=" + this.version + ", versionRange=" + this.versionRange + ", artifact=" + String.valueOf(this.artifact) + "]";
        }

        static final class MinimalModuleVersionIdentifier
        implements ModuleIdentifier,
        ModuleVersionIdentifier {
            private static final long serialVersionUID = -955346236759069739L;
            private String group;
            private String name;
            private final String version;

            @Inject
            public MinimalModuleVersionIdentifier(String group, String name, String version) {
                this.group = group;
                this.name = name;
                this.version = version;
            }

            public ModuleIdentifier getModule() {
                return this;
            }

            public String getGroup() {
                return this.group;
            }

            public String getName() {
                return this.name;
            }

            public String getVersion() {
                return this.version;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (this == obj) return true;
                if (!(obj instanceof MinimalModuleVersionIdentifier)) return false;
                MinimalModuleVersionIdentifier o = (MinimalModuleVersionIdentifier)obj;
                if (!Objects.equals(this.group, o.group)) return false;
                if (!Objects.equals(this.name, o.name)) return false;
                if (!Objects.equals(this.version, o.version)) return false;
                return true;
            }

            public int hashCode() {
                return Objects.hash(this.group, this.name, this.version);
            }

            public String toString() {
                return "MinimalModuleVersionIdentifier[group=" + this.group + ", name=" + this.name + ", version=" + this.version + "]";
            }
        }
    }

    public static interface ResolvedDependencyInfo {
        public void containedJarMetadata(Action<? super ContainedJarMetadataInfo> var1);

        public void setResource(String var1);

        public void setLayer(String var1);

        public void setId(String var1);

        public void setNested(boolean var1);

        public static interface ContainedJarMetadataInfo {
            public void setGroup(String var1);

            public void setName(String var1);

            public void setPath(String var1);
        }
    }
}

