/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.minecraftforge.forgedev.LegacyMinecraftExtension;
import net.minecraftforge.util.data.json.PatcherConfig;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public abstract class LegacyPatcherExtension
extends LegacyMinecraftExtension {
    public static final String EXTENSION_NAME = "patcher";
    private boolean srgPatches = true;
    private boolean notchObf = false;
    private List<Object> extraExcs;
    private List<Object> extraMappings;
    @Nullable
    private PatcherConfig.V2.DataFunction processor;

    @Inject
    public LegacyPatcherExtension() {
    }

    public abstract Property<Project> getParent();

    public abstract RegularFileProperty getCleanSrc();

    public abstract DirectoryProperty getPatchedSrc();

    public abstract DirectoryProperty getPatches();

    public abstract Property<String> getMcVersion();

    public boolean isSrgPatches() {
        return this.srgPatches;
    }

    public void setSrgPatches(boolean srgPatches) {
        this.srgPatches = srgPatches;
    }

    public boolean getNotchObf() {
        return this.notchObf;
    }

    public void setNotchObf(boolean value) {
        this.notchObf = value;
    }

    public abstract ConfigurableFileCollection getExcs();

    public void setExtraExcs(List<Object> extraExcs) {
        this.extraExcs = new ArrayList<Object>(extraExcs);
    }

    public void extraExcs(Object ... excs) {
        this.getExtraExcs().addAll(Arrays.asList(excs));
    }

    public void extraExc(Object exc) {
        this.extraExcs(exc);
    }

    public List<Object> getExtraExcs() {
        if (this.extraExcs == null) {
            this.extraExcs = new ArrayList<Object>();
        }
        return this.extraExcs;
    }

    public void extraMapping(Object mapping) {
        if (!(mapping instanceof String) && !(mapping instanceof File)) {
            throw new IllegalArgumentException("Extra mappings must be a file or a string!");
        }
        this.getExtraMappings().add(mapping);
    }

    public void setExtraMappings(List<Object> extraMappings) {
        this.extraMappings = new ArrayList<Object>(extraMappings);
    }

    public List<Object> getExtraMappings() {
        if (this.extraMappings == null) {
            this.extraMappings = new ArrayList<Object>();
        }
        return this.extraMappings;
    }

    @Nullable
    public PatcherConfig.V2.DataFunction getProcessor() {
        return this.processor;
    }

    public abstract MapProperty<String, File> getProcessorData();

    void copyFrom(LegacyPatcherExtension other) {
        this.getMappingChannel().set(other.getMappingChannel());
        this.getMappingVersion().set(other.getMappingVersion());
        this.getMcVersion().set(other.getMcVersion());
    }
}

