/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.util.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.logging.Log;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.logging.LogConsumer;

interface DelegatePrintStream {
    public static final PrintStream EMPTY = new Empty();

    public PrintStream getDelegate();

    public static final class Empty
    extends PrintStream
    implements DelegatePrintStream {
        private Empty() {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
        }

        @Override
        public boolean checkError() {
            return false;
        }

        @Override
        protected void clearError() {
        }

        @Override
        public PrintStream getDelegate() {
            return this;
        }
    }

    public static final class Capturing
    extends PrintStream
    implements DelegatePrintStream {
        private final PrintStream raw;

        public Capturing(final Log.Level level, final PrintStream stream) {
            super(new OutputStream(){
                private final Consumer<String> logger;
                private StringBuffer buffer;
                {
                    this.logger = new LogConsumer(level, stream::println);
                    this.buffer = new StringBuffer(512);
                }

                @Override
                public void write(int b) {
                    this.write((char)b);
                }

                private void write(char c) {
                    if (c == '\n' || c == '\r') {
                        if (this.buffer.length() != 0) {
                            this.logger.accept(this.buffer.insert(0, Log.getIndentation()).toString());
                            this.buffer = new StringBuffer(512);
                        }
                    } else {
                        this.buffer.append(c);
                    }
                }
            });
            this.raw = stream;
        }

        @Override
        public PrintStream getDelegate() {
            return this.raw;
        }
    }
}

