/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevPlugin;
import net.minecraftforge.forgedev.ForgeDevProblems;
import net.minecraftforge.forgedev.LegacyMCPExtension;
import net.minecraftforge.forgedev.LegacyPatcherExtension;
import net.minecraftforge.forgedev.Util;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.Closures;
import net.minecraftforge.forgedev.tasks.compat.LegacyExtractZip;
import net.minecraftforge.forgedev.tasks.compat.LegacyMergeFilesTask;
import net.minecraftforge.forgedev.tasks.filtering.LegacyFilterNewJar;
import net.minecraftforge.forgedev.tasks.generation.GeneratePatcherConfigV2;
import net.minecraftforge.forgedev.tasks.mappings.LegacyApplyMappings;
import net.minecraftforge.forgedev.tasks.mappings.LegacyGenerateSRG;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerMCPDataTask;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerMCPSetup;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerRawArtifact;
import net.minecraftforge.forgedev.tasks.mcp.MavenizerSyncMappings;
import net.minecraftforge.forgedev.tasks.obfuscation.LegacyReobfuscateJar;
import net.minecraftforge.forgedev.tasks.patching.binary.CreateBinPatches;
import net.minecraftforge.forgedev.tasks.patching.diff.ApplyPatches;
import net.minecraftforge.forgedev.tasks.patching.diff.BakePatches;
import net.minecraftforge.forgedev.tasks.patching.diff.GeneratePatches;
import net.minecraftforge.forgedev.tasks.srg2source.ApplyRangeMap;
import net.minecraftforge.forgedev.tasks.srg2source.ExtractRangeMap;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public abstract class ForgeDevExtension {
    public static final String NAME = "forgedev";
    private final ForgeDevProblems problems = (ForgeDevProblems)this.getObjects().newInstance(ForgeDevProblems.class, new Object[0]);
    private final DirectoryProperty mavenizerRepo = this.getObjects().directoryProperty();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public ForgeDevExtension(ForgeDevPlugin plugin, Project project) {
        this.mavenizerRepo.set(plugin.globalCaches().dir("repo").map(this.problems.ensureFileLocation()));
        this.setup(plugin, project);
    }

    public Closure getMaven() {
        return Closures.consumer(repo -> {
            repo.setName("ForgeDevMaven");
            repo.setUrl((Object)this.mavenizerRepo);
        });
    }

    @VisibleForTesting
    public DirectoryProperty getMavenizerRepo() {
        return this.mavenizerRepo;
    }

    private void setup(ForgeDevPlugin plugin, Project project) {
        TaskContainer tasks = project.getTasks();
        LegacyPatcherExtension legacyPatcher = (LegacyPatcherExtension)project.getExtensions().create("patcher", LegacyPatcherExtension.class, new Object[0]);
        LegacyMCPExtension legacyMcp = (LegacyMCPExtension)project.getExtensions().create("mcp", LegacyMCPExtension.class, new Object[0]);
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TaskProvider jar = tasks.named("jar", Jar.class);
        TaskProvider compileJava = tasks.named("compileJava", JavaCompile.class);
        NamedDomainObjectProvider main = java.getSourceSets().named("main");
        TaskProvider setupMCP = tasks.register("setupMCP", MavenizerMCPSetup.class);
        TaskProvider syncMappingsMaven = tasks.register("syncMappingsMaven", MavenizerSyncMappings.class);
        Util.runFirst(project, syncMappingsMaven);
        Configuration mappingsConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        Provider mappingsZipFile = this.getProviders().provider(() -> ((Configuration)mappingsConfiguration).getSingleFile());
        TaskProvider applyPatches = tasks.register("applyPatches", ApplyPatches.class, task -> {
            Provider workDir = project.getLayout().getBuildDirectory().dir(task.getName());
            task.getOutput().set(workDir.map(s -> s.file("output.zip")));
            task.getArchive().set((Object)"zip");
            task.setRejects(workDir.map(s -> s.file("rejects.zip")));
            task.getArchiveRejects().set((Object)"zip");
            task.getPatches().set((Provider)legacyPatcher.getPatches());
            task.getMode().set((Object)"access");
            if (project.hasProperty("UPDATING")) {
                task.getMode().set((Object)"fuzzy");
                task.setRejects(project.getLayout().getProjectDirectory().dir("rejects"));
                task.getArchiveRejects().unset();
                task.getFailOnError().set((Object)false);
            }
        });
        TaskProvider toMCPConfig = tasks.register("srg2mcp", LegacyApplyMappings.class, task -> {
            task.getInput().set(applyPatches.flatMap(ApplyPatches::getOutput));
            task.getMappingsZip().fileProvider(mappingsZipFile);
            task.getLambdas().set((Object)false);
        });
        TaskProvider extractMapped = tasks.register("extractMapped", LegacyExtractZip.class, task -> {
            task.getInput().set(toMCPConfig.flatMap(LegacyApplyMappings::getOutput));
            task.getOutput().set((Provider)legacyPatcher.getPatchedSrc());
        });
        TaskProvider extractRangeMap = tasks.register("extractRangeMap", ExtractRangeMap.class, task -> {
            task.getDependencies().from(new Object[]{jar.flatMap(AbstractArchiveTask::getArchiveFile)});
            task.getSources().from(new Object[]{main.map(s -> s.getJava().getSourceDirectories())});
            task.getDependencies().from(new Object[]{compileJava.map(JavaCompile::getClasspath)});
        });
        TaskProvider createMcp2Srg = tasks.register("createMcp2Srg", LegacyGenerateSRG.class, task -> task.getReverse().set((Object)true));
        TaskProvider createSrg2Mcp = tasks.register("createSrg2Mcp", LegacyGenerateSRG.class, task -> task.getReverse().set((Object)false));
        TaskProvider createMcp2Obf = tasks.register("createMcp2Obf", LegacyGenerateSRG.class, task -> {
            task.getNotch().set((Object)true);
            task.getReverse().set((Object)true);
        });
        TaskProvider createExc = tasks.register("createExc");
        TaskProvider applyRangeMap = tasks.register("applyRangeMap", ApplyRangeMap.class, task -> {
            task.getSources().from(new Object[]{main.map(s -> s.getJava().getSourceDirectories().minus((FileCollection)project.files(new Object[]{legacyPatcher.getPatchedSrc()})))});
            task.setOnlyIf(t -> !((ApplyRangeMap)t).getSources().isEmpty());
            task.getRangeMap().set(extractRangeMap.flatMap(ExtractRangeMap::getOutput));
            task.getSrgFiles().from(new Object[]{createMcp2Srg.flatMap(LegacyGenerateSRG::getOutput)});
            task.getExcFiles().from(new Object[]{legacyPatcher.getExcs()});
        });
        TaskProvider applyRangeMapBase = tasks.register("applyRangeMapBase", ApplyRangeMap.class, task -> {
            task.setOnlyIf(t -> legacyPatcher.getPatches().isPresent());
            task.getSources().from(new Object[]{legacyPatcher.getPatchedSrc()});
            task.getRangeMap().set(extractRangeMap.flatMap(ExtractRangeMap::getOutput));
            task.getSrgFiles().from(new Object[]{createMcp2Srg.flatMap(LegacyGenerateSRG::getOutput)});
            task.getExcFiles().from(new Object[]{legacyPatcher.getExcs()});
        });
        TaskProvider userdevConfig = tasks.register("userdevConfig", GeneratePatcherConfigV2.class);
        TaskProvider genPatches = tasks.register("genPatches", GeneratePatches.class, task -> {
            task.setOnlyIf(t -> legacyPatcher.getPatches().isPresent());
            task.getOutput().set((Provider)legacyPatcher.getPatches());
        });
        TaskProvider bakePatches = tasks.register("bakePatches", BakePatches.class, task -> {
            task.dependsOn(new Object[]{genPatches});
            task.getInput().set((Provider)legacyPatcher.getPatches());
            task.getOutput().set(new File(task.getTemporaryDir(), "output.zip"));
        });
        TaskProvider reobfJar = tasks.register("reobfJar", LegacyReobfuscateJar.class, task -> {
            task.getInput().set(jar.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getLibraries().from(new Object[]{project.getConfigurations().named("implementation")});
        });
        TaskProvider genJoinedBinPatches = tasks.register("genJoinedBinPatches", CreateBinPatches.class, task -> {
            task.getCreate().from(new Object[]{reobfJar.flatMap(LegacyReobfuscateJar::getOutput)});
            task.getOutput().convention(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("joined.lzma")));
        });
        TaskProvider genClientBinPatches = tasks.register("genClientBinPatches", CreateBinPatches.class, task -> {
            task.getCreate().from(new Object[]{reobfJar.flatMap(LegacyReobfuscateJar::getOutput)});
            task.getOutput().convention(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("client.lzma")));
        });
        TaskProvider genServerBinPatches = tasks.register("genServerBinPatches", CreateBinPatches.class, task -> {
            task.getCreate().from(new Object[]{reobfJar.flatMap(LegacyReobfuscateJar::getOutput)});
            task.getOutput().convention(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("server.lzma")));
        });
        TaskProvider genBinPatches = tasks.register("genBinPatches", task -> task.dependsOn(new Object[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches}));
        TaskProvider filterNew = tasks.register("filterJarNew", LegacyFilterNewJar.class, task -> task.getInput().set(reobfJar.flatMap(LegacyReobfuscateJar::getOutput)));
        TaskProvider srgSourcesJar = tasks.register("legacySourcesJar", Jar.class, task -> {
            task.setOnlyIf(t -> (Boolean)applyRangeMap.flatMap(ApplyRangeMap::getOutput).map(rf -> rf.getAsFile().exists()).getOrElse((Object)false));
            task.dependsOn(new Object[]{applyRangeMap});
            task.from(new Object[]{project.zipTree((Object)applyRangeMap.flatMap(ApplyRangeMap::getOutput))});
            task.getArchiveClassifier().set((Object)"sources");
        });
        TaskProvider universalJar = tasks.register("universalJar", Jar.class, task -> {
            task.dependsOn(new Object[]{filterNew});
            task.from(new Object[]{project.zipTree((Object)filterNew.flatMap(LegacyFilterNewJar::getOutput))});
            task.from(new Object[]{java.getSourceSets().named("main").map(SourceSet::getResources)});
            task.getArchiveClassifier().set((Object)"universal");
        });
        TaskProvider userdevJar = tasks.register("userdevJar", Jar.class, task -> {
            task.dependsOn(new Object[]{srgSourcesJar, bakePatches});
            task.setOnlyIf(t -> legacyPatcher.isSrgPatches());
            task.from((Object)userdevConfig.flatMap(GeneratePatcherConfigV2::getOutput), e -> e.rename(f -> "config.json"));
            task.from((Object)genJoinedBinPatches.flatMap(rec$ -> ((CreateBinPatches)rec$).getOutput()), e -> e.rename(f -> "joined.lzma"));
            task.from((Object)project.zipTree((Object)bakePatches.flatMap(BakePatches::getOutput)), e -> e.into((Object)"patches/"));
            task.getArchiveClassifier().set((Object)"userdev");
        });
        TaskProvider release = tasks.register("release", task -> task.dependsOn(new Object[]{srgSourcesJar, universalJar, userdevJar}));
        project.afterEvaluate(p -> {
            Dependency mappingsDependency = project.getDependencies().create((Object)"net.minecraft:mappings_%s:%s@zip".formatted(legacyPatcher.getMappingChannel().get(), legacyPatcher.getMappingVersion().get()));
            syncMappingsMaven.configure(task -> task.getVersion().set(legacyPatcher.getMappingVersion()));
            project.getDependencies().add("implementation", (Object)mappingsDependency);
            mappingsConfiguration.withDependencies(d -> d.add((Object)mappingsDependency));
            main.configure(s -> s.getJava().srcDir((Object)legacyPatcher.getPatchedSrc()));
            if (legacyPatcher.getPatches().isPresent()) {
                try {
                    Files.createDirectories(((Directory)legacyPatcher.getPatches().get()).getAsFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create patches folder", e);
                }
                srgSourcesJar.configure(task -> task.from((Object)genPatches.flatMap(GeneratePatches::getOutput), copy -> copy.into((Object)"patches/")));
            }
            setupMCP.configure(task -> {
                task.getPipeline().set(legacyMcp.getPipeline());
                task.getArtifact().set(legacyMcp.getConfig());
            });
            legacyPatcher.getCleanSrc().set(setupMCP.flatMap(rec$ -> ((MavenizerMCPSetup)rec$).getOutput()));
            applyPatches.configure(task -> task.getInput().convention((Provider)legacyPatcher.getCleanSrc()));
            genPatches.configure(task -> task.getInput().convention((Provider)legacyPatcher.getCleanSrc()));
            TaskProvider extractSrg = tasks.register("extractSrg", MavenizerMCPDataTask.class, task -> task.getArtifact().set(legacyMcp.getConfig()));
            createMcp2Srg.configure(task -> task.getMcpSrgData().convention(extractSrg.flatMap(MavenizerMCPDataTask::getOutput)));
            tasks.withType(LegacyGenerateSRG.class, task -> task.getMappingsZip().fileProvider(mappingsZipFile));
            createMcp2Obf.configure(task -> task.getMcpSrgData().convention(createMcp2Srg.flatMap(LegacyGenerateSRG::getMcpSrgData)));
            createSrg2Mcp.configure(task -> task.getMcpSrgData().convention(createMcp2Srg.flatMap(LegacyGenerateSRG::getMcpSrgData)));
            if (!legacyPatcher.getAccessTransformers().isEmpty()) {
                TaskProvider mergeATs = tasks.register("mergeATs", LegacyMergeFilesTask.class, task -> {
                    task.getFilesToMerge().setFrom((Iterable)legacyPatcher.getAccessTransformers());
                    task.getOutput().set(project.getLayout().getBuildDirectory().file("legacy-forgedev/merged_ats.cfg"));
                });
                setupMCP.configure(task -> {
                    task.dependsOn(new Object[]{mergeATs});
                    task.getAccessTransformerConfig().set(mergeATs.flatMap(LegacyMergeFilesTask::getOutput));
                });
                for (File f : legacyPatcher.getAccessTransformers()) {
                    userdevJar.configure(t -> t.from((Object)f, e -> e.into((Object)"ats/")));
                    userdevConfig.configure(t -> t.getATs().from(new Object[]{f}));
                }
            }
            if (!legacyPatcher.getExtraMappings().isEmpty()) {
                for (Object e : legacyPatcher.getExtraMappings()) {
                    if (e instanceof File) {
                        File e2 = (File)e;
                        userdevJar.configure(t -> t.from((Object)e2, c -> c.into((Object)"srgs/")));
                        userdevConfig.configure(t -> t.getSRGs().from(new Object[]{e2}));
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    String e3 = (String)e;
                    userdevConfig.configure(t -> t.getSRGLines().add((Object)e3));
                }
            }
            userdevConfig.configure(task -> {
                task.getMCPConfig().set(legacyMcp.getConfig());
                task.getBinpatcherVersion().set((Object)"1.2.2");
                task.getBinpatcherArguments().addAll((Object[])new String[]{"--clean", "{clean}", "--output", "{output}", "--apply", "{patch}"});
                task.getUniversal().convention(universalJar.flatMap(t -> t.getArchiveBaseName().flatMap(baseName -> t.getArchiveClassifier().flatMap(classifier -> t.getArchiveExtension().map(jarExt -> project.getGroup().toString() + ":" + baseName + ":" + String.valueOf(project.getVersion()) + ":" + classifier + "@" + jarExt)))));
                task.getSource().convention(srgSourcesJar.flatMap(t -> t.getArchiveBaseName().flatMap(baseName -> t.getArchiveClassifier().flatMap(classifier -> t.getArchiveExtension().map(jarExt -> project.getGroup().toString() + ":" + baseName + ":" + String.valueOf(project.getVersion()) + ":" + classifier + "@" + jarExt)))));
                task.getPatchesOriginalPrefix().convention(genPatches.flatMap(rec$ -> ((GeneratePatches)rec$).getBasePathPrefix()));
                task.getPatchesModifiedPrefix().convention(genPatches.flatMap(rec$ -> ((GeneratePatches)rec$).getModifiedPathPrefix()));
                task.getNotchObf().set((Object)legacyPatcher.getNotchObf());
            });
            if (legacyPatcher.isSrgPatches()) {
                genPatches.configure(task -> task.getModified().set(applyRangeMapBase.flatMap(ApplyRangeMap::getOutput)));
            } else {
                TaskProvider dirtyZip = tasks.register("patchedZip", Zip.class, task -> {
                    task.from(new Object[]{legacyPatcher.getPatchedSrc()});
                    task.getArchiveFileName().set((Object)"output.zip");
                    task.getDestinationDirectory().set(project.getLayout().getBuildDirectory().dir(task.getName()));
                });
                applyPatches.configure(task -> task.getArchiveBase().set((Object)"zip"));
                genPatches.configure(task -> {
                    task.getInput().fileProvider(applyPatches.flatMap(a -> a.getInput().getAsFile()));
                    task.getModified().set(dirtyZip.flatMap(AbstractArchiveTask::getArchiveFile));
                });
                Property<String> property = legacyMcp.getConfig();
                Provider srgNames = this.getProviders().provider(() -> !legacyPatcher.getNotchObf());
                Function<String, TaskProvider> rawJarTask = pipeline -> MavenizerRawArtifact.register(project, pipeline, (Provider<String>)mcpConfigArtifact, (Provider<Boolean>)srgNames);
                TaskProvider rawJoinedJar = rawJarTask.apply("joined");
                TaskProvider rawClientJar = rawJarTask.apply("client");
                TaskProvider rawServerJar = rawJarTask.apply("server");
                TaskProvider srg = legacyPatcher.getNotchObf() ? createMcp2Obf : createMcp2Srg;
                reobfJar.configure(task -> task.getSrg().set(srg.flatMap(LegacyGenerateSRG::getOutput)));
                genJoinedBinPatches.configure(task -> task.getClean().builtBy(new Object[]{rawJoinedJar}));
                genClientBinPatches.configure(task -> task.getClean().builtBy(new Object[]{rawClientJar}));
                genServerBinPatches.configure(task -> task.getClean().builtBy(new Object[]{rawServerJar}));
                tasks.withType(CreateBinPatches.class, task -> {
                    task.getSrg().from(new Object[]{srg.flatMap(LegacyGenerateSRG::getOutput)});
                    if (legacyPatcher.getPatches().isPresent()) {
                        task.mustRunAfter(new Object[]{genPatches});
                        task.getPatches().from(new Object[]{legacyPatcher.getPatches()});
                    }
                });
                filterNew.configure(task -> {
                    task.getSrg().set(srg.flatMap(LegacyGenerateSRG::getOutput));
                    task.getBlacklist().builtBy(new Object[]{rawJoinedJar});
                });
            }
        });
    }
}

