/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.Util;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptionsInternal;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptionsNested;
import net.minecraftforge.util.data.json.RunConfig;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class SlimeLauncherOptionsImpl
implements SlimeLauncherOptionsInternal {
    private final String name;
    private final Property<String> mainClass = this.getObjects().property(String.class);
    private final ListProperty<String> args = this.getObjects().listProperty(String.class);
    private final ListProperty<String> jvmArgs = this.getObjects().listProperty(String.class);
    private final ConfigurableFileCollection classpath = this.getObjects().fileCollection();
    private final Property<String> minHeapSize = this.getObjects().property(String.class);
    private final Property<String> maxHeapSize = this.getObjects().property(String.class);
    private final MapProperty<String, String> systemProperties = this.getObjects().mapProperty(String.class, String.class);
    private final MapProperty<String, String> environment = this.getObjects().mapProperty(String.class, String.class);
    private final DirectoryProperty workingDir = this.getObjects().directoryProperty();
    private final Property<Boolean> client = this.getObjects().property(Boolean.class).convention((Object)false);
    private final MapProperty<String, SlimeLauncherOptionsNested> nested = this.getObjects().mapProperty(String.class, SlimeLauncherOptionsNested.class);

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public SlimeLauncherOptionsImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    public ListProperty<String> getArgs() {
        return this.args;
    }

    @Override
    public ListProperty<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public Property<String> getMinHeapSize() {
        return this.minHeapSize;
    }

    @Override
    public Property<String> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Override
    public MapProperty<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public MapProperty<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public DirectoryProperty getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public Property<Boolean> getClient() {
        return this.client;
    }

    @Override
    public MapProperty<String, SlimeLauncherOptionsNested> getNested() {
        return this.nested;
    }

    @Override
    public void with(String sourceSetName, Action<? super SlimeLauncherOptionsNested> action) {
        SlimeLauncherOptionsImpl child = (SlimeLauncherOptionsImpl)this.getObjects().newInstance(SlimeLauncherOptionsImpl.class, new Object[]{this.name});
        action.execute((Object)child);
        this.nested.put((Object)sourceSetName, (Object)child);
    }

    @Override
    public void args(Object args) {
        this.getArgs().add(this.getProviders().provider(() -> Util.unpack((Object)args).toString()));
    }

    @Override
    public void args(Object ... args) {
        this.getArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>(args.length);
            for (Object arg : args) {
                ret.add(Util.unpack((Object)arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void args(Iterable<?> args) {
        this.getArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : args) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void args(Provider<? extends Iterable<?>> args) {
        this.getArgs().addAll(args.map(iterable -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : iterable) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void setArgs(String ... args) {
        this.getArgs().set(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (String arg : args) {
                ret.add(Util.unpack((Object)arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void jvmArgs(Object jvmArgs) {
        this.getJvmArgs().add(this.getProviders().provider(() -> Util.unpack((Object)jvmArgs).toString()));
    }

    @Override
    public void jvmArgs(Object ... jvmArgs) {
        this.getJvmArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : jvmArgs) {
                ret.add(Util.unpack((Object)arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void jvmArgs(Iterable<?> jvmArgs) {
        this.getJvmArgs().addAll(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : jvmArgs) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void jvmArgs(Provider<? extends Iterable<?>> jvmArgs) {
        this.getJvmArgs().addAll(jvmArgs.map(iterable -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : iterable) {
                ret.add(Util.unpack(arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void setJvmArgs(Object ... jvmArgs) {
        this.getJvmArgs().set(this.getProviders().provider(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object arg : jvmArgs) {
                ret.add(Util.unpack((Object)arg).toString());
            }
            return ret;
        }));
    }

    @Override
    public void systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, this.getProviders().provider(() -> Util.unpack((Object)value).toString()));
    }

    @Override
    public void systemProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.getSystemProperties().put((Object)entry.getKey(), this.getProviders().provider(() -> Util.unpack(entry.getValue()).toString()));
        }
    }

    @Override
    public void systemProperties(Provider<? extends Map<String, ?>> properties) {
        this.getSystemProperties().putAll(properties.map(map -> {
            HashMap<String, String> ret = new HashMap<String, String>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ret.put((String)entry.getKey(), Util.unpack(entry.getValue()).toString());
            }
            return ret;
        }));
    }

    @Override
    public void environment(String name, Object value) {
        this.getSystemProperties().put((Object)name, this.getProviders().provider(() -> Util.unpack((Object)value).toString()));
    }

    @Override
    public void environment(Map<String, ?> environment) {
        for (Map.Entry<String, ?> entry : environment.entrySet()) {
            this.getEnvironment().put((Object)entry.getKey(), this.getProviders().provider(() -> Util.unpack(entry.getValue()).toString()));
        }
    }

    @Override
    public void environment(Provider<? extends Map<String, ?>> properties) {
        this.getEnvironment().putAll(properties.map(map -> {
            HashMap<String, String> ret = new HashMap<String, String>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ret.put((String)entry.getKey(), Util.unpack(entry.getValue()).toString());
            }
            return ret;
        }));
    }

    @Override
    public SlimeLauncherOptionsInternal inherit(Map<String, RunConfig> configs, String sourceSetName, String name) {
        SlimeLauncherOptionsImpl target = (SlimeLauncherOptionsImpl)this.getObjects().newInstance(SlimeLauncherOptionsImpl.class, new Object[]{name});
        target.getMainClass().convention(this.getMainClass());
        target.getArgs().convention(this.getArgs());
        target.getJvmArgs().convention(this.getJvmArgs());
        target.getClasspath().convention((Iterable)this.getClasspath());
        target.getMinHeapSize().convention(this.getMinHeapSize());
        target.getMaxHeapSize().convention(this.getMaxHeapSize());
        target.getSystemProperties().convention(this.getSystemProperties());
        target.getEnvironment().convention(this.getEnvironment());
        target.getWorkingDir().convention(this.getWorkingDir().orElse((Object)this.getProjectLayout().getProjectDirectory().dir("runs/" + sourceSetName + "/" + this.name)));
        target.getClient().convention(this.getClient());
        return this.inherit(target, sourceSetName, configs, name);
    }

    private SlimeLauncherOptionsInternal inherit(SlimeLauncherOptionsInternal target, String sourceSetName, Map<String, RunConfig> configs, String name) {
        SlimeLauncherOptionsNested child;
        RunConfig config = configs.get(name);
        if (config != null) {
            if (config.parents != null && !config.parents.isEmpty()) {
                config.parents.forEach(parent -> this.inherit(target, sourceSetName, configs, (String)parent));
            }
            if (config.main != null) {
                target.getMainClass().convention((Object)config.main);
            }
            if (config.args != null && !config.args.isEmpty()) {
                target.getArgs().convention(List.copyOf(config.args));
            }
            if (config.jvmArgs != null && !config.jvmArgs.isEmpty()) {
                target.jvmArgs(config.jvmArgs);
            }
            target.getClient().convention((Object)config.client);
            if (config.buildAllProjects) {
                LOGGER.warn("WARNING: ForgeGradle 7 does not support the buildAllProjects feature.");
            }
            if (config.env != null && !config.env.isEmpty()) {
                target.environment(config.env);
            }
            if (config.props != null && !config.props.isEmpty()) {
                target.systemProperties(config.props);
            }
        }
        if ((child = (SlimeLauncherOptionsNested)this.nested.getting((Object)sourceSetName).getOrNull()) != null) {
            if (child.getMainClass().filter(Util.IS_NOT_BLANK).isPresent()) {
                target.getMainClass().set(child.getMainClass());
            }
            target.args((Iterable)child.getArgs().getOrElse(List.of()));
            target.jvmArgs((Iterable)child.getJvmArgs().getOrElse(List.of()));
            if (child.getMaxHeapSize().filter(Util.IS_NOT_BLANK).isPresent()) {
                target.getMaxHeapSize().set(child.getMaxHeapSize());
            }
            if (child.getMinHeapSize().filter(Util.IS_NOT_BLANK).isPresent()) {
                target.getMinHeapSize().set(child.getMinHeapSize());
            }
            target.environment((Map)child.getEnvironment().getOrElse(Map.of()));
            target.systemProperties((Map)child.getSystemProperties().getOrElse(Map.of()));
            target.getWorkingDir().set((Provider)child.getWorkingDir());
        }
        return target;
    }

    public String toString() {
        return "SlimeLauncherOptionsImpl{name=" + this.name + ", mainClass=" + (String)this.mainClass.getOrNull() + ", args=[" + String.join((CharSequence)", ", (Iterable)this.args.getOrElse(List.of())) + "], jvmArgs=[" + String.join((CharSequence)", ", (Iterable)this.jvmArgs.getOrElse(List.of())) + "], classpath=[" + this.classpath.getAsPath() + "], minHeapSize=" + (String)this.minHeapSize.getOrNull() + ", maxHeapSize=" + (String)this.maxHeapSize.getOrNull() + ", systemProperties=" + String.valueOf(this.systemProperties.getOrNull()) + ", environment=" + String.valueOf(this.environment.getOrNull()) + ", workingDir=" + String.valueOf(this.workingDir.getOrNull()) + ", client=" + String.valueOf(this.client.getOrNull()) + "}";
    }
}

