/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer;

import java.io.Closeable;
import java.io.FilterWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.StringJoiner;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.util.Preconditions;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.util.Util;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer.FastBufferedWriter;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer.LineDelimiter;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer.NoCloseWriter;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer.QuoteStrategy;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer.UnbufferedWriter;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.writer.Writable;

public final class CsvWriter
implements Closeable,
Flushable {
    private final Writable writer;
    private final char fieldSeparator;
    private final char quoteCharacter;
    private final char commentCharacter;
    private final QuoteStrategy quoteStrategy;
    private final LineDelimiter lineDelimiter;
    private int currentLineNo = 1;
    private final char[] lineDelimiterChars;
    private final char[] emptyFieldValue;
    private boolean openRecordWriter;

    CsvWriter(Writable writer, char fieldSeparator, char quoteCharacter, char commentCharacter, QuoteStrategy quoteStrategy, LineDelimiter lineDelimiter) {
        Preconditions.checkArgument(!Util.isNewline(fieldSeparator), "fieldSeparator must not be a newline char");
        Preconditions.checkArgument(!Util.isNewline(quoteCharacter), "quoteCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.isNewline(commentCharacter), "commentCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.containsDupe(fieldSeparator, quoteCharacter, commentCharacter), "Control characters must differ (fieldSeparator=%s, quoteCharacter=%s, commentCharacter=%s)", Character.valueOf(fieldSeparator), Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter));
        this.writer = writer;
        this.fieldSeparator = fieldSeparator;
        this.quoteCharacter = quoteCharacter;
        this.commentCharacter = commentCharacter;
        this.quoteStrategy = quoteStrategy;
        this.lineDelimiter = Objects.requireNonNull(lineDelimiter);
        this.emptyFieldValue = new char[]{quoteCharacter, quoteCharacter};
        this.lineDelimiterChars = lineDelimiter.toString().toCharArray();
    }

    public static CsvWriterBuilder builder() {
        return new CsvWriterBuilder();
    }

    public CsvWriter writeRecord(Iterable<String> values) {
        this.validateNoOpenRecord();
        try {
            int fieldIdx = 0;
            for (String value : values) {
                this.writeInternal(value, fieldIdx++);
            }
            return this.endRecord();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CsvWriter writeRecord(String ... values) {
        this.validateNoOpenRecord();
        try {
            for (int i = 0; i < values.length; ++i) {
                this.writeInternal(values[i], i);
            }
            return this.endRecord();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CsvWriterRecord writeRecord() {
        this.validateNoOpenRecord();
        this.openRecordWriter = true;
        return new CsvWriterRecord();
    }

    private void validateNoOpenRecord() {
        if (this.openRecordWriter) {
            throw new IllegalStateException("Record already started, call end() on CsvWriterRecord first");
        }
    }

    private void writeInternal(String value, int fieldIdx) throws IOException {
        boolean needsQuotes;
        if (fieldIdx > 0) {
            this.writer.write(this.fieldSeparator);
        }
        if (value == null) {
            if (this.quoteStrategy != null && this.quoteStrategy.quoteNull(this.currentLineNo, fieldIdx)) {
                this.writer.write(this.emptyFieldValue, 0, this.emptyFieldValue.length);
            }
            return;
        }
        int length = value.length();
        if (length == 0) {
            if (this.quoteStrategy != null && this.quoteStrategy.quoteEmpty(this.currentLineNo, fieldIdx)) {
                this.writer.write(this.emptyFieldValue, 0, this.emptyFieldValue.length);
            }
            return;
        }
        boolean needsEscape = this.containsControlCharacter(value, fieldIdx, length);
        boolean bl = needsQuotes = needsEscape || this.quoteStrategy != null && this.quoteStrategy.quoteNonEmpty(this.currentLineNo, fieldIdx, value);
        if (needsQuotes) {
            this.writer.write(this.quoteCharacter);
        }
        if (needsEscape) {
            CsvWriter.writeEscaped(this.writer, value, this.quoteCharacter);
        } else {
            this.writer.write(value, 0, length);
        }
        if (needsQuotes) {
            this.writer.write(this.quoteCharacter);
        }
    }

    private boolean containsControlCharacter(String value, int fieldIdx, int length) {
        if (fieldIdx == 0 && value.charAt(0) == this.commentCharacter) {
            return true;
        }
        if (length > 20) {
            return value.indexOf(this.quoteCharacter) != -1 || value.indexOf(this.fieldSeparator) != -1 || value.indexOf(10) != -1 || value.indexOf(13) != -1;
        }
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c != this.quoteCharacter && c != this.fieldSeparator && c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    private static void writeEscaped(Writable w, String value, char quoteChar) throws IOException {
        int startPos = 0;
        int nextDelimPos = value.indexOf(quoteChar, startPos);
        while (nextDelimPos != -1) {
            w.write(value, startPos, nextDelimPos - startPos + 1);
            w.write(quoteChar);
            startPos = nextDelimPos + 1;
            nextDelimPos = value.indexOf(quoteChar, startPos);
        }
        w.write(value, startPos, value.length() - startPos);
    }

    public CsvWriter writeComment(String comment) {
        this.validateNoOpenRecord();
        try {
            this.writer.write(this.commentCharacter);
            if (comment != null && !comment.isEmpty()) {
                this.writeCommentInternal(comment);
            }
            return this.endRecord();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeCommentInternal(String comment) throws IOException {
        int length = comment.length();
        int startPos = 0;
        char lastChar = '\u0000';
        for (int i = 0; i < length; ++i) {
            char c = comment.charAt(i);
            if (c == '\r') {
                this.writeFragment(comment, i, startPos);
                startPos = i + 1;
            } else if (c == '\n') {
                if (lastChar != '\r') {
                    this.writeFragment(comment, i, startPos);
                }
                startPos = i + 1;
            }
            lastChar = c;
        }
        if (length > startPos) {
            this.writer.write(comment, startPos, length - startPos);
        }
    }

    private void writeFragment(String comment, int i, int startPos) throws IOException {
        if (i > startPos) {
            this.writer.write(comment, startPos, i - startPos);
        }
        this.writer.write(this.lineDelimiterChars, 0, this.lineDelimiterChars.length);
        this.writer.write(this.commentCharacter);
    }

    private CsvWriter endRecord() throws IOException {
        ++this.currentLineNo;
        this.writer.write(this.lineDelimiterChars, 0, this.lineDelimiterChars.length);
        this.writer.endRecord();
        return this;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public String toString() {
        return new StringJoiner(", ", CsvWriter.class.getSimpleName() + "[", "]").add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentCharacter=" + this.commentCharacter).add("quoteStrategy=" + String.valueOf(this.quoteStrategy)).add("lineDelimiter='" + String.valueOf((Object)this.lineDelimiter) + "'").toString();
    }

    public static final class CsvWriterBuilder {
        private static final int DEFAULT_BUFFER_SIZE = 8192;
        private char fieldSeparator = (char)44;
        private char quoteCharacter = (char)34;
        private char commentCharacter = (char)35;
        private QuoteStrategy quoteStrategy;
        private LineDelimiter lineDelimiter = LineDelimiter.CRLF;
        private int bufferSize = 8192;
        private boolean autoFlush;

        CsvWriterBuilder() {
        }

        public CsvWriterBuilder fieldSeparator(char fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public CsvWriterBuilder quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public CsvWriterBuilder commentCharacter(char commentCharacter) {
            this.commentCharacter = commentCharacter;
            return this;
        }

        public CsvWriterBuilder quoteStrategy(QuoteStrategy quoteStrategy) {
            this.quoteStrategy = quoteStrategy;
            return this;
        }

        public CsvWriterBuilder lineDelimiter(LineDelimiter lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public CsvWriterBuilder bufferSize(int bufferSize) {
            Preconditions.checkArgument(bufferSize >= 0, "buffer size must be >= 0");
            this.bufferSize = bufferSize;
            return this;
        }

        public CsvWriterBuilder autoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
            return this;
        }

        public CsvWriter build(OutputStream outputStream) {
            Objects.requireNonNull(outputStream, "outputStream must not be null");
            return this.build(outputStream, StandardCharsets.UTF_8);
        }

        public CsvWriter build(OutputStream outputStream, Charset charset) {
            Objects.requireNonNull(outputStream, "outputStream must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            return this.csvWriter(new OutputStreamWriter(outputStream, charset), this.bufferSize, false, this.autoFlush);
        }

        public CsvWriter build(Writer writer) {
            Objects.requireNonNull(writer, "writer must not be null");
            return this.csvWriter(writer, this.bufferSize, true, this.autoFlush);
        }

        public CsvWriter build(Path file, OpenOption ... openOptions) throws IOException {
            return this.build(file, StandardCharsets.UTF_8, openOptions);
        }

        public CsvWriter build(Path file, Charset charset, OpenOption ... openOptions) throws IOException {
            Objects.requireNonNull(file, "file must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            return this.csvWriter(new OutputStreamWriter(Files.newOutputStream(file, openOptions), charset), this.bufferSize, false, this.autoFlush);
        }

        public CsvWriter toConsole() {
            NoCloseWriter writer = new NoCloseWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
            return this.csvWriter(writer, 0, false, true);
        }

        private CsvWriter csvWriter(Writer writer, int bufferSize, boolean autoFlushBuffer, boolean autoFlushWriter) {
            FilterWriter writable = bufferSize > 0 ? new FastBufferedWriter(writer, bufferSize, autoFlushBuffer, autoFlushWriter) : new UnbufferedWriter(writer, autoFlushWriter);
            return new CsvWriter((Writable)((Object)writable), this.fieldSeparator, this.quoteCharacter, this.commentCharacter, this.quoteStrategy, this.lineDelimiter);
        }

        public String toString() {
            return new StringJoiner(", ", CsvWriterBuilder.class.getSimpleName() + "[", "]").add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentCharacter=" + this.commentCharacter).add("quoteStrategy=" + String.valueOf(this.quoteStrategy)).add("lineDelimiter=" + String.valueOf((Object)this.lineDelimiter)).add("bufferSize=" + this.bufferSize).add("autoFlush=" + this.autoFlush).toString();
        }
    }

    public final class CsvWriterRecord {
        private int fieldIdx;

        private CsvWriterRecord() {
        }

        public CsvWriterRecord writeField(String value) {
            try {
                CsvWriter.this.writeInternal(value, this.fieldIdx++);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this;
        }

        public CsvWriter endRecord() {
            CsvWriter.this.openRecordWriter = false;
            try {
                return CsvWriter.this.endRecord();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

