/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.AbstractInternalCsvCallbackHandler;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.FieldModifier;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.NamedCsvRecord;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.RecordWrapper;

public final class NamedCsvRecordHandler
extends AbstractInternalCsvCallbackHandler<NamedCsvRecord> {
    private static final String[] EMPTY_HEADER = new String[0];
    private String[] header;

    @Deprecated(since="3.6.0", forRemoval=true)
    public NamedCsvRecordHandler() {
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public NamedCsvRecordHandler(List<String> header) {
        this.setHeader(header.toArray(new String[0]));
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public NamedCsvRecordHandler(String ... header) {
        this.setHeader(header);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public NamedCsvRecordHandler(FieldModifier fieldModifier) {
        super(fieldModifier);
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public NamedCsvRecordHandler(FieldModifier fieldModifier, List<String> header) {
        super(fieldModifier);
        this.setHeader(header.toArray(new String[0]));
    }

    @Deprecated(since="3.6.0", forRemoval=true)
    public NamedCsvRecordHandler(FieldModifier fieldModifier, String ... header) {
        super(fieldModifier);
        this.setHeader(header);
    }

    private NamedCsvRecordHandler(int maxFields, int maxFieldSize, int maxRecordSize, FieldModifier fieldModifier, List<String> header) {
        super(maxFields, maxFieldSize, maxRecordSize, fieldModifier);
        if (header != null) {
            this.setHeader(header.toArray(new String[0]));
        }
    }

    public static NamedCsvRecordHandlerBuilder builder() {
        return new NamedCsvRecordHandlerBuilder();
    }

    public static NamedCsvRecordHandler of() {
        return NamedCsvRecordHandler.builder().build();
    }

    public static NamedCsvRecordHandler of(Consumer<NamedCsvRecordHandlerBuilder> configurer) {
        Objects.requireNonNull(configurer, "configurer must not be null");
        NamedCsvRecordHandlerBuilder builder = NamedCsvRecordHandler.builder();
        configurer.accept(builder);
        return builder.build();
    }

    private void setHeader(String ... header) {
        Objects.requireNonNull(header, "header must not be null");
        for (String h : header) {
            Objects.requireNonNull(h, "header element must not be null");
        }
        this.header = (String[])header.clone();
    }

    @Override
    protected RecordWrapper<NamedCsvRecord> buildRecord() {
        if (this.comment) {
            return this.buildWrapper(new NamedCsvRecord(this.startingLineNumber, this.compactFields(), true, EMPTY_HEADER));
        }
        if (this.header == null) {
            this.setHeader(this.compactFields());
            return null;
        }
        return this.buildWrapper(new NamedCsvRecord(this.startingLineNumber, this.compactFields(), false, this.header));
    }

    public static final class NamedCsvRecordHandlerBuilder
    extends AbstractInternalCsvCallbackHandler.AbstractInternalCsvCallbackHandlerBuilder<NamedCsvRecordHandlerBuilder> {
        private List<String> header;

        private NamedCsvRecordHandlerBuilder() {
        }

        public NamedCsvRecordHandlerBuilder header(String ... header) {
            Objects.requireNonNull(header, "header must not be null");
            this.header = List.of(header);
            return this;
        }

        public NamedCsvRecordHandlerBuilder header(List<String> header) {
            Objects.requireNonNull(header, "header must not be null");
            this.header = List.copyOf(header);
            return this;
        }

        @Override
        protected NamedCsvRecordHandlerBuilder self() {
            return this;
        }

        public NamedCsvRecordHandler build() {
            return new NamedCsvRecordHandler(this.maxFields, this.maxFieldSize, this.maxRecordSize, this.fieldModifier, this.header);
        }
    }
}

