/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CsvRecord;

public final class NamedCsvRecord
extends CsvRecord {
    private final String[] header;

    NamedCsvRecord(long startingLineNumber, String[] fields, boolean comment, String[] header) {
        super(startingLineNumber, fields, comment);
        this.header = header;
    }

    public List<String> getHeader() {
        return Collections.unmodifiableList(Arrays.asList(this.header));
    }

    public String getField(String name) {
        int fieldIdx = this.findHeaderIndex(name);
        if (fieldIdx == -1) {
            throw new NoSuchElementException(String.format("Header does not contain a field '%s'. Valid names are: %s", name, Arrays.toString(this.header)));
        }
        if (fieldIdx >= this.fields.length) {
            throw new NoSuchElementException(String.format("Field '%s' is on index %d, but current record only contains %d fields", name, fieldIdx, this.fields.length));
        }
        return this.fields[fieldIdx];
    }

    private int findHeaderIndex(String name) {
        for (int i = 0; i < this.header.length; ++i) {
            if (!name.equals(this.header[i])) continue;
            return i;
        }
        return -1;
    }

    public Optional<String> findField(String name) {
        int fieldIdx = this.findHeaderIndex(name);
        if (fieldIdx == -1 || fieldIdx >= this.fields.length) {
            return Optional.empty();
        }
        return Optional.of(this.fields[fieldIdx]);
    }

    public List<String> findFields(String name) {
        int bound = this.header.length;
        ArrayList<String> ret = new ArrayList<String>(bound);
        for (int i = 0; i < bound; ++i) {
            if (!name.equals(this.header[i])) continue;
            ret.add(this.fields[i]);
        }
        return ret;
    }

    public Map<String, String> getFieldsAsMap() {
        int bound = this.commonSize();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(bound);
        for (int i = 0; i < bound; ++i) {
            map.putIfAbsent(this.header[i], this.fields[i]);
        }
        return map;
    }

    public Map<String, List<String>> getFieldsAsMapList() {
        int bound = this.commonSize();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(bound);
        for (int i = 0; i < bound; ++i) {
            String key = this.header[i];
            LinkedList<String> val = (LinkedList<String>)map.get(key);
            if (val == null) {
                val = new LinkedList<String>();
                map.put(key, val);
            }
            val.add(this.fields[i]);
        }
        return map;
    }

    private int commonSize() {
        return Math.min(this.header.length, this.fields.length);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NamedCsvRecord.class.getSimpleName() + "[", "]").add("startingLineNumber=" + this.startingLineNumber).add("fields=" + Arrays.toString(this.fields)).add("comment=" + this.comment).add("header=" + Arrays.toString(this.header)).toString();
    }
}

