/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.BomInputStreamReader;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.BomUtil;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CloseableIterator;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CommentStrategy;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CsvCallbackHandler;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CsvParseException;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CsvParser;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CsvRecord;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CsvRecordHandler;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.NamedCsvRecord;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.NamedCsvRecordHandler;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.RecordWrapper;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.util.Limits;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.util.Preconditions;

public final class CsvReader<T>
implements Iterable<T>,
Closeable {
    private final CsvParser csvParser;
    private final CsvCallbackHandler<T> callbackHandler;
    private final CommentStrategy commentStrategy;
    private final boolean skipEmptyLines;
    private final boolean ignoreDifferentFieldCount;
    private final CloseableIterator<T> csvRecordIterator = new CsvRecordIterator();
    private int firstRecordFieldCount = -1;

    CsvReader(CsvParser csvParser, CsvCallbackHandler<T> callbackHandler, CommentStrategy commentStrategy, boolean skipEmptyLines, boolean ignoreDifferentFieldCount) {
        this.csvParser = csvParser;
        this.callbackHandler = callbackHandler;
        this.commentStrategy = commentStrategy;
        this.skipEmptyLines = skipEmptyLines;
        this.ignoreDifferentFieldCount = ignoreDifferentFieldCount;
    }

    public static CsvReaderBuilder builder() {
        return new CsvReaderBuilder();
    }

    public void skipLines(int lineCount) {
        if (lineCount < 0) {
            throw new IllegalArgumentException("lineCount must be non-negative");
        }
        try {
            for (int i = 0; i < lineCount; ++i) {
                if (this.csvParser.skipLine(0)) continue;
                throw new CsvParseException("Not enough lines to skip. Skipped only " + i + " line(s).");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int skipLines(Predicate<String> predicate, int maxLines) {
        Objects.requireNonNull(predicate, "predicate must not be null");
        if (maxLines < 0) {
            throw new IllegalArgumentException("maxLines must be non-negative");
        }
        if (maxLines == 0) {
            return 0;
        }
        try {
            for (int i = 0; i < maxLines; ++i) {
                String line = this.csvParser.peekLine();
                if (predicate.test(line)) {
                    return i;
                }
                if (this.csvParser.skipLine(line.length())) continue;
                throw new CsvParseException(String.format("No matching line found. Skipped %d line(s) before reaching end of data.", i));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new CsvParseException(String.format("No matching line found within the maximum limit of %d lines.", maxLines));
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.csvRecordIterator;
    }

    @Override
    public Spliterator<T> spliterator() {
        return new CsvSpliterator();
    }

    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private T fetchRecord() throws IOException {
        while (this.csvParser.parse()) {
            T csvRecord = this.processRecord();
            if (csvRecord == null) continue;
            return csvRecord;
        }
        this.callbackHandler.terminate();
        return null;
    }

    private T processRecord() {
        RecordWrapper<T> recordWrapper = this.callbackHandler.buildRecord();
        if (recordWrapper == null) {
            return null;
        }
        if (recordWrapper.isComment()) {
            return this.commentStrategy == CommentStrategy.SKIP ? null : (T)recordWrapper.getWrappedRecord();
        }
        if (recordWrapper.isEmptyLine()) {
            return this.skipEmptyLines ? null : (T)recordWrapper.getWrappedRecord();
        }
        if (!this.ignoreDifferentFieldCount) {
            this.checkFieldCountConsistency(recordWrapper.getFieldCount());
        }
        return recordWrapper.getWrappedRecord();
    }

    private void checkFieldCountConsistency(int fieldCount) {
        if (this.firstRecordFieldCount == -1) {
            this.firstRecordFieldCount = fieldCount;
        } else if (fieldCount != this.firstRecordFieldCount) {
            throw new CsvParseException(String.format("Record %d has %d fields, but first record had %d fields", this.csvParser.getStartingLineNumber(), fieldCount, this.firstRecordFieldCount));
        }
    }

    @Override
    public void close() throws IOException {
        this.csvParser.close();
    }

    public String toString() {
        return new StringJoiner(", ", CsvReader.class.getSimpleName() + "[", "]").add("commentStrategy=" + String.valueOf((Object)this.commentStrategy)).add("skipEmptyLines=" + this.skipEmptyLines).add("ignoreDifferentFieldCount=" + this.ignoreDifferentFieldCount).toString();
    }

    private T fetch() {
        try {
            return this.fetchRecord();
        }
        catch (IOException e) {
            throw new UncheckedIOException(this.buildExceptionMessage(), e);
        }
        catch (Throwable t) {
            throw new CsvParseException(this.buildExceptionMessage(), t);
        }
    }

    private String buildExceptionMessage() {
        return this.csvParser.getStartingLineNumber() == 1L ? "Exception when reading first record" : String.format("Exception when reading record that started in line %d", this.csvParser.getStartingLineNumber());
    }

    private class CsvRecordIterator
    implements CloseableIterator<T> {
        private T fetchedRecord;
        private boolean fetched;

        private CsvRecordIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.fetched) {
                this.fetchedRecord = CsvReader.this.fetch();
                this.fetched = true;
            }
            return this.fetchedRecord != null;
        }

        @Override
        public T next() {
            if (!this.fetched) {
                this.fetchedRecord = CsvReader.this.fetch();
            }
            if (this.fetchedRecord == null) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            return this.fetchedRecord;
        }

        @Override
        public void close() throws IOException {
            CsvReader.this.close();
        }
    }

    public static final class CsvReaderBuilder {
        private static final int DEFAULT_MAX_BUFFER_SIZE = 0x1000000;
        private char fieldSeparator = (char)44;
        private char quoteCharacter = (char)34;
        private CommentStrategy commentStrategy = CommentStrategy.NONE;
        private char commentCharacter = (char)35;
        private boolean skipEmptyLines = true;
        private boolean ignoreDifferentFieldCount = true;
        private boolean acceptCharsAfterQuotes = true;
        private boolean detectBomHeader;
        private int maxBufferSize = Math.min(0x1000000, Limits.MAX_FIELD_SIZE);

        private CsvReaderBuilder() {
        }

        public CsvReaderBuilder fieldSeparator(char fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public CsvReaderBuilder quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public CsvReaderBuilder commentStrategy(CommentStrategy commentStrategy) {
            this.commentStrategy = commentStrategy;
            return this;
        }

        public CsvReaderBuilder commentCharacter(char commentCharacter) {
            this.commentCharacter = commentCharacter;
            return this;
        }

        public CsvReaderBuilder skipEmptyLines(boolean skipEmptyLines) {
            this.skipEmptyLines = skipEmptyLines;
            return this;
        }

        public CsvReaderBuilder ignoreDifferentFieldCount(boolean ignoreDifferentFieldCount) {
            this.ignoreDifferentFieldCount = ignoreDifferentFieldCount;
            return this;
        }

        public CsvReaderBuilder acceptCharsAfterQuotes(boolean acceptCharsAfterQuotes) {
            this.acceptCharsAfterQuotes = acceptCharsAfterQuotes;
            return this;
        }

        public CsvReaderBuilder detectBomHeader(boolean detectBomHeader) {
            this.detectBomHeader = detectBomHeader;
            return this;
        }

        public CsvReaderBuilder maxBufferSize(int maxBufferSize) {
            Preconditions.checkArgument(maxBufferSize > 0, "maxBufferSize must be greater than 0");
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public CsvReader<CsvRecord> ofCsvRecord(InputStream inputStream) {
            return this.build(CsvRecordHandler.of(), inputStream);
        }

        public CsvReader<CsvRecord> ofCsvRecord(InputStream inputStream, Charset charset) {
            return this.build(CsvRecordHandler.of(), inputStream, charset);
        }

        public CsvReader<CsvRecord> ofCsvRecord(Reader reader) {
            return this.build(CsvRecordHandler.of(), reader);
        }

        public CsvReader<CsvRecord> ofCsvRecord(String data) {
            return this.build(CsvRecordHandler.of(), data);
        }

        public CsvReader<CsvRecord> ofCsvRecord(Path file) throws IOException {
            return this.build(CsvRecordHandler.of(), file);
        }

        public CsvReader<CsvRecord> ofCsvRecord(Path file, Charset charset) throws IOException {
            return this.build(CsvRecordHandler.of(), file, charset);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(InputStream inputStream) {
            return this.build(NamedCsvRecordHandler.of(), inputStream);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(InputStream inputStream, Charset charset) {
            return this.build(NamedCsvRecordHandler.of(), inputStream, charset);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(Reader reader) {
            return this.build(NamedCsvRecordHandler.of(), reader);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(String data) {
            return this.build(NamedCsvRecordHandler.of(), data);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(Path file) throws IOException {
            return this.build(NamedCsvRecordHandler.of(), file);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(Path file, Charset charset) throws IOException {
            return this.build(NamedCsvRecordHandler.of(), file, charset);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, InputStream inputStream) {
            return this.build(callbackHandler, inputStream, StandardCharsets.UTF_8);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, InputStream inputStream, Charset charset) {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(inputStream, "inputStream must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            Reader reader = this.detectBomHeader ? new BomInputStreamReader(inputStream, charset) : new InputStreamReader(inputStream, charset);
            return this.build(callbackHandler, reader);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, Reader reader) {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(reader, "reader must not be null");
            CsvParser csvParser = new CsvParser(this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.acceptCharsAfterQuotes, callbackHandler, this.maxBufferSize, reader);
            return this.newReader(callbackHandler, csvParser);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, String data) {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(data, "data must not be null");
            CsvParser csvParser = new CsvParser(this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.acceptCharsAfterQuotes, callbackHandler, data);
            return this.newReader(callbackHandler, csvParser);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, Path file) throws IOException {
            return this.build(callbackHandler, file, StandardCharsets.UTF_8);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, Path file, Charset charset) throws IOException {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(file, "file must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            Reader reader = this.detectBomHeader ? BomUtil.openReader(file, charset) : new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), charset);
            return this.build(callbackHandler, reader);
        }

        private <T> CsvReader<T> newReader(CsvCallbackHandler<T> callbackHandler, CsvParser csvParser) {
            return new CsvReader<T>(csvParser, callbackHandler, this.commentStrategy, this.skipEmptyLines, this.ignoreDifferentFieldCount);
        }

        public String toString() {
            return new StringJoiner(", ", CsvReaderBuilder.class.getSimpleName() + "[", "]").add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentStrategy=" + String.valueOf((Object)this.commentStrategy)).add("commentCharacter=" + this.commentCharacter).add("skipEmptyLines=" + this.skipEmptyLines).add("ignoreDifferentFieldCount=" + this.ignoreDifferentFieldCount).add("acceptCharsAfterQuotes=" + this.acceptCharsAfterQuotes).add("detectBomHeader=" + this.detectBomHeader).add("maxBufferSize=" + this.maxBufferSize).toString();
        }
    }

    private class CsvSpliterator
    implements Spliterator<T> {
        private CsvSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Object t = CsvReader.this.fetch();
            if (t != null) {
                action.accept(t);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 272;
        }
    }
}

