/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import net.minecraftforge.forgedev.shadow.de.siegmar.fastcsv.reader.CommentStrategy;

public final class CsvIndex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int bomHeaderLength;
    private final long fileSize;
    private final byte fieldSeparator;
    private final byte quoteCharacter;
    private final CommentStrategy commentStrategy;
    private final byte commentCharacter;
    private final long recordCounter;
    private final List<CsvPage> pages;

    CsvIndex(int bomHeaderLength, long fileSize, byte fieldSeparator, byte quoteCharacter, CommentStrategy commentStrategy, byte commentCharacter, long recordCounter, List<CsvPage> pages) {
        this.bomHeaderLength = bomHeaderLength;
        this.fileSize = fileSize;
        this.fieldSeparator = fieldSeparator;
        this.quoteCharacter = quoteCharacter;
        this.commentStrategy = Objects.requireNonNull(commentStrategy);
        this.commentCharacter = commentCharacter;
        this.recordCounter = recordCounter;
        this.pages = Objects.requireNonNull(pages);
    }

    int getBomHeaderLength() {
        return this.bomHeaderLength;
    }

    long getFileSize() {
        return this.fileSize;
    }

    byte getFieldSeparator() {
        return this.fieldSeparator;
    }

    byte getQuoteCharacter() {
        return this.quoteCharacter;
    }

    CommentStrategy getCommentStrategy() {
        return this.commentStrategy;
    }

    byte getCommentCharacter() {
        return this.commentCharacter;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public long getRecordCount() {
        return this.recordCounter;
    }

    CsvPage getPage(int pageNumber) {
        return this.pages.get(pageNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvIndex csvIndex = (CsvIndex)o;
        return this.bomHeaderLength == csvIndex.bomHeaderLength && this.fileSize == csvIndex.fileSize && this.fieldSeparator == csvIndex.fieldSeparator && this.quoteCharacter == csvIndex.quoteCharacter && this.commentStrategy == csvIndex.commentStrategy && this.commentCharacter == csvIndex.commentCharacter && this.recordCounter == csvIndex.recordCounter && Objects.equals(this.pages, csvIndex.pages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bomHeaderLength, this.fileSize, this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.pages, this.recordCounter});
    }

    public String toString() {
        return new StringJoiner(", ", CsvIndex.class.getSimpleName() + "[", "]").add("bomHeaderLength=" + this.bomHeaderLength).add("fileSize=" + this.fileSize).add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentStrategy=" + String.valueOf((Object)this.commentStrategy)).add("commentCharacter=" + this.commentCharacter).add("recordCount=" + this.recordCounter).add("pageCount=" + this.pages.size()).toString();
    }

    static final class CsvPage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long offset;
        private final long startingLineNumber;

        CsvPage(long offset, long startingLineNumber) {
            this.offset = offset;
            this.startingLineNumber = startingLineNumber;
        }

        long getOffset() {
            return this.offset;
        }

        long getStartingLineNumber() {
            return this.startingLineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CsvPage csvPage = (CsvPage)o;
            return this.offset == csvPage.offset && this.startingLineNumber == csvPage.startingLineNumber;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.startingLineNumber);
        }
    }
}

