/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy.tasks.checks;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.checks.CheckMode;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.VerificationTask;

public abstract class CheckTask
extends DefaultTask
implements VerificationTask {
    private final Property<Boolean> ignoreFailures = this.getObjects().property(Boolean.class).convention((Object)false);

    @Input
    public abstract Property<CheckMode> getMode();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public CheckTask() {
    }

    public boolean getIgnoreFailures() {
        return (Boolean)this.ignoreFailures.getOrElse((Object)false);
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    @TaskAction
    protected void run() {
        String name = this.getName();
        Logger logger = this.getLogger();
        boolean doFix = this.getMode().get() == CheckMode.FIX;
        Reporter reporter = (Reporter)this.getObjects().newInstance(Reporter.class, new Object[]{doFix});
        this.check(reporter, doFix);
        if (!reporter.messages.isEmpty()) {
            if (!doFix) {
                logger.error("Check task '{}' found errors:\n{}", (Object)name, (Object)String.join((CharSequence)"\n", reporter.messages));
                if (!this.getIgnoreFailures()) {
                    throw new IllegalArgumentException(reporter.messages.size() + " errors were found");
                }
            } else {
                if (logger.isEnabled(LogLevel.DEBUG)) {
                    logger.warn("Check task '{}' found {} errors and fixed {}:\n{}", new Object[]{name, reporter.messages.size(), reporter.fixed.size(), String.join((CharSequence)"\n", reporter.fixed)});
                } else {
                    logger.warn("Check task '{}' found {} errors and fixed {}.", new Object[]{name, reporter.messages.size(), reporter.fixed.size()});
                }
                if (!reporter.notFixed.isEmpty()) {
                    logger.error("{} errors could not be fixed:\n{}", (Object)reporter.notFixed.size(), (Object)String.join((CharSequence)"\n", reporter.notFixed));
                    if (!this.getIgnoreFailures()) {
                        throw new IllegalArgumentException(reporter.notFixed.size() + " errors which cannot be fixed were found!");
                    }
                }
            }
        }
    }

    abstract void check(Reporter var1, boolean var2);

    public static <T extends CheckTask> TaskProvider<T> register(TaskContainer tasks, String taskName, Class<T> clazz, @DelegatesTo(strategy=1) @ClosureParams(value=FromString.class, options={"T"}) Closure<?> configuration) {
        taskName = StringGroovyMethods.capitalize((CharSequence)taskName);
        TaskProvider check = tasks.register("check" + taskName, clazz, task -> {
            Closures.invoke(configuration, task);
            task.getMode().set((Object)CheckMode.CHECK);
            task.setGroup("verification");
        });
        tasks.named("check", task -> task.dependsOn(new Object[]{check}));
        TaskProvider checkAndFix = tasks.register("checkAndFix" + taskName, clazz, task -> {
            Closures.invoke(configuration, task);
            task.getMode().set((Object)CheckMode.FIX);
            task.setGroup("verification");
        });
        tasks.named("checkAndFix", task -> task.dependsOn(new Object[]{checkAndFix}));
        return check;
    }

    static abstract class Reporter {
        final boolean trackFixed;
        public final List<String> messages = new ArrayList<String>();
        public final List<String> fixed = new ArrayList<String>();
        public final List<String> notFixed = new ArrayList<String>();

        @Inject
        public Reporter(boolean trackFixed) {
            this.trackFixed = trackFixed;
        }

        public boolean isTrackFixed() {
            return this.trackFixed;
        }

        public void report(String message) {
            this.report(message, true);
        }

        public void report(String message, boolean canBeFixed) {
            this.messages.add(message);
            if (this.trackFixed) {
                if (canBeFixed) {
                    this.fixed.add(message);
                } else {
                    this.notFixed.add(message);
                }
            }
        }
    }
}

