/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.legacy;

import java.util.List;
import java.util.SortedSet;
import javax.inject.Inject;
import net.minecraftforge.forgedev.legacy.tasks.Util;
import net.minecraftforge.forgedev.legacy.tasks.WriteManifest;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.external.javadoc.JavadocMemberLevel;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

abstract class SharedBuildPlugin
implements Plugin<Project> {
    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    public SharedBuildPlugin() {
    }

    public void apply(Project project) {
        project.setGroup((Object)"net.minecraftforge");
        ProjectLayout layout = this.getLayout();
        TaskContainer tasks = project.getTasks();
        TaskProvider generateResources = SharedUtil.runFirst(project, tasks.register("generateResources"));
        TaskProvider processResources = tasks.named("processResources", ProcessResources.class, task -> task.dependsOn(new Object[]{generateResources}));
        project.getPluginManager().withPlugin("java", javaAppliedPlugin -> {
            tasks.withType(Javadoc.class).configureEach(task -> task.options(minimalOptions -> {
                if (minimalOptions instanceof CoreJavadocOptions) {
                    CoreJavadocOptions coreOptions = (CoreJavadocOptions)minimalOptions;
                    coreOptions.setMemberLevel(JavadocMemberLevel.PUBLIC);
                    coreOptions.addBooleanOption("Xdoclint:all", true);
                    coreOptions.addBooleanOption("-Xdoclint:missing", true);
                }
            }));
            tasks.withType(JavaCompile.class).configureEach(task -> {
                CompileOptions options = task.getOptions();
                options.setWarnings(false);
                options.getForkOptions().setMemoryMaximumSize("6G");
            });
        });
        project.getPluginManager().withPlugin("eclipse", eclipseAppliedPlugin -> {
            EclipseModel eclipse = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            eclipse.synchronizationTasks(new Object[]{tasks.named("eclipseClasspath", GenerateEclipseClasspath.class), tasks.named("eclipseProject", GenerateEclipseProject.class)});
        });
        project.afterEvaluate(this::finish);
    }

    private void finish(Project project) {
        TaskContainer tasks = project.getTasks();
        String jar = project.getPluginManager().hasPlugin("net.minecraftforge.forgedev") ? "universalJar" : "jar";
        WriteManifest.register(project, (TaskProvider<? extends org.gradle.jvm.tasks.Jar>)tasks.named(jar, Jar.class));
        for (SourceSet sourceSet : ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets()) {
            SortedSet existing = tasks.getNames();
            if (!existing.contains(sourceSet.getSourcesJarTaskName()) || !existing.contains(sourceSet.getProcessResourcesTaskName())) continue;
            TaskProvider processResources = tasks.named(sourceSet.getProcessResourcesTaskName());
            List<String> names = List.of(sourceSet.getCompileJavaTaskName(), sourceSet.getCompileTaskName("groovy"), sourceSet.getSourcesJarTaskName());
            for (String name : names) {
                if (!existing.contains(name)) continue;
                tasks.named(name, task -> task.dependsOn(new Object[]{processResources}));
            }
        }
    }

    static {
        Util.init();
    }
}

