/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */
package net.minecraftforge.forgedev.legacy.tasks


import org.gradle.api.DefaultTask
import org.gradle.api.file.ConfigurableFileCollection
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction
import org.gradle.api.tasks.bundling.AbstractArchiveTask

import java.util.zip.ZipFile

abstract class BundleList extends DefaultTask {
    @InputFiles abstract ConfigurableFileCollection getConfig()
    @InputFiles abstract ConfigurableFileCollection getConfigExtra()
    @InputFile abstract RegularFileProperty getServerBundle()
    @OutputFile abstract RegularFileProperty getOutput()

    BundleList() {


        config.setFrom(project.configurations.installer)
        configExtra.setFrom(project.configurations.installerextra)
        output.convention(project.layout.buildDirectory.file("$name/output.list"))
        configure {
            dependsOn(
                project.tasks.universalJar,
                project.tasks.applyServerBinPatches
            )
            inputs.files(
                project.tasks.universalJar.archiveFile,
                project.tasks.applyServerBinPatches.output
            )
        }
    }
    
    @TaskAction
    void run() {
        def entries = [:] as TreeMap
        def resolved = project.configurations.installer.resolvedConfiguration.resolvedArtifacts
        for (def dep : resolved) {
            def info = Util.getMavenInfoFromDep(dep)
            //println("$dep.file.sha1\t$info.name\t$info.path")
            entries.put("$info.art.group:$info.art.name", "${dep.file.sha256}\t$info.name\t$info.path")
        }

        resolved = project.configurations.installerextra.resolvedConfiguration.resolvedArtifacts
        for (def dep : resolved) {
            def info = Util.getMavenInfoFromDep(dep)
            //println("$dep.file.sha1\t$info.name\t$info.path")
            entries.put("$info.art.group:$info.art.name", "$dep.file.sha256\t$info.name\t$info.path")
        }

        var packed = (AbstractArchiveTask) project.tasks.universalJar
        var info = Util.getMavenInfoFromTask(packed)
        def file = packed.archiveFile.get().asFile
        entries.put("$info.art.group:$info.art.name:$info.art.classifier", "$file.sha256\t$info.name\t$info.path")

        var classifier = 'server'
        var genned = project.tasks.applyServerBinPatches
        info = Util.getMavenInfoFromTask(genned, classifier)
        file = genned.output.get().asFile
        entries.put("$info.art.group:$info.art.name:$info.art.classifier", "$file.sha256\t$info.name\t$info.path")
        
        try (def zip = new ZipFile(serverBundle.get().asFile)) {
            def entry = zip.getEntry('META-INF/libraries.list')
            def data = zip.getInputStream(entry).text.split('\n')
            for (def line : data) {
                def (sha, artifact, path) = line.split('\t')
                def (group, name, other) = artifact.split(':', 3)
                //println("Group: $group Name: $name")
                def key = "$group:$name"
                if (!entries.containsKey(key))
                    entries.put(key, line)
            }
        }
        
        output.get().asFile.text = entries.values().join('\n')
    }
}
