/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.Closures;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptions;
import net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptionsImpl;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public abstract class LegacyMinecraftExtension {
    protected final ConfigurableFileCollection accessTransformers = this.getObjects().fileCollection();
    private final Property<String> mapping = this.getObjects().property(String.class);
    final NamedDomainObjectContainer<SlimeLauncherOptionsImpl> runs = this.getObjects().domainObjectContainer(SlimeLauncherOptionsImpl.class);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract Project getProject();

    @Inject
    public LegacyMinecraftExtension() {
        this.mapping.set(this.getMappingChannel().zip(this.getMappingVersion(), (ch, ver) -> ch + "_" + ver));
    }

    public abstract Property<String> getMappingChannel();

    public abstract Property<String> getMappingVersion();

    public Provider<String> getMappings() {
        return this.mapping;
    }

    public void mappings(Provider<String> channel, Provider<String> version) {
        this.getMappingChannel().set(channel);
        this.getMappingVersion().set(version);
    }

    public void mappings(String channel, String version) {
        this.getMappingChannel().set((Object)channel);
        this.getMappingVersion().set((Object)version);
    }

    public void mappings(Map<String, ? extends CharSequence> mappings) {
        CharSequence channel = mappings.get("channel");
        CharSequence version = mappings.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify both mappings channel and version");
        }
        this.mappings(channel.toString(), version.toString());
    }

    public NamedDomainObjectContainer<? extends SlimeLauncherOptions> getRuns() {
        return this.runs;
    }

    public void runs(@DelegatesTo(value=NamedDomainObjectContainer.class) @ClosureParams(value=FromString.class, options={"org.gradle.api.NamedDomainObjectContainer<net.minecraftforge.forgedev.tasks.launcher.SlimeLauncherOptions>"}) Closure<?> closure) {
        this.runs.configure(closure);
    }

    public void runs(Action<? super NamedDomainObjectContainer<? extends SlimeLauncherOptions>> action) {
        this.runs(Closures.action(this, action));
    }

    public ConfigurableFileCollection getAccessTransformers() {
        return this.accessTransformers;
    }

    public void setAccessTransformers(Object ... files) {
        this.getAccessTransformers().setFrom(files);
    }

    public void setAccessTransformer(Object files) {
        this.getAccessTransformers().setFrom(new Object[]{files});
    }

    public void accessTransformers(Object ... files) {
        this.getAccessTransformers().from(files);
    }

    public void accessTransformer(Object file) {
        this.getAccessTransformers().from(new Object[]{file});
    }

    public abstract ConfigurableFileCollection getSideAnnotationStrippers();

    public abstract Property<Boolean> getEnableEclipsePrepareRuns();

    public abstract Property<Boolean> getEnableIdeaPrepareRuns();

    public abstract Property<Boolean> getCopyIdeResources();

    public abstract Property<Boolean> getGenerateRunFolders();
}

