/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.tasks.generation;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.forgedev.ForgeDevTask;
import net.minecraftforge.forgedev.Util;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.Closures;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json.PatcherConfig;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json.RunConfig;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GeneratePatcherConfigV2
extends DefaultTask
implements ForgeDevTask {
    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Input
    @Optional
    public abstract Property<PatcherConfig.V2.DataFunction> getProcessor();

    @Input
    @Optional
    public abstract MapProperty<String, File> getProcessorData();

    @Input
    @Optional
    public abstract Property<String> getPatchesOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getPatchesModifiedPrefix();

    @Input
    @Optional
    public abstract Property<Boolean> getNotchObf();

    @Input
    @Optional
    public abstract Property<String> getSourceFileEncoding();

    @Input
    @Optional
    public abstract ListProperty<String> getUniversalFilters();

    @Input
    public abstract Property<String> getMCPConfig();

    @Input
    public abstract ListProperty<String> getLibraries();

    @Input
    public abstract ListProperty<String> getModules();

    @Input
    public abstract Property<String> getUniversal();

    @Input
    public abstract Property<String> getSource();

    @Input
    @Optional
    public abstract Property<String> getInject();

    @Input
    @Optional
    public abstract Property<String> getPatches();

    @InputFiles
    public abstract ConfigurableFileCollection getATs();

    @InputFiles
    public abstract ConfigurableFileCollection getSASs();

    @InputFiles
    public abstract ConfigurableFileCollection getSRGs();

    @Input
    @Optional
    public abstract ListProperty<String> getSRGLines();

    @Input
    protected abstract MapProperty<String, RunConfig> getRuns();

    @Input
    public abstract Property<String> getBinpatcherVersion();

    @Input
    public abstract ListProperty<String> getBinpatcherArguments();

    @Input
    @Optional
    public abstract ListProperty<String> getExtraRuntimeDeps();

    @Input
    @Optional
    public abstract ListProperty<String> getExtraCompileDeps();

    @Input
    @Optional
    public abstract ListProperty<String> getExtraAnnotationProcessorDeps();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public GeneratePatcherConfigV2() {
        this.getOutput().convention(this.getDefaultOutputFile("json"));
        this.getPatchesOriginalPrefix().convention((Object)"a/");
        this.getPatchesModifiedPrefix().convention((Object)"b/");
        this.getSourceFileEncoding().convention((Object)StandardCharsets.UTF_8.name());
        this.getInject().convention((Object)"inject/");
        this.getPatches().convention((Object)"patches/");
    }

    @TaskAction
    protected void exec() throws IOException {
        PatcherConfig config = new PatcherConfig();
        config.spec = 1;
        config.binpatches = "joined.lzma";
        config.sources = (String)this.getSource().filter(Util.IS_NOT_BLANK).getOrNull();
        config.universal = (String)this.getUniversal().filter(Util.IS_NOT_BLANK).getOrNull();
        config.patches = (String)this.getPatches().filter(Util.IS_NOT_BLANK).getOrNull();
        config.inject = (String)this.getInject().filter(Util.IS_NOT_BLANK).getOrNull();
        config.libraries = (List)this.getLibraries().get();
        config.ats = DefaultGroovyMethods.collect((Iterable)this.getATs(), Closures.function(f -> "ats/" + f.getName()));
        if (config.ats.isEmpty()) {
            config.ats = null;
        }
        config.sass = DefaultGroovyMethods.collect((Iterable)this.getSASs(), Closures.function(f -> "sas/" + f.getName()));
        if (config.sass.isEmpty()) {
            config.sass = null;
        }
        config.srgs = DefaultGroovyMethods.collect((Iterable)this.getSRGs(), Closures.function(f -> "srgs/" + f.getName()));
        config.srgs.addAll((Collection)this.getSRGLines().get());
        if (config.srgs.isEmpty()) {
            config.srgs = null;
        }
        config.mcp = (String)this.getMCPConfig().filter(Util.IS_NOT_BLANK).get();
        config.runs = (Map)this.getRuns().get();
        config.binpatcher = new PatcherConfig.Function();
        config.binpatcher.version = (String)this.getBinpatcherVersion().filter(Util.IS_NOT_BLANK).getOrNull();
        config.binpatcher.args = (List)this.getBinpatcherArguments().getOrNull();
        if (this.isV2()) {
            config = new PatcherConfig.V2(config);
            PatcherConfig.V2 v2 = config;
            v2.spec = 2;
            v2.modules = (List)this.getModules().get();
            if (v2.modules.isEmpty()) {
                v2.modules = null;
            }
            v2.processor = (PatcherConfig.V2.DataFunction)this.getProcessor().getOrNull();
            v2.patchesOriginalPrefix = (String)this.getPatchesOriginalPrefix().filter(Util.IS_NOT_BLANK).getOrNull();
            v2.patchesModifiedPrefix = (String)this.getPatchesModifiedPrefix().filter(Util.IS_NOT_BLANK).getOrNull();
            v2.notchObf = (Boolean)this.getNotchObf().filter(b -> b).getOrNull();
            v2.sourceFileCharset = (String)this.getSourceFileEncoding().filter(Util.IS_NOT_BLANK).getOrNull();
            v2.universalFilters = (List)this.getUniversalFilters().get();
            if (v2.universalFilters.isEmpty()) {
                v2.universalFilters = null;
            }
            v2.extraDependencies = new PatcherConfig.V2.ScopedDependencies();
            v2.extraDependencies.compileOnly = new ArrayList<String>((Collection)this.getExtraCompileDeps().get());
            v2.extraDependencies.runtimeOnly = new ArrayList<String>((Collection)this.getExtraRuntimeDeps().get());
            v2.extraDependencies.annotationProcessor = new ArrayList<String>((Collection)this.getExtraAnnotationProcessorDeps().get());
        }
        JsonData.toJson(config, (File)this.getOutput().getAsFile().get());
    }

    private boolean isV2() {
        return (Boolean)this.getNotchObf().getOrElse((Object)false) != false || this.getProcessor().isPresent() || this.getUniversalFilters().isPresent() || !"a/".equals(this.getPatchesOriginalPrefix().get()) || !"b/".equals(this.getPatchesModifiedPrefix().get());
    }

    public void runs(Action<? super NamedDomainObjectContainer<? extends RunConfig>> action) {
        NamedDomainObjectContainer container = this.getObjects().domainObjectContainer(BeanRunConfig.class);
        action.execute((Object)container);
        this.getRuns().set((Map)container.getAsMap());
    }

    static abstract class BeanRunConfig
    extends RunConfig
    implements Named,
    Serializable {
        private static final long serialVersionUID = -7975487107404098482L;

        @Inject
        public BeanRunConfig(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void environment(String key, String value) {
            HashMap<String, String> map = this.env == null ? (this.env = new HashMap<String, String>()) : this.env;
            map.put(key, value);
        }

        public void property(String key, String value) {
            HashMap<String, String> map = this.props == null ? (this.props = new HashMap<String, String>()) : this.props;
            map.put(key, value);
        }

        public void args(String ... args) {
            ArrayList<String> list = this.args == null ? (this.args = new ArrayList<String>()) : this.args;
            list.addAll(Arrays.asList(args));
        }

        public void jvmArgs(String ... jvmArgs) {
            ArrayList<String> list = this.jvmArgs == null ? (this.jvmArgs = new ArrayList<String>()) : this.jvmArgs;
            list.addAll(Arrays.asList(jvmArgs));
        }
    }
}

