/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */
package net.minecraftforge.forgedev.tasks.compat

import groovy.transform.CompileStatic
import net.minecraftforge.forgedev.ForgeDevTask
import org.gradle.api.DefaultTask
import org.gradle.api.file.ArchiveOperations
import org.gradle.api.file.DirectoryProperty
import org.gradle.api.file.FileSystemOperations
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.TaskAction

import javax.inject.Inject

// TODO [ForgeDev] Consider using extraction as a tool in other tasks instead of this dedicated task
@CompileStatic
abstract class LegacyExtractZip extends DefaultTask implements ForgeDevTask {
    abstract @InputFile RegularFileProperty getInput()
    abstract @OutputDirectory DirectoryProperty getOutput()

    @Inject
    LegacyExtractZip() { }

    protected abstract @Inject FileSystemOperations getFileSystemOperations()
    protected abstract @Inject ArchiveOperations getArchiveOperations()

    @TaskAction
    void exec() {
        this.fileSystemOperations.copy(copy -> copy
            .from(this.archiveOperations.zipTree(this.input))
            .into(this.output)
        )
    }
}
