/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS;
import org.jetbrains.annotations.Nullable;

public class MinecraftVersion {
    public String id;
    public JavaVersion javaVersion;
    public Map<String, Download> downloads;
    public Library[] libraries;
    public AssetsIndexInfo assetIndex;

    public List<Lib> getLibs() {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        for (Library lib : this.libraries) {
            EnumSet<OS> os = EnumSet.noneOf(OS.class);
            if (lib.rules != null) {
                for (Rule rule : lib.rules) {
                    switch (rule.action) {
                        case "allow": {
                            if (rule.os == null) {
                                os.addAll(Arrays.asList(OS.WINDOWS, OS.MACOS, OS.LINUX));
                                break;
                            }
                            os.add(rule.os.toOS());
                            break;
                        }
                        case "disallow": {
                            if (os.isEmpty()) {
                                os.addAll(Arrays.asList(OS.WINDOWS, OS.MACOS, OS.LINUX));
                            }
                            os.remove((Object)rule.os.toOS());
                        }
                    }
                }
            }
            libs.add(new Lib(lib.name, lib.downloads.artifact, os));
            if (lib.natives == null || lib.downloads.classifiers == null) continue;
            lib.natives.forEach((nativeOS, classifier) -> {
                LibraryDownload nativeLib = lib.downloads.classifiers.get(nativeOS);
                if (nativeLib != null) {
                    libs.add(new Lib(lib.name + ':' + classifier, nativeLib, EnumSet.of(Rule.OS.toOS(nativeOS))));
                }
            });
        }
        return libs;
    }

    @Nullable
    public Download getDownload(String key) {
        return this.downloads == null ? null : this.downloads.get(key);
    }

    public static class AssetsIndexInfo {
        public String id;
        public String sha1;
        public int size;
        public int totalSize;
        public String url;
    }

    public static class Rule {
        public String action;
        @Nullable
        public OS os;

        public static class OS {
            public String name;

            public static net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS toOS(String name) {
                switch (name) {
                    case "windows": {
                        return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS.WINDOWS;
                    }
                    case "linux": {
                        return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS.LINUX;
                    }
                    case "osx": {
                        return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS.MACOS;
                    }
                }
                return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS.UNKNOWN;
            }

            public net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os.OS toOS() {
                return OS.toOS(this.name);
            }
        }
    }

    public static class LibraryDownload
    extends Download {
        public String path;
    }

    public static class Download {
        public String sha1;
        public URL url;
        public int size;
    }

    public static class Downloads {
        public Map<String, LibraryDownload> classifiers;
        public LibraryDownload artifact;
    }

    public static class Library {
        public String name;
        public Downloads downloads;
        public Map<String, String> natives;
        public List<Rule> rules;
    }

    public static final class Lib {
        public final String coord;
        public final LibraryDownload dl;
        public final EnumSet<OS> os;

        public Lib(String coord, LibraryDownload dl, EnumSet<OS> os) {
            this.coord = coord;
            this.dl = dl;
            this.os = os;
        }

        public boolean allows(OS os) {
            return this.os.isEmpty() || this.os.contains((Object)os);
        }
    }

    public static final class JavaVersion {
        public String component;
        public int majorVersion;
    }
}

