/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os;

import java.io.File;
import java.util.Locale;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OS {
    LINUX("linux", "unix"),
    MUSL(LINUX, "linux_musl", "musl"),
    AIX(LINUX, "aix"),
    ALPINE(MUSL, "apline_linux", "alpine"),
    MACOS(LINUX, "macos", "mac", "osx", "os x", "darwin"),
    QNX(LINUX, "qnx"),
    SOLARIS(LINUX, "solaris", "sunos"),
    WINDOWS("windows", "win"),
    UNKNOWN("unknown");

    private static final OS[] $values;
    @Nullable
    private final OS fallback;
    private final String key;
    private final String[] names;
    private final String exe;

    private OS(String ... names) {
        this((OS)null, names);
    }

    private OS(OS fallback, String ... names) {
        this.fallback = fallback;
        this.key = names[0];
        this.names = names;
        this.exe = "windows".equals(this.key) ? ".exe" : "";
    }

    @NotNull
    public OS fallback() {
        return this.fallback == null ? UNKNOWN : this.fallback;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    @NotNull
    public String exe() {
        return this.exe;
    }

    @NotNull
    public static OS current() {
        return CurrentOS.CURRENT;
    }

    @NotNull
    public static OS current(OS ... allowed) {
        return OS.current(OS.current(), allowed);
    }

    @NotNull
    private static OS current(OS current, OS ... allowed) {
        if (current == UNKNOWN) {
            return UNKNOWN;
        }
        for (OS os : allowed) {
            if (os != current) continue;
            return current;
        }
        return OS.current(current.fallback(), allowed);
    }

    @NotNull
    public static OS byKey(@Nullable String key) {
        for (OS value : $values) {
            if (!value.key.equals(key)) continue;
            return value;
        }
        return UNKNOWN;
    }

    @NotNull
    public static OS byName(@Nullable String name) {
        for (OS value : $values) {
            for (String n : value.names) {
                if (!n.equals(name)) continue;
                return value;
            }
        }
        return UNKNOWN;
    }

    private static OS getCurrentLinux() {
        try (Scanner scanner = null;){
            scanner = new Scanner(new File("/etc/os-release"), "UTF-8");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().toLowerCase(Locale.ENGLISH);
                if (!line.startsWith("name=") || !line.contains("alpine")) continue;
                OS oS = ALPINE;
                return oS;
            }
        }
        return LINUX;
    }

    static {
        $values = OS.values();
    }

    private static final class CurrentOS {
        private static final OS CURRENT;

        private CurrentOS() {
        }

        static {
            OS current = UNKNOWN;
            String prop = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            block0: for (OS os : $values) {
                for (String key : os.names) {
                    if (!prop.contains(key)) continue;
                    current = os == LINUX ? OS.getCurrentLinux() : os;
                    continue block0;
                }
            }
            CURRENT = current;
        }
    }
}

