/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.util.os;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Arch {
    X86("x86", "i386", "i686"),
    X86_64("x86_64", "x64", "amd64"),
    ARM("arm", "aarch32", "aarch_32"),
    ARM64("arm64", "aarch64", "aarch_64"),
    UNKNOWN("unknown");

    private static final Arch[] $values;
    private final String key;
    private final String[] names;

    private Arch(String ... names) {
        this.key = names[0];
        this.names = names;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    @NotNull
    public static Arch current() {
        return CurrentArch.CURRENT;
    }

    @NotNull
    public static Arch byKey(@Nullable String key) {
        for (Arch value : $values) {
            if (!value.key.equalsIgnoreCase(key)) continue;
            return value;
        }
        return UNKNOWN;
    }

    @NotNull
    public static Arch byName(@Nullable String name) {
        for (Arch value : $values) {
            for (String n : value.names) {
                if (!n.equalsIgnoreCase(name)) continue;
                return value;
            }
        }
        return UNKNOWN;
    }

    static {
        $values = Arch.values();
    }

    private static final class CurrentArch {
        private static final Arch CURRENT;

        private CurrentArch() {
        }

        static {
            Arch current = UNKNOWN;
            String prop = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            block0: for (Arch os : $values) {
                for (String key : os.names) {
                    if (!prop.contains(key)) continue;
                    current = os;
                    continue block0;
                }
            }
            CURRENT = current;
        }
    }
}

