/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.EnhancedPluginAdditions;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.Lazy;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.ToolInternal;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.ToolsExtensionImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.BuildLayout;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class EnhancedPlugin<T>
implements Plugin<T>,
EnhancedPluginAdditions {
    private final String name;
    private final String displayName;
    @Nullable
    private final String toolsExtName;
    private @UnknownNullability T target;
    private ToolsExtensionImpl tools = (ToolsExtensionImpl)this.getObjects().newInstance(ToolsExtensionImpl.class, new Object[]{this::toolchainsForTools});
    private final EnhancedProblems problemsInternal;
    private final Lazy<DirectoryProperty> globalCaches = Lazy.simple(this::makeGlobalCaches);
    private final Lazy<DirectoryProperty> localCaches = Lazy.simple(this::makeLocalCaches);
    private final Lazy<DirectoryProperty> rootProjectDirectory = Lazy.simple(this::makeRootProjectDirectory);
    private final Lazy<DirectoryProperty> workingProjectDirectory = Lazy.simple(this::makeWorkingProjectDirectory);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract BuildLayout getBuildLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract JavaToolchainService getJavaToolchains();

    protected EnhancedPlugin(String name, String displayName) {
        this(name, displayName, null);
    }

    protected EnhancedPlugin(String name, String displayName, @Nullable String toolsExtName) {
        this.name = name;
        this.displayName = displayName;
        this.toolsExtName = toolsExtName;
        this.problemsInternal = (EnhancedProblems)this.getObjects().newInstance(EnhancedProblems.Minimal.class, new Object[]{name, displayName});
    }

    public final void apply(T target) {
        this.target = target;
        this.setup(this.target);
        if (this.toolsExtName != null && target instanceof ExtensionAware) {
            ExtensionAware extensionAware = (ExtensionAware)target;
            this.tools = (ToolsExtensionImpl)extensionAware.getExtensions().create(this.toolsExtName, ToolsExtensionImpl.class, new Object[]{this::toolchainsForTools});
        }
    }

    public abstract void setup(T var1);

    private T getTarget() {
        try {
            return Objects.requireNonNull(this.target);
        }
        catch (Exception e) {
            throw this.problemsInternal.pluginNotYetApplied(e);
        }
    }

    final EnhancedProblems getProblemsInternal() {
        return this.problemsInternal;
    }

    @Override
    public Tool.Resolved getTool(Tool tool) {
        ProviderFactory providers;
        try {
            providers = this.target instanceof Project ? this.getProviders() : ((Gradle)InvokerHelper.getProperty(this.target, (String)"gradle")).getRootProject().getProviders();
        }
        catch (Throwable ignored) {
            providers = this.getProviders();
        }
        return ((ToolInternal)tool).get((Provider<? extends Directory>)this.globalCaches(), providers, this.tools);
    }

    JavaToolchainService toolchainsForTools() {
        return this.target instanceof Project ? this.getJavaToolchains() : (JavaToolchainService)((Gradle)InvokerHelper.getProperty(this.target, (String)"gradle")).getRootProject().getExtensions().getByType(JavaToolchainService.class);
    }

    @Override
    public final DirectoryProperty globalCaches() {
        return this.globalCaches.get();
    }

    private DirectoryProperty makeGlobalCaches() {
        try {
            Gradle gradle = (Gradle)InvokerHelper.getProperty(this.target, (String)"gradle");
            DirectoryProperty gradleUserHomeDir = this.getObjects().directoryProperty().fileValue(gradle.getGradleUserHomeDir());
            return this.getObjects().directoryProperty().convention(gradleUserHomeDir.dir("caches/minecraftforge/" + this.name).map(this.problemsInternal.ensureFileLocation()));
        }
        catch (Exception e) {
            throw this.problemsInternal.illegalPluginTarget(new IllegalArgumentException(String.format("Failed to get %s global caches directory for target: %s", this.displayName, this.target), e), "types with access to Gradle via `#getGradle()`");
        }
    }

    @Override
    public final DirectoryProperty localCaches() {
        return this.localCaches.get();
    }

    private DirectoryProperty makeLocalCaches() {
        try {
            DirectoryProperty workingProjectBuildDir;
            if (this.target instanceof Project) {
                workingProjectBuildDir = this.getProjectLayout().getBuildDirectory();
            } else if (this.target instanceof Settings) {
                workingProjectBuildDir = this.getObjects().directoryProperty().fileValue(new File(this.getBuildLayout().getRootDirectory().getAsFile(), "build"));
            } else {
                throw new IllegalStateException("Cannot make local caches with an unsupported type (must be project or settings)");
            }
            return this.getObjects().directoryProperty().convention(workingProjectBuildDir.dir("minecraftforge/" + this.name).map(this.problemsInternal.ensureFileLocation()));
        }
        catch (Exception e) {
            throw this.problemsInternal.illegalPluginTarget(new IllegalArgumentException(String.format("Failed to get %s local caches directory for target: %s", this.displayName, this.getTarget()), e), Project.class, Settings.class);
        }
    }

    @Override
    public final DirectoryProperty rootProjectDirectory() {
        return this.rootProjectDirectory.get();
    }

    private DirectoryProperty makeRootProjectDirectory() {
        T target = this.getTarget();
        try {
            DirectoryProperty rootProjectDirectory = this.getObjects().directoryProperty();
            if (target instanceof Project) {
                Project project = (Project)target;
                return rootProjectDirectory.value(project.getRootProject().getLayout().getProjectDirectory());
            }
            if (target instanceof Settings) {
                return rootProjectDirectory.value(this.getBuildLayout().getRootDirectory());
            }
            throw new IllegalStateException("Cannot get root project directory with an unsupported type (must be project or settings)");
        }
        catch (Exception e) {
            throw this.problemsInternal.illegalPluginTarget(new IllegalArgumentException("Failed to get %s root project directory for target: %s".formatted(this.displayName, target), e), Project.class, Settings.class);
        }
    }

    @Override
    public final DirectoryProperty workingProjectDirectory() {
        return this.workingProjectDirectory.get();
    }

    private DirectoryProperty makeWorkingProjectDirectory() {
        T target = this.getTarget();
        try {
            DirectoryProperty workingProjectDirectory = this.getObjects().directoryProperty();
            if (target instanceof Project) {
                return workingProjectDirectory.value(this.getProjectLayout().getProjectDirectory());
            }
            if (target instanceof Settings) {
                return workingProjectDirectory.value(this.getBuildLayout().getRootDirectory());
            }
            throw new IllegalStateException("Cannot get working project directory with an unsupported type (must be project or settings)");
        }
        catch (Exception e) {
            throw this.problemsInternal.illegalPluginTarget(new IllegalArgumentException("Failed to get %s working project directory for target: %s".formatted(this.displayName, target), e), Project.class, Settings.class);
        }
    }
}

