/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.OS;
import org.jetbrains.annotations.Nullable;

public class MinecraftVersion {
    public String id;
    public Map<String, Download> downloads;
    public Library[] libraries;
    public AssetsIndexInfo assetIndex;

    public List<Lib> getLibs() {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        for (Library lib : this.libraries) {
            if (lib.rules != null && lib.rules.size() != 1) {
                throw new UnsupportedOperationException("Rules were found, but wasn't precisely one??? Rules: " + lib.rules);
            }
            OS os = lib.rules == null ? null : lib.rules.get((int)0).os.toOS();
            libs.add(new Lib(lib.name, lib.downloads.artifact, os));
            if (lib.downloads.classifiers == null) continue;
            lib.downloads.classifiers.forEach((k, v) -> libs.add(new Lib(lib.name + ':' + k, (LibraryDownload)v, os)));
        }
        return libs;
    }

    @Nullable
    public Download getDownload(String key) {
        return this.downloads == null ? null : this.downloads.get(key);
    }

    public static class AssetsIndexInfo {
        public String id;
        public String sha1;
        public int size;
        public int totalSize;
        public String url;
    }

    public static class Rules {
        public String action;
        public OS os;

        public static class OS {
            public String name;

            public net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.OS toOS() {
                switch (this.name) {
                    case "windows": {
                        return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.OS.WINDOWS;
                    }
                    case "linux": {
                        return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.OS.LINUX;
                    }
                    case "osx": {
                        return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.OS.MACOS;
                    }
                }
                return net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.OS.UNKNOWN;
            }
        }
    }

    public static class LibraryDownload
    extends Download {
        public String path;
    }

    public static class Download {
        public String sha1;
        public URL url;
        public int size;
    }

    public static class Downloads {
        public Map<String, LibraryDownload> classifiers;
        public LibraryDownload artifact;
    }

    public static class Library {
        public String name;
        public Downloads downloads;
        public List<Rules> rules;
    }

    public static final class Lib {
        public final String coord;
        public final LibraryDownload dl;
        public final OS os;

        public Lib(String coord, LibraryDownload dl, OS os) {
            this.coord = coord;
            this.dl = dl;
            this.os = os;
        }
    }
}

