/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.util.data.json.Config;

public class MCPConfig
extends Config {
    public String version;
    public Map<String, Object> data;
    public Map<String, List<Map<String, String>>> steps;
    public Map<String, Function> functions;
    public Map<String, List<String>> libraries;

    public Map<String, String> getData(String side) {
        if (this.data == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        this.data.forEach((k, v) -> ret.put((String)k, (String)(v instanceof Map ? ((Map)v).get(side) : v)));
        return ret;
    }

    public List<String> getLibraries(String side) {
        if (this.libraries == null) {
            return Collections.emptyList();
        }
        return this.libraries.getOrDefault(side, Collections.emptyList());
    }

    public Function getFunction(String name) {
        return this.functions == null ? null : this.functions.get(name);
    }

    public List<Map<String, String>> getSteps(String side) {
        List<Map<String, String>> ret = this.steps == null ? null : this.steps.get(side);
        return ret == null ? Collections.emptyList() : ret;
    }

    public static class V2
    extends MCPConfig {
        public boolean official = false;
        public int java_target = 8;
        public String encoding = "UTF-8";

        public V2(MCPConfig o) {
            this.version = o.version;
            this.data = o.data;
            this.steps = o.steps;
            this.functions = o.functions;
            this.libraries = o.libraries;
        }
    }

    public static final class Function {
        public String version;
        public String repo;
        public List<String> args;
        public List<String> jvmargs;
        public Integer java_version;

        public int getJavaVersion(V2 parent) {
            return this.java_version == null ? parent.java_target : this.java_version;
        }
    }
}

