/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared;

import java.io.Serializable;
import java.util.concurrent.Callable;
import net.minecraftforge.forgedev.shadow.net.minecraftforge.gradleutils.shared.ToolImpl;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Tool
extends Named,
Serializable {
    public static Tool of(String name, String version, String downloadUrl, int javaVersion, String mainClass) {
        return new ToolImpl(name, version, downloadUrl, javaVersion, mainClass);
    }

    public static Tool of(String name, String version, String downloadUrl, int javaVersion) {
        return new ToolImpl(name, version, downloadUrl, javaVersion, null);
    }

    public String getName();

    public String getVersion();

    public int getJavaVersion();

    @Nullable
    public String getMainClass();

    default public boolean hasMainClass() {
        return this.getMainClass() != null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Resolved
    extends Tool,
    Callable<FileCollection> {
        @Override
        default public FileCollection call() {
            return this.getClasspath();
        }

        public FileCollection getClasspath();

        public Property<JavaLauncher> getJavaLauncher();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @ApiStatus.Experimental
    public static interface Definition
    extends Named {
        public ConfigurableFileCollection getClasspath();

        public Property<String> getMainClass();

        public Property<JavaLauncher> getJavaLauncher();
    }
}

