/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.PostProcessors;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class OfflineAction
extends Action {
    public static final String OFFLINE_FLAG = "_FORCE_OFFLINE_INSTALLER_";
    private final File base = OfflineAction.findInstallerBase();
    private final PostProcessors processorsClient;
    private final PostProcessors processorsServer;
    private int added = 0;

    protected OfflineAction(InstallV1 profile, ProgressCallback monitor) {
        super(profile, monitor, true);
        this.processorsClient = new PostProcessors(profile, true, monitor);
        this.processorsServer = new PostProcessors(profile, false, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run(File target, File installer) throws ActionCanceledException {
        File librariesDir = new File(target, "libraries");
        if (!target.exists()) {
            target.mkdirs();
        }
        librariesDir.mkdir();
        this.checkCancel();
        ArrayList<File> libDirs = new ArrayList<File>();
        File mcLibDir = new File(SimpleInstaller.getMCDir(), "libraries");
        if (mcLibDir.exists()) {
            libDirs.add(mcLibDir);
        }
        if (!this.downloadLibraries(librariesDir, libDirs)) {
            return false;
        }
        File clientTarget = new File(target, "client.jar");
        File serverTarget = new File(target, "server.jar");
        if (!this.downloadVanilla(clientTarget, "client")) return false;
        if (!this.downloadVanilla(serverTarget, "server")) {
            return false;
        }
        HashSet<File> outputs = new HashSet<File>();
        if (!this.process(outputs, this.processorsClient, librariesDir, clientTarget, target, this.base)) return false;
        if (!this.process(outputs, this.processorsServer, librariesDir, serverTarget, target, this.base)) {
            return false;
        }
        this.monitor.message("Building offline installer");
        this.monitor.message("Found Base: " + this.base);
        target = this.cleanTarget(target);
        this.monitor.message("Output: " + target);
        this.checkCancel();
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(target));){
            HashSet<String> seen = new HashSet<String>();
            this.monitor.message("Copying Base Installer Archive");
            ZipInputStream zin = new ZipInputStream(new FileInputStream(this.base));
            Object object = null;
            try {
                ZipEntry entry;
                while ((entry = zin.getNextEntry()) != null) {
                    zout.putNextEntry(this.getNewEntry(entry.getName()));
                    OfflineAction.copy(zin, (OutputStream)zout);
                    if (!entry.getName().startsWith("maven/") || entry.isDirectory()) continue;
                    seen.add(entry.getName().substring(6));
                }
            }
            catch (Throwable entry) {
                object = entry;
                throw entry;
            }
            finally {
                if (zin != null) {
                    if (object != null) {
                        try {
                            zin.close();
                        }
                        catch (Throwable entry) {
                            ((Throwable)object).addSuppressed(entry);
                        }
                    } else {
                        zin.close();
                    }
                }
            }
            for (Version.Library lib : this.getLibraries()) {
                Version.LibraryDownload download;
                Artifact artifact = lib.getName();
                if (!seen.add(artifact.getPath())) continue;
                File local = artifact.getLocalPath(librariesDir);
                Version.LibraryDownload libraryDownload = download = lib.getDownloads() == null ? null : lib.getDownloads().getArtifact();
                if (download == null) {
                    download = new Version.LibraryDownload();
                    download.setPath(artifact.getPath());
                }
                if (!local.exists()) {
                    if (download.getUrl() != null && !download.getUrl().isEmpty()) {
                        this.error("Library: " + artifact.getDescriptor() + " does not exist, but it should of been downloaded..");
                        this.monitor.message("Local Path: " + local.getAbsolutePath());
                        boolean bl = false;
                        return bl;
                    }
                    this.monitor.message("Skipping " + artifact.getDescriptor() + " as it's missing its URL, this is probably generated by the installer");
                    continue;
                }
                this.monitor.message("Adding: maven/" + artifact.getPath());
                zout.putNextEntry(this.getNewEntry("maven/" + artifact.getPath()));
                OfflineAction.copy(local, (OutputStream)zout);
                ++this.added;
            }
            this.monitor.message("Adding: cache/vanilla/client.jar");
            zout.putNextEntry(this.getNewEntry("cache/vanilla/client.jar"));
            OfflineAction.copy(clientTarget, (OutputStream)zout);
            this.monitor.message("Adding: cache/vanilla/server.jar");
            zout.putNextEntry(this.getNewEntry("cache/vanilla/server.jar"));
            OfflineAction.copy(serverTarget, (OutputStream)zout);
            String libPrefix = librariesDir.getAbsolutePath().replace('\\', '/');
            if (!libPrefix.endsWith("/")) {
                libPrefix = libPrefix + '/';
            }
            for (File output : outputs) {
                String path = output.getAbsolutePath().replace('\\', '/');
                if (!path.startsWith(libPrefix)) {
                    this.monitor.message("Skipping " + path);
                    continue;
                }
                String relative = "cache/" + path.substring(libPrefix.length());
                if (!output.exists()) {
                    this.error("Output Does Not Exist: " + output.getAbsolutePath());
                    this.monitor.message("Local Path: " + output.getAbsolutePath());
                    boolean bl = false;
                    return bl;
                }
                this.monitor.message("Adding: " + relative);
                zout.putNextEntry(this.getNewEntry(relative));
                OfflineAction.copy(output, (OutputStream)zout);
            }
            zout.putNextEntry(this.getNewEntry(OFFLINE_FLAG));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error("Failed to copy installer jar: " + e.getMessage());
            return false;
        }
    }

    @Override
    protected List<Version.Library> getLibraries() {
        List<Version.Library> tmp = super.getLibraries();
        tmp.addAll(Arrays.asList(this.processorsClient.getLibraries()));
        ArrayList<Version.Library> ret = new ArrayList<Version.Library>();
        HashSet<String> seen = new HashSet<String>();
        for (Version.Library lib : tmp) {
            if (!seen.add(lib.getName().getPath())) continue;
            ret.add(lib);
        }
        return ret;
    }

    private boolean process(Set<File> output, PostProcessors procs, File librariesDir, File serverTarget, File target, File installer) {
        Set<File> out = procs.process(librariesDir, serverTarget, target, installer);
        if (out == null) {
            return false;
        }
        output.addAll(out);
        return true;
    }

    @Override
    public boolean isPathValid(File target) {
        return target.exists() && target.isDirectory() && target.list().length == 0;
    }

    @Override
    public String getFileError(File target) {
        if (!target.exists()) {
            return "The specified directory does not exist<br/>It will be created";
        }
        if (!target.isDirectory()) {
            return "The specified path needs to be a directory";
        }
        return "There are already files at the target directory";
    }

    @Override
    public String getSuccessMessage() {
        return String.format("Successfully created offline installer, downloaded %d libraries", this.added);
    }

    public static File findInstallerBase() {
        try {
            URI uri = Util.class.getResource("/install_profile.json").toURI();
            if (!"jar".equals(uri.getScheme())) {
                throw new IllegalStateException("Could not find installer jar, if you're in a development environment, stick a pre-built installer jar in the gradle root directory and re-import your project");
            }
            int lastExcl = uri.getRawSchemeSpecificPart().lastIndexOf("!/");
            String path = uri.getRawSchemeSpecificPart().substring(0, lastExcl);
            return Paths.get(new URI(path)).toFile();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to locate installer jar!", e);
        }
    }

    private File cleanTarget(File target) {
        if (target.isFile()) {
            return target;
        }
        return new File(target, this.base.getName().substring(0, this.base.getName().length() - 4) + "-offline.jar");
    }

    private ZipEntry getNewEntry(String name) {
        ZipEntry ret = new ZipEntry(name);
        return ret;
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[256];
        while ((length = source.read(buf)) != -1) {
            target.write(buf, 0, length);
        }
    }

    private static void copy(File source, OutputStream target) throws IOException {
        try (FileInputStream stream = new FileInputStream(source);){
            OfflineAction.copy(stream, target);
        }
    }
}

