/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraftforge.client.model.generators.BlockModelBuilder;

public final class TransformationHelper {
    private static final double THRESHOLD = 0.9995;

    public static Quaternion quatFromXYZ(Vector3f xyz, boolean degrees) {
        return new Quaternion(xyz.m_122239_(), xyz.m_122260_(), xyz.m_122269_(), degrees);
    }

    public static Quaternion quatFromXYZ(float[] xyz, boolean degrees) {
        return new Quaternion(xyz[0], xyz[1], xyz[2], degrees);
    }

    public static Quaternion makeQuaternion(float[] values) {
        return new Quaternion(values[0], values[1], values[2], values[3]);
    }

    public static Vector3f lerp(Vector3f from, Vector3f to, float progress) {
        Vector3f res = from.m_122281_();
        res.m_122255_(to, progress);
        return res;
    }

    public static Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        float dot = v0.m_80140_() * v1.m_80140_() + v0.m_80150_() * v1.m_80150_() + v0.m_80153_() * v1.m_80153_() + v0.m_80156_() * v1.m_80156_();
        if (dot < 0.0f) {
            v1 = new Quaternion(-v1.m_80140_(), -v1.m_80150_(), -v1.m_80153_(), -v1.m_80156_());
            dot = -dot;
        }
        if ((double)dot > 0.9995) {
            float x = Mth.m_14179_((float)t, (float)v0.m_80140_(), (float)v1.m_80140_());
            float y = Mth.m_14179_((float)t, (float)v0.m_80150_(), (float)v1.m_80150_());
            float z = Mth.m_14179_((float)t, (float)v0.m_80153_(), (float)v1.m_80153_());
            float w = Mth.m_14179_((float)t, (float)v0.m_80156_(), (float)v1.m_80156_());
            return new Quaternion(x, y, z, w);
        }
        float angle01 = (float)Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = Mth.m_14031_((float)angle0t);
        float sin01 = Mth.m_14031_((float)angle01);
        float sin1t = Mth.m_14031_((float)(angle01 - angle0t));
        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;
        return new Quaternion(s0 * v0.m_80140_() + s1 * v1.m_80140_(), s0 * v0.m_80150_() + s1 * v1.m_80150_(), s0 * v0.m_80153_() + s1 * v1.m_80153_(), s0 * v0.m_80156_() + s1 * v1.m_80156_());
    }

    public static Transformation slerp(Transformation one, Transformation that, float progress) {
        return new Transformation(TransformationHelper.lerp(one.m_175940_(), that.m_175940_(), progress), TransformationHelper.slerp(one.m_121105_(), that.m_121105_(), progress), TransformationHelper.lerp(one.m_175941_(), that.m_175941_(), progress), TransformationHelper.slerp(one.m_175942_(), that.m_175942_(), progress));
    }

    public static boolean epsilonEquals(Vector4f v1, Vector4f v2, float epsilon) {
        return Mth.m_14154_((float)(v1.m_123601_() - v2.m_123601_())) < epsilon && Mth.m_14154_((float)(v1.m_123615_() - v2.m_123615_())) < epsilon && Mth.m_14154_((float)(v1.m_123616_() - v2.m_123616_())) < epsilon && Mth.m_14154_((float)(v1.m_123617_() - v2.m_123617_())) < epsilon;
    }

    public static class Deserializer
    implements JsonDeserializer<Transformation> {
        public Transformation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String transform = json.getAsString();
                if (transform.equals("identity")) {
                    return Transformation.m_121093_();
                }
                throw new JsonParseException("TRSR: unknown default string: " + transform);
            }
            if (json.isJsonArray()) {
                return new Transformation(Deserializer.parseMatrix(json));
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("TRSR: expected array or object, got: " + json);
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("matrix")) {
                Transformation ret = new Transformation(Deserializer.parseMatrix(obj.get("matrix")));
                if (obj.entrySet().size() > 1) {
                    throw new JsonParseException("TRSR: can't combine matrix and other keys");
                }
                return ret;
            }
            Vector3f translation = null;
            Quaternion leftRot = null;
            Vector3f scale = null;
            Quaternion rightRot = null;
            Vector3f origin = BlockModelBuilder.RootTransformBuilder.TransformOrigin.OPPOSING_CORNER.getVector();
            HashSet elements = new HashSet(obj.keySet());
            if (obj.has("translation")) {
                translation = new Vector3f(Deserializer.parseFloatArray(obj.get("translation"), 3, "Translation"));
                elements.remove("translation");
            }
            if (obj.has("rotation")) {
                leftRot = Deserializer.parseRotation(obj.get("rotation"));
                elements.remove("rotation");
            } else if (obj.has("left_rotation")) {
                leftRot = Deserializer.parseRotation(obj.get("left_rotation"));
                elements.remove("left_rotation");
            }
            if (obj.has("scale")) {
                if (!obj.get("scale").isJsonArray()) {
                    try {
                        float s = obj.get("scale").getAsNumber().floatValue();
                        scale = new Vector3f(s, s, s);
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("TRSR scale: expected number or array, got: " + obj.get("scale"));
                    }
                } else {
                    scale = new Vector3f(Deserializer.parseFloatArray(obj.get("scale"), 3, "Scale"));
                }
                elements.remove("scale");
            }
            if (obj.has("right_rotation")) {
                rightRot = Deserializer.parseRotation(obj.get("right_rotation"));
                elements.remove("right_rotation");
            } else if (obj.has("post-rotation")) {
                rightRot = Deserializer.parseRotation(obj.get("post-rotation"));
                elements.remove("post-rotation");
            }
            if (obj.has("origin")) {
                origin = Deserializer.parseOrigin(obj);
                elements.remove("origin");
            }
            if (!elements.isEmpty()) {
                throw new JsonParseException("TRSR: can either have single 'matrix' key, or a combination of 'translation', 'rotation' OR 'left_rotation', 'scale', 'post-rotation' (legacy) OR 'right_rotation', 'origin'. Found: " + String.join((CharSequence)", ", elements));
            }
            Transformation matrix = new Transformation(translation, leftRot, scale, rightRot);
            if (!BlockModelBuilder.RootTransformBuilder.TransformOrigin.CENTER.getVector().equals((Object)origin)) {
                Vector3f originFromCenter = origin.m_122281_();
                originFromCenter.m_122267_(BlockModelBuilder.RootTransformBuilder.TransformOrigin.CENTER.getVector());
                matrix = matrix.applyOrigin(originFromCenter);
            }
            return matrix;
        }

        private static Vector3f parseOrigin(JsonObject obj) {
            Vector3f origin = null;
            JsonElement originElement = obj.get("origin");
            if (originElement.isJsonArray()) {
                origin = new Vector3f(Deserializer.parseFloatArray(originElement, 3, "Origin"));
            } else if (originElement.isJsonPrimitive()) {
                String originString = originElement.getAsString();
                BlockModelBuilder.RootTransformBuilder.TransformOrigin originEnum = BlockModelBuilder.RootTransformBuilder.TransformOrigin.fromString(originString);
                if (originEnum == null) {
                    throw new JsonParseException("Origin: expected one of 'center', 'corner', 'opposing-corner'");
                }
                origin = originEnum.getVector();
            } else {
                throw new JsonParseException("Origin: expected an array or one of 'center', 'corner', 'opposing-corner'");
            }
            return origin;
        }

        public static Matrix4f parseMatrix(JsonElement e) {
            if (!e.isJsonArray()) {
                throw new JsonParseException("Matrix: expected an array, got: " + e);
            }
            JsonArray m = e.getAsJsonArray();
            if (m.size() != 3) {
                throw new JsonParseException("Matrix: expected an array of length 3, got: " + m.size());
            }
            float[] values = new float[16];
            for (int i = 0; i < 3; ++i) {
                if (!m.get(i).isJsonArray()) {
                    throw new JsonParseException("Matrix row: expected an array, got: " + m.get(i));
                }
                JsonArray r = m.get(i).getAsJsonArray();
                if (r.size() != 4) {
                    throw new JsonParseException("Matrix row: expected an array of length 4, got: " + r.size());
                }
                for (int j = 0; j < 4; ++j) {
                    try {
                        values[j * 4 + i] = r.get(j).getAsNumber().floatValue();
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("Matrix element: expected number, got: " + r.get(j));
                    }
                }
            }
            return new Matrix4f(values);
        }

        public static float[] parseFloatArray(JsonElement e, int length, String prefix) {
            if (!e.isJsonArray()) {
                throw new JsonParseException(prefix + ": expected an array, got: " + e);
            }
            JsonArray t = e.getAsJsonArray();
            if (t.size() != length) {
                throw new JsonParseException(prefix + ": expected an array of length " + length + ", got: " + t.size());
            }
            float[] ret = new float[length];
            for (int i = 0; i < length; ++i) {
                try {
                    ret[i] = t.get(i).getAsNumber().floatValue();
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException(prefix + " element: expected number, got: " + t.get(i));
                }
            }
            return ret;
        }

        public static Quaternion parseAxisRotation(JsonElement e) {
            Quaternion ret;
            block7: {
                if (!e.isJsonObject()) {
                    throw new JsonParseException("Axis rotation: object expected, got: " + e);
                }
                JsonObject obj = e.getAsJsonObject();
                if (obj.entrySet().size() != 1) {
                    throw new JsonParseException("Axis rotation: expected single axis object, got: " + e);
                }
                Map.Entry entry = (Map.Entry)obj.entrySet().iterator().next();
                try {
                    if (((String)entry.getKey()).equals("x")) {
                        ret = Vector3f.f_122223_.m_122240_(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("y")) {
                        ret = Vector3f.f_122225_.m_122240_(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("z")) {
                        ret = Vector3f.f_122227_.m_122240_(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    throw new JsonParseException("Axis rotation: expected single axis key, got: " + (String)entry.getKey());
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException("Axis rotation value: expected number, got: " + entry.getValue());
                }
            }
            return ret;
        }

        public static Quaternion parseRotation(JsonElement e) {
            if (e.isJsonArray()) {
                if (e.getAsJsonArray().get(0).isJsonObject()) {
                    Quaternion ret = Quaternion.f_80118_.m_80161_();
                    for (JsonElement a : e.getAsJsonArray()) {
                        ret.m_80148_(Deserializer.parseAxisRotation(a));
                    }
                    return ret;
                }
                if (e.isJsonArray()) {
                    JsonArray array = e.getAsJsonArray();
                    if (array.size() == 3) {
                        return TransformationHelper.quatFromXYZ(Deserializer.parseFloatArray(e, 3, "Rotation"), true);
                    }
                    return TransformationHelper.makeQuaternion(Deserializer.parseFloatArray(e, 4, "Rotation"));
                }
                throw new JsonParseException("Rotation: expected array or object, got: " + e);
            }
            if (e.isJsonObject()) {
                return Deserializer.parseAxisRotation(e);
            }
            throw new JsonParseException("Rotation: expected array or object, got: " + e);
        }
    }
}

