/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;

public class DelegatingResourcePack
extends AbstractPackResources {
    private final List<PackResources> delegates;
    private final Map<String, List<PackResources>> namespacesAssets;
    private final Map<String, List<PackResources>> namespacesData;
    private final String name;
    private final PackMetadataSection packInfo;

    public DelegatingResourcePack(String id, String name, PackMetadataSection packInfo, List<? extends PackResources> packs) {
        super(new File(id));
        this.name = name;
        this.packInfo = packInfo;
        this.delegates = ImmutableList.copyOf(packs);
        this.namespacesAssets = this.buildNamespaceMap(PackType.CLIENT_RESOURCES, this.delegates);
        this.namespacesData = this.buildNamespaceMap(PackType.SERVER_DATA, this.delegates);
    }

    private Map<String, List<PackResources>> buildNamespaceMap(PackType type, List<PackResources> packList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (PackResources pack : packList) {
            for (String namespace : pack.m_5698_(type)) {
                map.computeIfAbsent(namespace, k -> new ArrayList()).add(pack);
            }
        }
        map.replaceAll((k, list) -> ImmutableList.copyOf((Collection)list));
        return ImmutableMap.copyOf(map);
    }

    public String m_8017_() {
        return this.name;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.m_7991_().equals("pack")) {
            return (T)this.packInfo;
        }
        return null;
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String pathIn, String pathIn2, int maxDepth, Predicate<String> filter) {
        return this.delegates.stream().flatMap(r -> r.m_7466_(type, pathIn, pathIn2, maxDepth, filter).stream()).collect(Collectors.toList());
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? this.namespacesAssets.keySet() : this.namespacesData.keySet();
    }

    public void close() {
        for (PackResources pack : this.delegates) {
            pack.close();
        }
    }

    public InputStream m_5542_(String fileName) throws IOException {
        throw new ResourcePackFileNotFoundException(this.f_10203_, fileName);
    }

    protected InputStream m_5541_(String resourcePath) throws IOException {
        throw new ResourcePackFileNotFoundException(this.f_10203_, resourcePath);
    }

    protected boolean m_6105_(String resourcePath) {
        return false;
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        for (PackResources pack : this.getCandidatePacks(type, location)) {
            if (!pack.m_7211_(type, location)) continue;
            return pack.m_8031_(type, location);
        }
        throw new ResourcePackFileNotFoundException(this.f_10203_, DelegatingResourcePack.getFullPath(type, location));
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        for (PackResources pack : this.getCandidatePacks(type, location)) {
            if (!pack.m_7211_(type, location)) continue;
            return true;
        }
        return false;
    }

    private List<PackResources> getCandidatePacks(PackType type, ResourceLocation location) {
        Map<String, List<PackResources>> map = type == PackType.CLIENT_RESOURCES ? this.namespacesAssets : this.namespacesData;
        List<PackResources> packsWithNamespace = map.get(location.m_135827_());
        return packsWithNamespace == null ? Collections.emptyList() : packsWithNamespace;
    }

    private static String getFullPath(PackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }
}

