/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.HandshakeMessages;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RegistryManager ACTIVE = new RegistryManager("ACTIVE");
    public static final RegistryManager VANILLA = new RegistryManager("VANILLA");
    public static final RegistryManager FROZEN = new RegistryManager("FROZEN");
    BiMap<ResourceLocation, ForgeRegistry<? extends IForgeRegistryEntry<?>>> registries = HashBiMap.create();
    private BiMap<Class<? extends IForgeRegistryEntry<?>>, ResourceLocation> superTypes = HashBiMap.create();
    private Set<ResourceLocation> persisted = Sets.newHashSet();
    private Set<ResourceLocation> synced = Sets.newHashSet();
    private Map<ResourceLocation, ResourceLocation> legacyNames = new HashMap<ResourceLocation, ResourceLocation>();
    private final String name;

    public RegistryManager(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public <V extends IForgeRegistryEntry<V>> Class<V> getSuperType(ResourceLocation key) {
        return (Class)this.superTypes.inverse().get((Object)key);
    }

    public <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> getRegistry(ResourceLocation key) {
        return (ForgeRegistry)this.registries.get((Object)key);
    }

    public <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> getRegistry(ResourceKey<? extends Registry<V>> key) {
        return this.getRegistry(key.m_135782_());
    }

    public <V extends IForgeRegistryEntry<V>> IForgeRegistry<V> getRegistry(Class<? super V> cls) {
        return this.getRegistry((ResourceLocation)this.superTypes.get(cls));
    }

    public <V extends IForgeRegistryEntry<V>> ResourceLocation getName(IForgeRegistry<V> reg) {
        return (ResourceLocation)this.registries.inverse().get(reg);
    }

    public <V extends IForgeRegistryEntry<V>> ResourceLocation updateLegacyName(ResourceLocation legacyName) {
        ResourceLocation originalName = legacyName;
        while (this.getRegistry(legacyName) == null) {
            if ((legacyName = this.legacyNames.get(legacyName)) != null) continue;
            return originalName;
        }
        return legacyName;
    }

    public <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> getRegistry(ResourceLocation key, RegistryManager other) {
        if (!this.registries.containsKey((Object)key)) {
            ForgeRegistry<V> ot = other.getRegistry(key);
            if (ot == null) {
                return null;
            }
            this.registries.put((Object)key, ot.copy(this));
            this.superTypes.put(ot.getRegistrySuperType(), (Object)key);
            if (other.persisted.contains(key)) {
                this.persisted.add(key);
            }
            if (other.synced.contains(key)) {
                this.synced.add(key);
            }
            other.legacyNames.entrySet().stream().filter(e -> ((ResourceLocation)e.getValue()).equals((Object)key)).forEach(e -> this.addLegacyName((ResourceLocation)e.getKey(), (ResourceLocation)e.getValue()));
        }
        return this.getRegistry(key);
    }

    <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> createRegistry(ResourceLocation name, RegistryBuilder<V> builder) {
        HashSet parents = Sets.newHashSet();
        this.findSuperTypes(builder.getType(), parents);
        Sets.SetView overlappedTypes = Sets.intersection((Set)parents, (Set)this.superTypes.keySet());
        if (!overlappedTypes.isEmpty()) {
            Class foundType = (Class)overlappedTypes.iterator().next();
            LOGGER.error("Found existing registry of type {} named {}, you cannot create a new registry ({}) with type {}, as {} has a parent of that type", (Object)foundType, this.superTypes.get((Object)foundType), (Object)name, builder.getType(), builder.getType());
            throw new IllegalArgumentException("Duplicate registry parent type found - you can only have one registry for a particular super type");
        }
        ForgeRegistry<V> reg = new ForgeRegistry<V>(this, name, builder);
        this.registries.put((Object)name, reg);
        this.superTypes.put(builder.getType(), (Object)name);
        if (builder.getSaveToDisc()) {
            this.persisted.add(name);
        }
        if (builder.getSync()) {
            this.synced.add(name);
        }
        for (ResourceLocation legacyName : builder.getLegacyNames()) {
            this.addLegacyName(legacyName, name);
        }
        return this.getRegistry(name);
    }

    private void addLegacyName(ResourceLocation legacyName, ResourceLocation name) {
        if (this.legacyNames.containsKey(legacyName)) {
            throw new IllegalArgumentException("Legacy name conflict for registry " + name + ", upgrade path must be linear: " + legacyName);
        }
        this.legacyNames.put(legacyName, name);
    }

    private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
        if (type == null || type == Object.class) {
            return;
        }
        types.add(type);
        for (Class<?> interfac : type.getInterfaces()) {
            this.findSuperTypes(interfac, types);
        }
        this.findSuperTypes(type.getSuperclass(), types);
    }

    public Map<ResourceLocation, ForgeRegistry.Snapshot> takeSnapshot(boolean savingToDisc) {
        HashMap ret = Maps.newHashMap();
        Set<ResourceLocation> keys = savingToDisc ? this.persisted : this.synced;
        keys.forEach(name -> ret.put(name, this.getRegistry((ResourceLocation)name).makeSnapshot()));
        return ret;
    }

    public void clean() {
        this.persisted.clear();
        this.synced.clear();
        this.registries.clear();
        this.superTypes.clear();
    }

    public static List<Pair<String, HandshakeMessages.S2CRegistry>> generateRegistryPackets(boolean isLocal) {
        return !isLocal ? ACTIVE.takeSnapshot(false).entrySet().stream().map(e -> Pair.of((Object)("Registry " + e.getKey()), (Object)new HandshakeMessages.S2CRegistry((ResourceLocation)e.getKey(), (ForgeRegistry.Snapshot)e.getValue()))).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static List<ResourceLocation> getRegistryNamesForSyncToClient() {
        return RegistryManager.ACTIVE.registries.keySet().stream().filter(resloc -> RegistryManager.ACTIVE.synced.contains(resloc)).collect(Collectors.toList());
    }
}

