/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ObjectHolderRef
implements Consumer<Predicate<ResourceLocation>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private Field field;
    private ResourceLocation injectedObject;
    private boolean isValid;
    private ForgeRegistry<?> registry;

    public ObjectHolderRef(Field field, ResourceLocation injectedObject) {
        this(field, injectedObject.toString(), false);
    }

    ObjectHolderRef(Field field, String injectedObject, boolean extractFromExistingValues) {
        this.registry = this.getRegistryForType(field);
        this.field = field;
        boolean bl = this.isValid = this.registry != null;
        if (extractFromExistingValues) {
            try {
                Object existing = field.get(null);
                if (!this.isValid || existing == null || existing == this.registry.getDefault()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isValid = false;
                    return;
                }
                this.injectedObject = ((IForgeRegistryEntry)existing).getRegistryName();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.injectedObject = new ResourceLocation(injectedObject);
        }
        catch (ResourceLocationException e) {
            throw new IllegalArgumentException("Invalid @ObjectHolder annotation on \"" + field.toString() + "\"", e);
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that does not map to a registry. Ensure the registry was created during the RegistryEvent.NewRegistry event. (found : %s at %s.%s)", field.getType().getName(), field.getDeclaringClass().getName(), field.getName()));
        }
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            throw new RuntimeException("@ObjectHolder on final field, our transformer did not run? " + field.getDeclaringClass().getName() + "/" + field.getName());
        }
    }

    @Nullable
    private ForgeRegistry<?> getRegistryForType(Field field) {
        LinkedList typesToExamine = new LinkedList();
        typesToExamine.add(field.getType());
        ForgeRegistry registry = null;
        while (!typesToExamine.isEmpty() && registry == null) {
            Class type = (Class)typesToExamine.remove();
            Collections.addAll(typesToExamine, type.getInterfaces());
            if (!IForgeRegistryEntry.class.isAssignableFrom(type)) continue;
            registry = (ForgeRegistry)RegistryManager.ACTIVE.getRegistry(type);
            Class parentType = type.getSuperclass();
            if (parentType == null) continue;
            typesToExamine.add(parentType);
        }
        return registry;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void accept(Predicate<ResourceLocation> filter) {
        if (this.registry == null || !filter.test(this.registry.getRegistryName())) {
            return;
        }
        Object thing = this.isValid && this.registry.containsKey(this.injectedObject) && !this.registry.isDummied(this.injectedObject) ? this.registry.getValue(this.injectedObject) : null;
        if (thing == null) {
            LOGGER.debug("Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", (Object)this.injectedObject, (Object)this.field);
            return;
        }
        try {
            this.field.set(null, thing);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            LOGGER.warn("Unable to set {} with value {} ({})", (Object)this.field, thing, (Object)this.injectedObject, (Object)e);
        }
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObjectHolderRef)) {
            return false;
        }
        ObjectHolderRef o = (ObjectHolderRef)other;
        return this.field.equals(o.field);
    }
}

