/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerStatusPing {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int CHANNEL_TRUNCATE_LIMIT = 150;
    private static final int MOD_TRUNCATE_LIMIT = 150;
    private static volatile boolean warnedAboutTruncation = false;
    private transient Map<ResourceLocation, Pair<String, Boolean>> channels;
    private transient Map<String, String> mods;
    private transient int fmlNetworkVer;
    private transient boolean truncated;

    public ServerStatusPing() {
        this.channels = NetworkRegistry.buildChannelVersionsForListPing();
        this.mods = new HashMap<String, String>();
        ModList.get().forEachModContainer((modid, mc) -> this.mods.put((String)modid, mc.getCustomExtension(IExtensionPoint.DisplayTest.class).map(IExtensionPoint.DisplayTest::suppliedVersion).map(Supplier::get).orElse("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31")));
        this.fmlNetworkVer = 2;
        this.truncated = false;
    }

    private ServerStatusPing(Map<ResourceLocation, Pair<String, Boolean>> deserialized, Map<String, String> modMarkers, int fmlNetVer, boolean truncated) {
        this.channels = ImmutableMap.copyOf(deserialized);
        this.mods = modMarkers;
        this.fmlNetworkVer = fmlNetVer;
        this.truncated = truncated;
    }

    public Map<ResourceLocation, Pair<String, Boolean>> getRemoteChannels() {
        return this.channels;
    }

    public Map<String, String> getRemoteModData() {
        return this.mods;
    }

    public int getFMLNetworkVersion() {
        return this.fmlNetworkVer;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static class Serializer {
        public static ServerStatusPing deserialize(JsonObject forgeData, JsonDeserializationContext ctx) {
            try {
                Map<ResourceLocation, Pair<String, Boolean>> channels = StreamSupport.stream(GsonHelper.m_13933_((JsonObject)forgeData, (String)"channels").spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jo -> new ResourceLocation(GsonHelper.m_13906_((JsonObject)jo, (String)"res")), jo -> Pair.of((Object)GsonHelper.m_13906_((JsonObject)jo, (String)"version"), (Object)GsonHelper.m_13912_((JsonObject)jo, (String)"required"))));
                Map<String, String> mods = StreamSupport.stream(GsonHelper.m_13933_((JsonObject)forgeData, (String)"mods").spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jo -> GsonHelper.m_13906_((JsonObject)jo, (String)"modId"), jo -> GsonHelper.m_13906_((JsonObject)jo, (String)"modmarker")));
                int remoteFMLVersion = GsonHelper.m_13927_((JsonObject)forgeData, (String)"fmlNetworkVersion");
                boolean truncated = GsonHelper.m_13855_((JsonObject)forgeData, (String)"truncated", (boolean)false);
                return new ServerStatusPing(channels, mods, remoteFMLVersion, truncated);
            }
            catch (JsonSyntaxException e) {
                LOGGER.debug(NetworkConstants.NETWORK, "Encountered an error parsing status ping data", (Throwable)e);
                return null;
            }
        }

        public static JsonObject serialize(ServerStatusPing forgeData, JsonSerializationContext ctx) {
            boolean truncated;
            JsonObject obj = new JsonObject();
            JsonArray channels = new JsonArray();
            boolean bl = truncated = forgeData.channels.size() > 150 || forgeData.mods.size() > 150;
            if (truncated && !warnedAboutTruncation) {
                warnedAboutTruncation = true;
                LOGGER.warn("Heuristically truncating mod and/or impl channel list in server status ping packet. Compatibility report in the multiplayer screen may be inaccurate.");
            }
            forgeData.channels.entrySet().stream().limit(150L).forEach(entry -> {
                ResourceLocation namespace = (ResourceLocation)entry.getKey();
                Pair version = (Pair)entry.getValue();
                JsonObject mi = new JsonObject();
                mi.addProperty("res", namespace.toString());
                mi.addProperty("version", (String)version.getLeft());
                mi.addProperty("required", (Boolean)version.getRight());
                channels.add((JsonElement)mi);
            });
            obj.add("channels", (JsonElement)channels);
            JsonArray modTestValues = new JsonArray();
            forgeData.mods.entrySet().stream().limit(150L).forEach(entry -> {
                String modId = (String)entry.getKey();
                String value = (String)entry.getValue();
                JsonObject mi = new JsonObject();
                mi.addProperty("modId", modId);
                mi.addProperty("modmarker", value);
                modTestValues.add((JsonElement)mi);
            });
            obj.add("mods", (JsonElement)modTestValues);
            obj.addProperty("fmlNetworkVersion", (Number)forgeData.fmlNetworkVer);
            obj.addProperty("truncated", Boolean.valueOf(truncated));
            return obj;
        }
    }
}

