/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.internal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;

public class WorldPersistenceHooks {
    private static List<WorldPersistenceHook> worldPersistenceHooks = new ArrayList<WorldPersistenceHook>();

    public static void addHook(WorldPersistenceHook hook) {
        worldPersistenceHooks.add(hook);
    }

    public static void handleWorldDataSave(LevelStorageSource.LevelStorageAccess levelSave, WorldData serverInfo, CompoundTag tagCompound) {
        worldPersistenceHooks.forEach(wac -> tagCompound.m_128365_(wac.getModId(), (Tag)wac.getDataForWriting(levelSave, serverInfo)));
    }

    public static void handleWorldDataLoad(LevelStorageSource.LevelStorageAccess levelSave, WorldData serverInfo, CompoundTag tagCompound) {
        worldPersistenceHooks.forEach(wac -> wac.readData(levelSave, serverInfo, tagCompound.m_128469_(wac.getModId())));
    }

    public static interface WorldPersistenceHook {
        public String getModId();

        public CompoundTag getDataForWriting(LevelStorageSource.LevelStorageAccess var1, WorldData var2);

        public void readData(LevelStorageSource.LevelStorageAccess var1, WorldData var2, CompoundTag var3);
    }
}

