/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.util.FakePlayer;

public class FakePlayerFactory {
    private static GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    private static Map<GameProfile, FakePlayer> fakePlayers = Maps.newHashMap();
    private static WeakReference<FakePlayer> MINECRAFT_PLAYER = null;

    public static FakePlayer getMinecraft(ServerLevel level) {
        FakePlayer ret;
        FakePlayer fakePlayer = ret = MINECRAFT_PLAYER != null ? (FakePlayer)((Object)MINECRAFT_PLAYER.get()) : null;
        if (ret == null) {
            ret = FakePlayerFactory.get(level, MINECRAFT);
            MINECRAFT_PLAYER = new WeakReference<FakePlayer>(ret);
        }
        return ret;
    }

    public static FakePlayer get(ServerLevel level, GameProfile username) {
        if (!fakePlayers.containsKey(username)) {
            FakePlayer fakePlayer = new FakePlayer(level, username);
            fakePlayers.put(username, fakePlayer);
        }
        return fakePlayers.get(username);
    }

    public static void unloadLevel(ServerLevel level) {
        FakePlayer mc;
        fakePlayers.entrySet().removeIf(entry -> ((FakePlayer)((Object)((Object)entry.getValue()))).f_19853_ == level);
        if (MINECRAFT_PLAYER != null && MINECRAFT_PLAYER.get() != null && ((FakePlayer)((Object)FakePlayerFactory.MINECRAFT_PLAYER.get())).f_19853_ == level && (mc = (FakePlayer)((Object)MINECRAFT_PLAYER.get())) != null && mc.f_19853_ == level) {
            MINECRAFT_PLAYER = null;
        }
    }
}

