/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.ForgeEventFactory;

public interface IForgeBlockState {
    private BlockState self() {
        return (BlockState)this;
    }

    default public float getFriction(LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.self().m_60734_().getFriction(this.self(), world, pos, entity);
    }

    default public int getLightEmission(BlockGetter world, BlockPos pos) {
        return this.self().m_60734_().getLightEmission(this.self(), world, pos);
    }

    default public boolean isLadder(LevelReader world, BlockPos pos, LivingEntity entity) {
        return this.self().m_60734_().isLadder(this.self(), world, pos, entity);
    }

    default public boolean canHarvestBlock(BlockGetter world, BlockPos pos, Player player) {
        return this.self().m_60734_().canHarvestBlock(this.self(), world, pos, player);
    }

    default public boolean onDestroyedByPlayer(Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.self().m_60734_().onDestroyedByPlayer(this.self(), world, pos, player, willHarvest, fluid);
    }

    default public boolean isBed(BlockGetter world, BlockPos pos, @Nullable LivingEntity sleeper) {
        return this.self().m_60734_().isBed(this.self(), world, pos, (Entity)sleeper);
    }

    default public boolean isValidSpawn(LevelReader world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return this.self().m_60734_().isValidSpawn(this.self(), (BlockGetter)world, pos, type, entityType);
    }

    default public Optional<Vec3> getRespawnPosition(EntityType<?> type, LevelReader world, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        return this.self().m_60734_().getRespawnPosition(this.self(), type, world, pos, orientation, entity);
    }

    default public void setBedOccupied(Level world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        this.self().m_60734_().setBedOccupied(this.self(), world, pos, sleeper, occupied);
    }

    default public Direction getBedDirection(LevelReader world, BlockPos pos) {
        return this.self().m_60734_().getBedDirection(this.self(), world, pos);
    }

    default public float getExplosionResistance(BlockGetter world, BlockPos pos, Explosion explosion) {
        return this.self().m_60734_().getExplosionResistance(this.self(), world, pos, explosion);
    }

    default public ItemStack getCloneItemStack(HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.self().m_60734_().getCloneItemStack(this.self(), target, world, pos, player);
    }

    default public boolean addLandingEffects(ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return this.self().m_60734_().addLandingEffects(this.self(), worldserver, pos, state2, entity, numberOfParticles);
    }

    default public boolean addRunningEffects(Level world, BlockPos pos, Entity entity) {
        return this.self().m_60734_().addRunningEffects(this.self(), world, pos, entity);
    }

    default public boolean canSustainPlant(BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.self().m_60734_().canSustainPlant(this.self(), world, pos, facing, plantable);
    }

    default public boolean isFertile(BlockGetter world, BlockPos pos) {
        return this.self().m_60734_().isFertile(this.self(), world, pos);
    }

    default public boolean isConduitFrame(LevelReader world, BlockPos pos, BlockPos conduit) {
        return this.self().m_60734_().isConduitFrame(this.self(), world, pos, conduit);
    }

    default public boolean isPortalFrame(BlockGetter world, BlockPos pos) {
        return this.self().m_60734_().isPortalFrame(this.self(), world, pos);
    }

    default public int getExpDrop(LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return this.self().m_60734_().getExpDrop(this.self(), world, pos, fortune, silktouch);
    }

    default public BlockState rotate(LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.self().m_60734_().rotate(this.self(), world, pos, direction);
    }

    default public float getEnchantPowerBonus(LevelReader world, BlockPos pos) {
        return this.self().m_60734_().getEnchantPowerBonus(this.self(), world, pos);
    }

    default public void onNeighborChange(LevelReader world, BlockPos pos, BlockPos neighbor) {
        this.self().m_60734_().onNeighborChange(this.self(), world, pos, neighbor);
    }

    default public boolean shouldCheckWeakPower(LevelReader world, BlockPos pos, Direction side) {
        return this.self().m_60734_().shouldCheckWeakPower(this.self(), world, pos, side);
    }

    default public boolean getWeakChanges(LevelReader world, BlockPos pos) {
        return this.self().m_60734_().getWeakChanges(this.self(), world, pos);
    }

    default public SoundType getSoundType(LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.self().m_60734_().getSoundType(this.self(), world, pos, entity);
    }

    @Nullable
    default public float[] getBeaconColorMultiplier(LevelReader world, BlockPos pos, BlockPos beacon) {
        return this.self().m_60734_().getBeaconColorMultiplier(this.self(), world, pos, beacon);
    }

    default public BlockState getStateAtViewpoint(BlockGetter world, BlockPos pos, Vec3 viewpoint) {
        return this.self().m_60734_().getStateAtViewpoint(this.self(), world, pos, viewpoint);
    }

    default public boolean isSlimeBlock() {
        return this.self().m_60734_().isSlimeBlock(this.self());
    }

    default public boolean isStickyBlock() {
        return this.self().m_60734_().isStickyBlock(this.self());
    }

    default public boolean canStickTo(BlockState other) {
        return this.self().m_60734_().canStickTo(this.self(), other);
    }

    default public int getFlammability(BlockGetter world, BlockPos pos, Direction face) {
        return this.self().m_60734_().getFlammability(this.self(), world, pos, face);
    }

    default public boolean isFlammable(BlockGetter world, BlockPos pos, Direction face) {
        return this.self().m_60734_().isFlammable(this.self(), world, pos, face);
    }

    default public void onCaughtFire(Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.self().m_60734_().onCaughtFire(this.self(), world, pos, face, igniter);
    }

    default public int getFireSpreadSpeed(BlockGetter world, BlockPos pos, Direction face) {
        return this.self().m_60734_().getFireSpreadSpeed(this.self(), world, pos, face);
    }

    default public boolean isFireSource(LevelReader world, BlockPos pos, Direction side) {
        return this.self().m_60734_().isFireSource(this.self(), world, pos, side);
    }

    default public boolean canEntityDestroy(BlockGetter world, BlockPos pos, Entity entity) {
        return this.self().m_60734_().canEntityDestroy(this.self(), world, pos, entity);
    }

    default public boolean isBurning(BlockGetter world, BlockPos pos) {
        return this.self().m_60734_().isBurning(this.self(), world, pos);
    }

    @Nullable
    default public BlockPathTypes getBlockPathType(BlockGetter world, BlockPos pos) {
        return this.getBlockPathType(world, pos, null);
    }

    @Nullable
    default public BlockPathTypes getBlockPathType(BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return this.self().m_60734_().getAiPathNodeType(this.self(), world, pos, entity);
    }

    default public boolean canDropFromExplosion(BlockGetter world, BlockPos pos, Explosion explosion) {
        return this.self().m_60734_().canDropFromExplosion(this.self(), world, pos, explosion);
    }

    default public void onBlockExploded(Level world, BlockPos pos, Explosion explosion) {
        this.self().m_60734_().onBlockExploded(this.self(), world, pos, explosion);
    }

    default public boolean collisionExtendsVertically(BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return this.self().m_60734_().collisionExtendsVertically(this.self(), world, pos, collidingEntity);
    }

    default public boolean shouldDisplayFluidOverlay(BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return this.self().m_60734_().shouldDisplayFluidOverlay(this.self(), world, pos, fluidState);
    }

    @Nullable
    default public BlockState getToolModifiedState(Level world, BlockPos pos, Player player, ItemStack stack, ToolAction toolAction) {
        BlockState eventState = ForgeEventFactory.onToolUse(this.self(), world, pos, player, stack, toolAction);
        return eventState != this.self() ? eventState : this.self().m_60734_().getToolModifiedState(this.self(), world, pos, player, stack, toolAction);
    }

    default public boolean isScaffolding(LivingEntity entity) {
        return this.self().m_60734_().isScaffolding(this.self(), (LevelReader)entity.f_19853_, entity.m_142538_(), entity);
    }

    default public boolean canRedstoneConnectTo(BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        return this.self().m_60734_().canConnectRedstone(this.self(), world, pos, direction);
    }
}

