/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface IForgeBlockEntity
extends ICapabilitySerializable<CompoundTag> {
    public static final AABB INFINITE_EXTENT_AABB = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    private BlockEntity self() {
        return (BlockEntity)this;
    }

    @Override
    default public void deserializeNBT(CompoundTag nbt) {
        this.self().m_142466_(nbt);
    }

    @Override
    default public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        this.self().save(ret);
        return ret;
    }

    default public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.self().m_142466_(compoundtag);
        }
    }

    default public void handleUpdateTag(CompoundTag tag) {
        this.self().m_142466_(tag);
    }

    public CompoundTag getTileData();

    default public void onChunkUnloaded() {
    }

    default public void onLoad() {
        this.requestModelDataUpdate();
    }

    default public AABB getRenderBoundingBox() {
        AABB bb = INFINITE_EXTENT_AABB;
        BlockState state = this.self().m_58900_();
        Block block = state.m_60734_();
        BlockPos pos = this.self().m_58899_();
        if (block == Blocks.f_50201_) {
            bb = new AABB(pos, pos.m_142082_(1, 1, 1));
        } else if (block == Blocks.f_50087_ || block == Blocks.f_50325_) {
            bb = new AABB(pos.m_142082_(-1, 0, -1), pos.m_142082_(2, 2, 2));
        } else if (block == Blocks.f_50677_) {
            bb = INFINITE_EXTENT_AABB;
        } else if (block != null && block != Blocks.f_50273_) {
            AABB cbb = null;
            try {
                VoxelShape collisionShape = state.m_60812_((BlockGetter)this.self().m_58904_(), pos);
                if (!collisionShape.m_83281_()) {
                    cbb = collisionShape.m_83215_().m_82338_(pos);
                }
            }
            catch (Exception e) {
                cbb = new AABB(pos.m_142082_(-1, 0, -1), pos.m_142082_(1, 1, 1));
            }
            if (cbb != null) {
                bb = cbb;
            }
        }
        return bb;
    }

    default public void requestModelDataUpdate() {
        BlockEntity te = this.self();
        Level world = te.m_58904_();
        if (world != null && world.f_46443_) {
            ModelDataManager.requestModelDataRefresh(te);
        }
    }

    @Nonnull
    default public IModelData getModelData() {
        return EmptyModelData.INSTANCE;
    }
}

