/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.AssetIndex;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.DefaultClientPackResources;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadableResourceManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.resource.ResourcePackLoader;

public class ExistingFileHelper {
    private final SimpleReloadableResourceManager clientResources;
    private final SimpleReloadableResourceManager serverData;
    private final boolean enable;
    private final Multimap<PackType, ResourceLocation> generated = HashMultimap.create();

    public ExistingFileHelper(Collection<Path> existingPacks, Set<String> existingMods, boolean enable, @Nullable String assetIndex, @Nullable File assetsDir) {
        Object pack;
        this.clientResources = new SimpleReloadableResourceManager(PackType.CLIENT_RESOURCES);
        this.serverData = new SimpleReloadableResourceManager(PackType.SERVER_DATA);
        this.clientResources.m_10880_((PackResources)new VanillaPackResources(ClientPackSource.f_174791_, new String[]{"minecraft", "realms"}));
        if (assetIndex != null && assetsDir != null) {
            this.clientResources.m_10880_((PackResources)new DefaultClientPackResources(ClientPackSource.f_174791_, new AssetIndex(assetsDir, assetIndex)));
        }
        this.serverData.m_10880_((PackResources)new VanillaPackResources(ServerPacksSource.f_143904_, new String[]{"minecraft"}));
        for (Path existing : existingPacks) {
            File file = existing.toFile();
            pack = file.isDirectory() ? new FolderPackResources(file) : new FilePackResources(file);
            this.clientResources.m_10880_((PackResources)pack);
            this.serverData.m_10880_((PackResources)pack);
        }
        for (String existingMod : existingMods) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(existingMod);
            if (modFileInfo == null) continue;
            pack = ResourcePackLoader.createPackForMod(modFileInfo);
            this.clientResources.m_10880_((PackResources)pack);
            this.serverData.m_10880_((PackResources)pack);
        }
        this.enable = enable;
    }

    private ResourceManager getManager(PackType packType) {
        return packType == PackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
    }

    private ResourceLocation getLocation(ResourceLocation base, String suffix, String prefix) {
        return new ResourceLocation(base.m_135827_(), prefix + "/" + base.m_135815_() + suffix);
    }

    public boolean exists(ResourceLocation loc, PackType packType) {
        if (!this.enable) {
            return true;
        }
        return this.generated.get((Object)packType).contains(loc) || this.getManager(packType).m_7165_(loc);
    }

    public boolean exists(ResourceLocation loc, IResourceType type) {
        return this.exists(this.getLocation(loc, type.getSuffix(), type.getPrefix()), type.getPackType());
    }

    public boolean exists(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) {
        return this.exists(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    public void trackGenerated(ResourceLocation loc, IResourceType type) {
        this.generated.put((Object)type.getPackType(), (Object)this.getLocation(loc, type.getSuffix(), type.getPrefix()));
    }

    public void trackGenerated(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) {
        this.generated.put((Object)packType, (Object)this.getLocation(loc, pathSuffix, pathPrefix));
    }

    @VisibleForTesting
    public Resource getResource(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) throws IOException {
        return this.getResource(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    @VisibleForTesting
    public Resource getResource(ResourceLocation loc, PackType packType) throws IOException {
        return this.getManager(packType).m_142591_(loc);
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public static interface IResourceType {
        public PackType getPackType();

        public String getSuffix();

        public String getPrefix();
    }

    public static class ResourceType
    implements IResourceType {
        final PackType packType;
        final String suffix;
        final String prefix;

        public ResourceType(PackType type, String suffix, String prefix) {
            this.packType = type;
            this.suffix = suffix;
            this.prefix = prefix;
        }

        @Override
        public PackType getPackType() {
            return this.packType;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }
}

