/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.TransformationHelper;

public class PerspectiveMapWrapper
implements IDynamicBakedModel {
    private final BakedModel parent;
    private final ImmutableMap<ItemTransforms.TransformType, Transformation> transforms;
    private final OverrideListWrapper overrides = new OverrideListWrapper();

    public PerspectiveMapWrapper(BakedModel parent, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms) {
        this.parent = parent;
        this.transforms = transforms;
    }

    public PerspectiveMapWrapper(BakedModel parent, ModelState state) {
        this(parent, PerspectiveMapWrapper.getTransforms(state));
    }

    public static ImmutableMap<ItemTransforms.TransformType, Transformation> getTransforms(ModelState state) {
        EnumMap<ItemTransforms.TransformType, Transformation> map = new EnumMap<ItemTransforms.TransformType, Transformation>(ItemTransforms.TransformType.class);
        for (ItemTransforms.TransformType type : ItemTransforms.TransformType.values()) {
            Transformation tr = state.getPartTransformation((Object)type);
            if (tr.isIdentity()) continue;
            map.put(type, tr);
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<ItemTransforms.TransformType, Transformation> getTransforms(ItemTransforms transforms) {
        EnumMap<ItemTransforms.TransformType, Transformation> map = new EnumMap<ItemTransforms.TransformType, Transformation>(ItemTransforms.TransformType.class);
        for (ItemTransforms.TransformType type : ItemTransforms.TransformType.values()) {
            if (!transforms.m_111810_(type)) continue;
            map.put(type, TransformationHelper.toTransformation(transforms.m_111808_(type)));
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<ItemTransforms.TransformType, Transformation> getTransformsWithFallback(ModelState state, ItemTransforms transforms) {
        EnumMap<ItemTransforms.TransformType, Transformation> map = new EnumMap<ItemTransforms.TransformType, Transformation>(ItemTransforms.TransformType.class);
        for (ItemTransforms.TransformType type : ItemTransforms.TransformType.values()) {
            Transformation tr = state.getPartTransformation((Object)type);
            if (!tr.isIdentity()) {
                map.put(type, tr);
                continue;
            }
            if (!transforms.m_111810_(type)) continue;
            map.put(type, TransformationHelper.toTransformation(transforms.m_111808_(type)));
        }
        return ImmutableMap.copyOf(map);
    }

    public static BakedModel handlePerspective(BakedModel model, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        Transformation tr = (Transformation)transforms.getOrDefault((Object)cameraTransformType, (Object)Transformation.m_121093_());
        if (!tr.isIdentity()) {
            tr.push(mat);
        }
        return model;
    }

    public static BakedModel handlePerspective(BakedModel model, ModelState state, ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        Transformation tr = state.getPartTransformation((Object)cameraTransformType);
        if (!tr.isIdentity()) {
            tr.push(mat);
        }
        return model;
    }

    public boolean m_7541_() {
        return this.parent.m_7541_();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.parent.useAmbientOcclusion(state);
    }

    public boolean m_7539_() {
        return this.parent.m_7539_();
    }

    public boolean m_7547_() {
        return this.parent.m_7547_();
    }

    public boolean m_7521_() {
        return this.parent.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.parent.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.parent.m_7442_();
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        return this.parent.getQuads(state, side, rand, extraData);
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.transforms, cameraTransformType, poseStack);
    }

    private class OverrideListWrapper
    extends ItemOverrides {
        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            model = PerspectiveMapWrapper.this.parent.m_7343_().m_173464_(PerspectiveMapWrapper.this.parent, stack, worldIn, entityIn, seed);
            return new PerspectiveMapWrapper(model, PerspectiveMapWrapper.this.transforms);
        }

        public ImmutableList<ItemOverrides.BakedOverride> getOverrides() {
            return PerspectiveMapWrapper.this.parent.m_7343_().getOverrides();
        }
    }
}

