/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="forge", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModelDataManager {
    private static WeakReference<Level> currentLevel = new WeakReference<Object>(null);
    private static final Map<ChunkPos, Set<BlockPos>> needModelDataRefresh = new ConcurrentHashMap<ChunkPos, Set<BlockPos>>();
    private static final Map<ChunkPos, Map<BlockPos, IModelData>> modelDataCache = new ConcurrentHashMap<ChunkPos, Map<BlockPos, IModelData>>();

    private static void cleanCaches(Level world) {
        Preconditions.checkNotNull((Object)world, (Object)"World must not be null");
        Preconditions.checkArgument((world == Minecraft.m_91087_().f_91073_ ? 1 : 0) != 0, (Object)"Cannot use model data for a world other than the current client world");
        if (world != currentLevel.get()) {
            currentLevel = new WeakReference<Level>(world);
            needModelDataRefresh.clear();
            modelDataCache.clear();
        }
    }

    public static void requestModelDataRefresh(BlockEntity te) {
        Preconditions.checkNotNull((Object)te, (Object)"Tile entity must not be null");
        Level world = te.m_58904_();
        ModelDataManager.cleanCaches(world);
        needModelDataRefresh.computeIfAbsent(new ChunkPos(te.m_58899_()), $ -> Collections.synchronizedSet(new HashSet())).add(te.m_58899_());
    }

    private static void refreshModelData(Level world, ChunkPos chunk) {
        ModelDataManager.cleanCaches(world);
        Set<BlockPos> needUpdate = needModelDataRefresh.remove(chunk);
        if (needUpdate != null) {
            Map data = modelDataCache.computeIfAbsent(chunk, $ -> new ConcurrentHashMap());
            for (BlockPos pos : needUpdate) {
                BlockEntity toUpdate = world.m_7702_(pos);
                if (toUpdate != null && !toUpdate.m_58901_()) {
                    data.put(pos, toUpdate.getModelData());
                    continue;
                }
                data.remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getChunk().getWorldForge().m_5776_()) {
            return;
        }
        ChunkPos chunk = event.getChunk().m_7697_();
        needModelDataRefresh.remove(chunk);
        modelDataCache.remove(chunk);
    }

    @Nullable
    public static IModelData getModelData(Level world, BlockPos pos) {
        return ModelDataManager.getModelData(world, new ChunkPos(pos)).get(pos);
    }

    public static Map<BlockPos, IModelData> getModelData(Level world, ChunkPos pos) {
        Preconditions.checkArgument((boolean)world.f_46443_, (Object)"Cannot request model data for server world");
        ModelDataManager.refreshModelData(world, pos);
        return modelDataCache.getOrDefault(pos, Collections.emptyMap());
    }
}

